// fileDialog.cpp

#include "fileDialog.h"
#include "utilities/utilities.h"

fileDialog::fileDialog(QWidget *parent) :
    QDialog(parent)
{
    setWindowTitle("Select File");
    setMinimumSize(550,450);
    got_cancel = false;

    int m = 10;
    int row = 0;
    QGridLayout *mainLayout = new QGridLayout(this);
    mainLayout->setContentsMargins(m,m,m,m);
    mainLayout->setSpacing(10);
    setLayout(mainLayout);

    QLabel *info1 = new QLabel("Enter file Name: or Path: or navigate in tree list.",this);
    mainLayout->addWidget(info1,row,0,1,4);
    row++;

    // file name row
    name = new QLabel("Name:",this);
    nameEd = new QLineEdit(this);
    mainLayout->addWidget(name,row,0,1,1);
    mainLayout->addWidget(nameEd,row,1,1,3);
    connect(nameEd,SIGNAL(textChanged(QString)),this,SLOT(on_name_change(QString)));
    row++;

    // path row
    path = new QLabel("Path:",this);
    pathEd = new QLineEdit(this);
    mainLayout->addWidget(path,row,0,1,1);
    mainLayout->addWidget(pathEd,row,1,1,3);
    connect(pathEd,SIGNAL(textChanged(QString)),this,SLOT(on_path_change(QString)));
    row++;

    QLabel *info2 = new QLabel("Green if exists. Red if new.",this);
    mainLayout->addWidget(info2,row,0,1,4);
    row++;

    //= Directory Tree
    treeWidget = new QTreeWidget(this);
    treeWidget->setAlternatingRowColors(true);
    treeWidget->setRootIsDecorated(true);
    treeWidget->setUniformRowHeights(true);
    treeWidget->setSortingEnabled(false);
    treeWidget->setSelectionMode(QAbstractItemView::SingleSelection);
    treeWidget->setSelectionBehavior(QAbstractItemView::SelectRows);
    //treeWidget->setMinimumSize(250,250);

    treeWidget->headerItem()->setText(C_TYPE, "Type");
    treeWidget->headerItem()->setText(C_NAME, "Name");
    connect( treeWidget,
             SIGNAL( itemSelectionChanged() ),
             SLOT( on_tree_selection_changed() )
    );
    mainLayout->addWidget(treeWidget,row,0,10,4);
    row += 10;

    QPushButton *cancel = new QPushButton(this);
    cancel->setText("Cancel");
    mainLayout->addWidget(cancel,row,0,1,2);
    connect(cancel, SIGNAL(clicked()), this, SLOT(on_cancel()));

    QPushButton *ok = new QPushButton(this);
    ok->setText("Ok");
    mainLayout->addWidget(ok,row,2,1,2);
    connect(ok, SIGNAL(clicked()), this, SLOT(on_ok()));

}

void fileDialog::fill_tree()
{
    // fill the tree
    QString tmp(pathEd->text());
    if (tmp == "<root>")
        tmp = "/";
    QStringList filt("*");
    QStringList fList = findFiles(tmp,filt,false);  // get file list
    QStringList dList = findDirs(tmp,false);              // get directory list

    treeWidget->setUpdatesEnabled(false);
    treeWidget->model()->removeRows(0, treeWidget->model()->rowCount());
    QTreeWidgetItem *parentItem; // = new QTreeWidgetItem();
    parentItem = treeWidget->invisibleRootItem();
    QTreeWidgetItem *fileItem = new QTreeWidgetItem(parentItem);
    fileItem->setText(C_TYPE,"D");
    fileItem->setText(C_NAME,"..");
    int i, ind;
    QString fil;
    for (i = 0; i < dList.size(); ++i) {
        fil = dList.at(i);
        ind = fil.indexOf(QChar('/'));
        // march to last '/' in path
        while (ind >= 0) {
            fil = fil.mid(ind + 1);
            ind = fil.indexOf(QChar('/'));
        }
        QTreeWidgetItem *fi = new QTreeWidgetItem(parentItem);
        fi->setText(C_TYPE,"D");
        fi->setText(C_NAME,fil);
    }
    for (i = 0; i < fList.size(); ++i) {
        fil = fList.at(i);
        ind = fil.indexOf(QChar('/'));
        // march to last '/' in path
        while (ind >= 0) {
            fil = fil.mid(ind + 1);
            ind = fil.indexOf(QChar('/'));
        }
        QTreeWidgetItem *fi = new QTreeWidgetItem(parentItem);
        fi->setText(C_TYPE,"F");
        fi->setText(C_NAME,fil);
    }
    treeWidget->setUpdatesEnabled(true);
}

void fileDialog::init(QString prev)
{
    int ind, siz;
    QString tmp = prev;
    QString fil = prev;
    ind = tmp.indexOf(QChar('/'));
    siz = 0;
    // march to last '/' in path
    while (ind >= 0) {
        tmp = tmp.mid(ind + 1);
        siz = tmp.size();
        ind = tmp.indexOf(QChar('/'));
    }
    if (siz > 0) {
        fil = tmp;
        tmp = prev;
        tmp.chop(siz); // This is the DIRECTORY
        tmp = QDir::cleanPath(tmp);
    } else {
        tmp = util_getCurrentWorkDirectory();
    }
    nameEd->setText(fil);
    pathEd->setText(tmp);
    fill_tree();
    on_name_change(fil);
    on_path_change(tmp);
}

QString fileDialog::getFileName()
{
    if (got_cancel)
        return "";
    QString name = nameEd->text();
    QString path = pathEd->text();
    if (name.length() == 0)
        return name;
    if (path == "<root>")
        return "/"+name;
    return path+"/"+name;
}

void fileDialog::on_ok()
{
    close();
}

void fileDialog::on_cancel()
{
    nameEd->setText("");
    got_cancel = true;
    close();
}

void fileDialog::on_tree_selection_changed()
{
    QTreeWidgetItem *item = treeWidget->currentItem();
    if (!item) {
        //outLog("on_tree_selection_changed: no selected item");
        //nameEd->setText("");
        return;
    }
    QString type = item->text(C_TYPE);
    QString name = item->text(C_NAME);
    //= Check there is item and it has a name
    if ((type.length() == 0)||(name.length() == 0)) {
        outLog("on_tree_selection_changed: no C_TYPE ir C_NAME item");
        nameEd->setText("");
        return;
    }
    QString path = pathEd->text();
    int ind, siz;
    QString tmp;
    if (type == "D") {
        if (name == "..") {
            // go up one level if possible
            if (path == "<root>")
                return;
            tmp = path;
            siz = 0;
            ind = tmp.indexOf(QChar('/'));
            // march to last '/' in path
            while (ind >= 0) {
                tmp = tmp.mid(ind + 1);
                siz = tmp.length();
                ind = tmp.indexOf(QChar('/'));
            }
            if (siz) {
                path.chop(siz+1);   // remove last entry, and separator
                if (path.length() == 0)
                    path = "<root>";
                pathEd->setText(path);
            }
        } else {
            // go down into this directory
            if (path == "<root>")
                path= "";
            path.append("/"+name);
            pathEd->setText(path);
        }
        fill_tree(); // and reset the LIST
        on_path_change(path);
    } else {
        // file selected
        nameEd->setText(name);
        on_name_change(name);
    }
}

void fileDialog::on_name_change(QString txt)
{
    QString dir(pathEd->text());
    QFile file(dir+"/"+txt);
    QString style("color:red");
    if (file.exists()) {
        style = "color:green";
    }
    name->setStyleSheet(style);
}

void fileDialog::on_path_change(QString txt)
{
    QDir dir(txt);
    QString style("color:red");
    if (dir.exists() || (txt == "<root>")) {
        style = "color:green";
        on_name_change(nameEd->text());
        fill_tree();
    }
    path->setStyleSheet(style);
}


// eof - fileDialog.cpp
