#ifndef FILEDIALOG_H
#define FILEDIALOG_H


#include "app_config.h"
#include <QWidget>
#include <QDialog>
#include <QLabel>
#include <QLineEdit>
#include <QGridLayout>
#include <QPushButton>
#include <QTreeWidget>
#include <QAbstractItemView>

enum COLS{
    C_TYPE = 0,
    C_NAME
};

class fileDialog : public QDialog
{
    Q_OBJECT
public:
    explicit fileDialog(QWidget *parent = 0);

    QLineEdit *nameEd;  // = new QLineEdit(this);
    QLineEdit *pathEd;  // = new QLineEdit(this);
    QTreeWidget *treeWidget;    // = new QTreeWidget(this);
    void init(QString prev);
    QString getFileName();
    bool got_cancel;

signals:
    void set_file(QString);

public slots:
    void on_ok();
    void on_cancel();
    void on_tree_selection_changed();
    void on_name_change(QString);
    void on_path_change(QString);


private:
    void fill_tree();   // using pathEd->text()
    QLabel *name;       // = new QLabel("Name:",this);
    QLabel *path;       // = new QLabel("Path:",this);


};


#endif // FILEDIALOG_H
