/* ==================================================
   qt_osm_map project
   Created: Geoff R. McLane - Sep 2011
   License: GPL2 (or later)
   With special thanks to Yves for FGx, and its map widget
   ================================================== */

#include "app_config.h"
#include "mainwindow.h"
#include "osm_map.h"
#include "testdialog.h"
#include "utilities/utilities.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    QString tmp;
    debug_mode = false;

#ifdef USE_INI_FILE
    tmp = get_data_file(DEF_INI_FILE);
    settings = new QSettings(tmp,QSettings::IniFormat,this);
    tmp = "MainWindow: Using INI file ["+tmp+"]";
#else // !USE_INI_FILE
    settings = new QSettings(this);
    tmp = "MainWindow: Using 'generic' global settings";
#endif // USE_INI_FILE y/b

    util_setStdLogFile();   // create 'standard' LOG file
    outLog(tmp);            // advise type of settings used

    // restore windows size and postion - saved at closeEvent(QCloseEvent*)
    restoreGeometry(settings->value("mainWindowGeometry").toByteArray());

    QWidget *widget = new QWidget(this);
    setCentralWidget(widget);

    int m = 10;
    QVBoxLayout *mainLayout = new QVBoxLayout(this);
    mainLayout->setContentsMargins(m,m,m,m);
    mainLayout->setSpacing(0);
    widget->setLayout(mainLayout);
    //centralWidget()->setLayout(mainLayout);

    QMenuBar *menuBar = new QMenuBar(this);

    mainLayout->addWidget(menuBar);

    menuFile = new QMenu(tr("&File"),this);
    exitAct = menuFile->addAction(tr("&Quit"),this,SLOT(on_exit()));
    //connect(exitAct,SIGNAL(triggered()),this,SLOT(on_exit()));
    menuBar->addMenu(menuFile);

    menuTest = new QMenu(tr("&Test"),this);
    testAct = menuTest->addAction(tr("&Move Map..."),this,SLOT(on_test1()));
    testAct2 = menuTest->addAction(tr("&Get File..."),this,SLOT(on_test2()));
    menuBar->addMenu(menuTest);

    menuHelp = new QMenu(tr("&Help"),this);
    helpAct = menuHelp->addAction(tr("&About"),this,SLOT(on_about()));
    abtqtAct = menuHelp->addAction(tr("&About Qt"),this,SLOT(on_about_qt()));
    menuBar->addMenu(menuHelp);

    osmmap = new osmMap(this);
    osmmap->load_map("airport");
    // osmmap->zoom_to_airport("YGIL"); - this FAILS
    // and this??? osmmap->zoom_to_latlon("-31.699", "148.635", 12);

    mainLayout->addWidget(osmmap);

    tmp = settings->value(S_FILENAME, "NewProfile.ini").toString();
    infoLabel = new QLabel("FILE: "+tmp,this);
    mainLayout->addWidget(infoLabel);

    statusBar = new QStatusBar(this);
    labelTime = new QLabel(tr("00:00:00"),this);
    labelTime->setFrameStyle(QFrame::Panel | QFrame::Raised);
    statusBar->addPermanentWidget(labelTime);

    mainLayout->addWidget(statusBar);

    done_setmap = false;
    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(on_time_out()));
    timer->start(1000);


    m_time.start(); // start a time counter

}

MainWindow::~MainWindow()
{

}

void MainWindow::on_exit()
{
    close();
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    settings->setValue("mainWindowGeometry", saveGeometry());
    outLog(util_getDateTimestg()+" - Application close",0x8001);
    event->accept();

}

void MainWindow::on_about()
{
    QString msg;
    msg = "Version: ";
    msg.append(APP_VERS);
    msg.append(", dated ");
    msg.append(APP_DATE);
    msg.append("\n");
    msg.append("Built: ");
    msg.append(__DATE__);
    msg.append(" at ");
    msg.append(__TIME__);
    msg.append("\n\n");
    msg.append("Qt Test Gui shows various aspects of Qt, and\n");
    msg.append("to load and show an OpenStreetMap map\n");
    msg.append("License: GPL v2 or later\n\n");
    // msg.append("Source: http://geoffair.org/projects/qt_osm_map.htm");
    msg.append("The session log file is [");
    msg.append(util_getLogFile());
    msg.append("]\n");
    QMessageBox::about(this, tr("About Qt OSM Map"), msg);
}

void MainWindow::on_about_qt()
{
    QMessageBox::aboutQt(this, "About Qt");
}

void MainWindow::move_map_position(QString lat, QString lon, int zoom)
{
    QString msg;
    msg.sprintf("%d",zoom);
    outLog("move_map_postion: "+lat+", "+lon+", "+msg);
    osmmap->zoom_to_latlon(lat, lon, zoom);
    osmmap->map_set_coords(lat,lon);
    settings->setValue(S_MAPLAT,lat);
    settings->setValue(S_MAPLON,lon);
    settings->setValue(S_MAPZOOM,zoom);

}
void MainWindow::on_time_out()
{
    QString msg = util_getTimestg();
    labelTime->setText(msg);
    if (!done_setmap) {
        int ms = m_time.elapsed();
        if (ms >= 1000) {
            done_setmap = true;
#ifdef USE_DEFAULT_KSFO
            QString slat = settings->value(S_MAPLAT,KSFO_LAT).toString();
            QString slon = settings->value(S_MAPLON,KSFO_LON).toString();
            int zoom = settings->value(S_MAPZOOM,KSFO_ZOOM).toInt();
#else // !USE_DEFAULT_KSFO = YGIL
            QString slat = settings->value(S_MAPLAT,YGIL_LAT).toString();
            QString slon = settings->value(S_MAPLON,YGIL_LAT).toString();
            int zoom = settings->value(S_MAPZOOM,YGIL_ZOOM).toInt();
#endif // USE_DEFAULT_KSFO y/n
            osmmap->zoom_to_latlon(slat, slon, zoom);
            osmmap->map_set_coords(slat,slon);
        }
    }
}

//===========================================================================
//** Data File eg default.ini
//===========================================================================
/** \brief Path to a data file eg get_data_file("default.ini")
 * \return Absolute path to the file
 */
QString MainWindow::get_data_file(QString file_name)
{
    QString storedir = QDir(QDesktopServices::storageLocation(QDesktopServices::DataLocation)).absolutePath();

    // create path is not exist
    if(!QFile::exists(storedir)){
        QDir *dir = new QDir("");
        dir->mkpath(storedir);
    }
    return storedir.append("/").append(file_name);
}


void MainWindow::on_test1()
{
    // get a new location
    //QDialog *d = new QDialog(this);
    //testDialog *d = new testDialog(this);
    testDialog d(this);
    OSMPOS pos;
    osmmap->get_osm_pos(&pos);  // get OSM map position
    QString msg;
    msg.sprintf("%d",pos.zoom);

    // set default values in dialog
    d.latEd->setText(pos.lat);
    d.lonEd->setText(pos.lon);
    d.zoomEd->setText(msg);

    connect(&d,SIGNAL(set_position(QString,QString,int)),this,SLOT(move_map_position(QString,QString,int)));

    d.exec();
    //d->exec();
    //delete d;
}

void MainWindow::on_test2()
{
    QString title = "Select File Name";
    QString key = S_FILENAME;
    QString prev = settings->value(key, "NewProfile.ini").toString();
    //QString prev = "NewProfile.ini";
    QStringList filt;
    filt += "*.ini";
    QString file = util_getFileName( (QWidget *)this,title, prev, filt);
    outLog("Got new file ["+file+"]");
    if (file.length()) {
        settings->setValue(key,file);
        infoLabel->setText("FILE: "+file);
    }

}

// eof - mainwindow.cpp
