/* ==================================================
   qt_osm_map project
   Created: Geoff R. McLane - Sep 2011
   License: GPL2 (or later)
   With special thanks to Yves for FGx, and its map widget
   ================================================== */

#include "testdialog.h"
#include "osm_map.h"        // for min/max slider range
#include "utilities/utilities.h"    // outLog()

testDialog::testDialog(QWidget *parent) :
    QDialog(parent)
{
    setWindowTitle("GET LATITUDE, LONGITUDE and ZOOM");

    int m = 10;
    int row = 0;
    QString msg;

    //QVBoxLayout *mainLayout = new QVBoxLayout(this);
    QGridLayout *mainLayout = new QGridLayout(this);
    mainLayout->setContentsMargins(m,m,m,m);
    mainLayout->setSpacing(10);
    setLayout(mainLayout);

    QLabel *info = new QLabel("Enter new lat/lon location",this);
    mainLayout->addWidget(info,row,0,1,4);
    row++;

    QLabel *lat = new QLabel("Lat:",this);
    latEd = new QLineEdit(this);
    QLabel *lon = new QLabel("Lon:",this);
    lonEd = new QLineEdit(this);

    mainLayout->addWidget(lat,row,0,1,1);
    mainLayout->addWidget(latEd,row,1,1,1);
    mainLayout->addWidget(lon,row,2,1,1);
    mainLayout->addWidget(lonEd,row,3,1,1);
    row++;

    QLabel *zoom1 = new QLabel("Zoom:",this);
    zoomEd = new QLineEdit(this);
    msg.sprintf("Range %d to %d",MIN_SRNG,MAX_SRNG);
    QLabel *zoom2 = new QLabel(msg,this);
    mainLayout->addWidget(zoom1,row,0,1,1);
    mainLayout->addWidget(zoomEd,row,1,1,1);
    mainLayout->addWidget(zoom2,row,2,1,3);
    row++;

    row++;
    //QToolButton *ok = new QToolButton(this);
    QPushButton *ok = new QPushButton(this);
    ok->setText("Ok");
    mainLayout->addWidget(ok,row,1,1,2);
    connect(ok, SIGNAL(clicked()), this, SLOT(on_ok()));

    QPushButton *cancel = new QPushButton(this);
    cancel->setText("Cancel");
    mainLayout->addWidget(cancel,row,3,1,2);
    connect(cancel, SIGNAL(clicked()), this, SLOT(on_cancel()));

}

void testDialog::on_ok()
{
    QString lat = latEd->text().trimmed();
    QString lon = lonEd->text().trimmed();
    int zoom = zoomEd->text().trimmed().toInt();
    QString msg;
    msg.sprintf("%d",zoom);
    if (lat.length() && lon.length()) {
        double dlat = lat.toDouble();
        double dlon = lon.toDouble();
        if ((dlat >= -90.0)&&(dlat <= 90.0)&&(dlon >= -180.0)&&(dlon <= 180.0)) {
            outLog("on_ok: emit set_position: lat="+lat+", lon="+lon+", zoom="+msg);
            emit set_position(lat,lon,zoom);
        } else {
            msg.sprintf("on_ok: lat/lon failed (%f,%f)",dlat,dlon);
            outLog(msg);
        }
    } else {
        outLog("on_ok: pos failed "+lat+", "+lon);
    }
    close();
}
void testDialog::on_cancel()
{
    outLog("testDialog::on_cancel()");
    close();
}

// eof - testdialog.cpp
