#!/bin/sh
#< zip-osm.sh - zip the source
BN=`basename $0`

wait_for_input()
{
    if [ "$#" -gt "0" ] ; then
        echo "$1"
    fi
    echo -n "Enter y to continue : "
    read char
    if [ "$char" = "y" -o "$char" = "Y" ]
    then
        echo "Got $char ... continuing ..."
    else
        if [ "$char" = "" ] ; then
            echo "Aborting ... no input!"
        else
            echo "Aborting ... got $char!"
        fi
        exit 1
    fi
}

ask()
{
    wait_for_input "$BN: *** CONTINUE? ***"
}

TEMPV="0.0.3" 
#TEMPV="0.0.2" 
#TEMPV="0.0.1" - attempt to zoom map to a specific location
#@REM # initial version 2011-09-21
PROJ="qt_osm_map"
if [ ! -f "../$PROJ/zip-osm.sh" ]; then
    echo "ERROR: Not in correct folder... Can NOT find self..."
    exit 1
fi

echo "$BN: Will first do a full cleanup of 'backups'..."
delbu -r

TEMPZ="$PROJ-$TEMPV-src.zip"
TEMPS="$PROJ"
TEMPX="-x=$TEMPS/$TEMPS-build-desktop/* -x=$TEMPS/src/$TEMPS.pro.user"
TEMPO=""
if [ -f "../$TEMPZ" ]; then
    echo "This is an UPDATE"
    TEMPO="-u"
fi
echo "$BN: Will run: zip $TEMPO -o -r $TEMPX $TEMPZ $TEMPS/*"
ask

cd ..
echo "$BN: In current directory [$(pwd)]"
if [ ! -d "$TEMPS" ]; then
    echo "ERROR: Can NOT locate $TEMPS folder!"
    exit 1
fi
echo "$BN: Doing: zip $TEMPO -o -r $TEMPX $TEMPZ $TEMPS/*"
zip $TEMPO -o -r $TEMPX $TEMPZ $TEMPS/*

if [ ! -f "$TEMPZ" ]; then
    echo "$BN: FAILED to create zip $TEMPZ"
    exit 1
fi

cd $TEMPS
ls -l "../$TEMPZ"

# eof
