/* ==================================================
   qt_osm_map project
   Created: Geoff R. McLane - Sep 2011
   License: GPL2 (or later)
   With special thanks to Yves for FGx, and its map widget
   ================================================== */
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QWidget>
#include <QString>
#include <QMenu>
#include <QMenuBar>
#include <QAction>
#include <QStatusBar>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QSettings>
#include <QCloseEvent>
#include <QMessageBox>
#include <QTimer>
#include <QTime>    // elapsed time
#include <QDesktopServices>
#include "testdialog.h"
#include "moveDialog.h"

class osmMap;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    QSettings *settings;

    QMenu *menuFile;    // = new QMenu(tr("&File"),this);
    QAction *exitAct;   // = menuFile->addAction(tr("&Quit"),this,SLOT(on_exit()));

    QMenu *menuTest;    // = new QMenu(tr("&Test"),this);
    QAction *testAct;   // = menuTest->addAction(tr("T&est 1"),this,SLOT(on_test1()));
    QAction *testAct2;  // = menuTest->addAction(tr("T&est 2"),this,SLOT(on_test2()));
    QAction *testAct3;  // = menuTest->addAction(tr("&Native Get..."),this,SLOT(on_test3()));

    QMenu *menuHelp;    // = new QMenu(tr("&Help",this));
    QAction *helpAct;   // = menuFile->addAction(tr("&About"),this,SLOT(on_about()));
    QAction *abtqtAct;   // = menuFile->addAction(tr("&About Qt"),this,SLOT(on_about_qt()));

    bool debug_mode;
    osmMap *osmmap;

    QLabel *infoLabel;  // = new QLabel(settings->value(S_FILENAME, "NewProfile.ini").toString(),this);

    QStatusBar *statusBar;  // = new QStatusBar(this);
    QLabel *labelTime;      // = new QLabel(tr("00:00:00"),this);

    QTimer *timer;          // = new QTimer(this);

    QTime m_time;
    bool done_setmap;

    void closeEvent(QCloseEvent *event);
    QString get_data_file(QString);
    testDialog *testdialog;  // = new testDialog(this);
#ifdef USE_ALLOC_DIALOG
    moveDialog *movedialog;
#endif // #ifdef USE_ALLOC_DIALOG
    void setStatusMessage(QString msg, int timeout = 0);

public slots:
    void on_exit();
    void on_about();
    void on_about_qt();
    void on_time_out();
    void on_test1();
    void on_test2();
    void on_test3();
    void move_map_position(QString lat, QString lon, int zoom);
    void on_message_changed(QString);

};

#endif // MAINWINDOW_H
