/* ==================================================
   qt_osm_map project
   Created: Geoff R. McLane - Sep 2011
   License: GPL2 (or later)
   With special thanks to Yves for FGx, and its map widget
   ================================================== */
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "app_config.h"
#include <QtGui/QMainWindow>
#include <QWidget>
#include <QString>
#include <QMenu>
#include <QMenuBar>
#include <QAction>
#include <QStatusBar>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QSettings>
#include <QCloseEvent>
#include <QMessageBox>
#include <QTimer>
#include <QTime>    // elapsed time
#include <QDesktopServices>
#include <QGroupBox>
#include "testdialog.h"
#include "moveDialog.h"

class osmMap;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    QWidget *widget;    // = new QWidget(this);
    QVBoxLayout *mainLayout;    // = new QVBoxLayout(this);
    QMenuBar *menuBar;          // = new QMenuBar(this);
    QSettings *settings;

    QMenu *menuFile;    // = new QMenu(tr("&File"),this);
    QAction *exitAct;   // = menuFile->addAction(tr("&Quit"),this,SLOT(on_exit()));

    QMenu *menuTest;    // = new QMenu(tr("&Test"),this);
    QAction *testAct;   // = menuTest->addAction(tr("T&est 1"),this,SLOT(on_test1()));
    QAction *testAct2;  // = menuTest->addAction(tr("T&est 2"),this,SLOT(on_test2()));
    QAction *testAct3;  // = menuTest->addAction(tr("&Get Dir..."),this,SLOT(on_test3()));
    QAction *testAct4;  // = menuTest->addAction(tr("&Native Get..."),this,SLOT(on_test3()));
    QAction *testAct5;  // = menuTest->addAction(tr("&Set Paths..."),this,SLOT(on_test5()));

    QMenu *menuHelp;    // = new QMenu(tr("&Help",this));
    QAction *helpAct;   // = menuFile->addAction(tr("&About"),this,SLOT(on_about()));
    QAction *abtqtAct;   // = menuFile->addAction(tr("&About Qt"),this,SLOT(on_about_qt()));

    bool debug_mode;
    osmMap *osmmap;

    QGroupBox *resultsGroup;    // = new QGroupBox(tr("Test Results"),this);
    QVBoxLayout *resultsLayout; // = new QVBoxLayout(this);
    QLabel *infoLabel;  // = new QLabel(settings->value(S_FILENAME, "NewProfile.ini").toString(),this);
    QLabel *infoLabel2;  // = new QLabel(settings->value(S_DIRNAME, util_getCurrentWorkDirectory()).toString();
    QLabel *infoLabel3;
    QLabel *infoLabel4;

    QStatusBar *statusBar;  // = new QStatusBar(this);
    QLabel *labelTime;      // = new QLabel(tr("00:00:00"),this);

    QTimer *timer;          // = new QTimer(this);

    QTime m_time;
    bool done_setmap;

    void closeEvent(QCloseEvent *event);
    QString get_data_file(QString);
    testDialog *testdialog;  // = new testDialog(this);
#ifdef USE_ALLOC_DIALOG
    moveDialog *movedialog;
#endif // #ifdef USE_ALLOC_DIALOG
    void setStatusMessage(QString msg, int timeout = DEF_TIMEOUT);

public slots:
    void on_exit();
    void on_about();
    void on_about_qt();
    void on_time_out();
    void on_test1();
    void on_test2();
    void on_test3();
    void on_test4();
    void on_test5();
    void move_map_position(QString lat, QString lon, int zoom);
    void on_message_changed(QString);

};

#endif // MAINWINDOW_H
