/* ==================================================
   qt_osm_map project
   Created: Geoff R. McLane - Dec 2011
   License: GPL2 (or later)
   ================================================== */

#include "app_config.h"
#include "pathdialog.h"
#include "dirDialog.h"
#include "mainwindow.h"
#include "utilities/utilities.h"

pathDialog::pathDialog(QWidget *parent) :
    QDialog(parent)
{
    main = (MainWindow *)parent;
    setWindowTitle("FG Root and Scenery Paths");
    setMinimumWidth(600);

    root_valid = false;
    scene_valid = false;
    exit_ok = false;

    int m = 5;
    int row = 0;
    int cols = 8;

    mainLayout = new QGridLayout(this);
    mainLayout->setContentsMargins(m,m,m,m);
    mainLayout->setSpacing(10);
    setLayout(mainLayout);

    info = new QLabel("Get Flightgear root and scenery paths",this);
    mainLayout->addWidget(info,row,0,1,cols);
    row++;

    rootLab = new QLabel("FG_ROOT:",this);
    rootEd = new QLineEdit(this);
    rootBut = new QPushButton("...",this);
    rootLab->setAlignment(Qt::AlignRight);
    mainLayout->addWidget(rootLab,row,0,1,1);
    mainLayout->addWidget(rootEd,row,1,1,cols-2);
    mainLayout->addWidget(rootBut,row,cols-1,1,1);
    row++;
    connect(rootEd,SIGNAL(textChanged(QString)),this,SLOT(on_root_changed(QString)));
    connect(rootBut,SIGNAL(clicked()),this,SLOT(on_browse_root()));

    sceneLab = new QLabel("Scenery:",this);
    sceneEd = new QLineEdit(this);
    sceneBut = new QPushButton("...",this);
    sceneLab->setAlignment(Qt::AlignRight);
    mainLayout->addWidget(sceneLab,row,0,1,1);
    mainLayout->addWidget(sceneEd,row,1,1,cols-2);
    mainLayout->addWidget(sceneBut,row,cols-1,1,1);
    row++;
    connect(sceneEd,SIGNAL(textChanged(QString)),this,SLOT(on_scene_changed(QString)));
    connect(sceneBut,SIGNAL(clicked()),this,SLOT(on_browse_scene()));

    cancelBut = new QPushButton("Cancel",this);
    okBut = new QPushButton("Ok",this);
    mainLayout->addWidget(cancelBut,row,cols-2);
    mainLayout->addWidget(okBut,row,cols-1);

    connect(cancelBut,SIGNAL(clicked()),this,SLOT(on_cancel()));
    connect(okBut,SIGNAL(clicked()),this,SLOT(on_ok()));

    rootEd->setText(main->settings->value(S_ROOT,"").toString());
    sceneEd->setText(main->settings->value(S_SCENE,"").toString());

    on_scene_changed(sceneEd->text());
    on_root_changed(rootEd->text());
}

void pathDialog::on_cancel()
{
    close();
}
void pathDialog::on_ok()
{
    exit_ok = true;
    close();
}

bool pathDialog::is_valid_fg_root(QString txt)
{
    bool valid = false;
    int len = txt.length();
    if (len) {
        QString path(txt);
        util_ensureUnixPathSep(path);
        int ind = path.lastIndexOf(QChar('/'));
        if (ind == (len-1)) {
            path.chop(1);
        }
        path.append("/version");
        QFile file(path);
        if (file.exists()) {
            valid = true;
        }
    }
    return valid;
}

bool pathDialog::is_valid_fg_scenery(QString txt)
{
    bool valid = false;
    int len = txt.length();
    if (len) {
        QString path(txt);
        util_ensureUnixPathSep(path);
        int ind = path.lastIndexOf(QChar('/'));
        if (ind == (len-1)) {
            path.chop(1);
        }
        path.append("/Terrain");
        QDir dir(path);
        if (dir.exists()) {
            valid = true;
        }
    }
    return valid;
}

void pathDialog::on_browse_root()
{
    dirDialog d(this);
    d.init("Get FG Data Directory",rootEd->text());
    d.exec();
    QString path = d.getDirName();
    if (path.length()) {
        if (is_valid_fg_root(path)) {
            rootEd->setText(path);
            on_root_changed(path);
            QString scene = sceneEd->text();
            if (scene.length() == 0) {
                scene = path;
                scene.append("/Scenery");
                if (is_valid_fg_scenery(scene)) {
                    sceneEd->setText(scene);
                    on_scene_changed(scene);
                }
            }
        }
    }
}

void pathDialog::on_browse_scene()
{
    dirDialog d;
    d.init("Get Scenery Directory",sceneEd->text());
    d.exec();
    QString path = d.getDirName();
    if (path.length()) {
        sceneEd->setText(path);
        on_scene_changed(path);
    }
}

void pathDialog::on_root_changed(QString txt)
{
    QString style("color:red");
    root_valid = false;
    if (txt.length()) {
        QString tmp(txt);
        if (util_ensureUnixPathSep(tmp)) {
            rootEd->setText(tmp);
        }
        if (is_valid_fg_root(tmp)) {
            style = "color:green";
            main->settings->setValue(S_ROOT,tmp);
            root_valid = true;
        }
    }
    rootLab->setStyleSheet(style);
}

void pathDialog::on_scene_changed(QString txt)
{
    QString style("color:red");
    scene_valid = false;
    if (txt.length()) {
        QString tmp(txt);
        if (util_ensureUnixPathSep(tmp))
            sceneEd->setText(tmp);
        if (is_valid_fg_scenery(tmp)) {
            style = "color:green";
            main->settings->setValue(S_SCENE,tmp);
            scene_valid = true;
        }
    }
    sceneLab->setStyleSheet(style);
}

// eof - pathdialog.cpp
