/* ==================================================
   qt_osm_map project
   Created: Geoff R. McLane - Dec 2011
   License: GPL2 (or later)
   ================================================== */
#ifndef PATHDIALOG_H
#define PATHDIALOG_H

#include <QDialog>
#include <QGridLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QString>
#include <QDir>

class MainWindow;

class pathDialog : public QDialog
{
    Q_OBJECT
public:
    explicit pathDialog(QWidget *parent = 0);

    MainWindow *main;
    QGridLayout *mainLayout;
    QLabel *info;   // = new QLabel("Get Flightgear root and scenery paths",this);

    QLabel *rootLab;        // = new QLabel("FG_ROOT:",this);
    QLineEdit *rootEd;      // = new QLineEdit(this);
    QPushButton *rootBut;   // = new QPushButton("...",this);

    QLabel *sceneLab;       // = new QLabel("Scenery:",this);
    QLineEdit *sceneEd;     // = new QLineEdit(this);
    QPushButton *sceneBut;  // = new QPushButton("...",this);

    QPushButton *cancelBut; // = new QPushButton("Cancel",this);
    QPushButton *okBut;     // = new QPushButton("Ok",this);
    bool root_valid;
    bool scene_valid;
    bool exit_ok;
    bool is_valid_fg_root(QString);
    bool is_valid_fg_scenery(QString);

signals:

public slots:
    void on_cancel();
    void on_ok();
    void on_browse_root();
    void on_browse_scene();
    void on_scene_changed(QString);
    void on_root_changed(QString);

};

#endif // PATHDIALOG_H
