/* ==================================================
   qt_osm_map project
   Created: Geoff R. McLane - Sep 2011
   License: GPL2 (or later)
   With special thanks to Yves for FGx, and its map widget
   ================================================== */
#ifndef APP_CONFIG_H
#define APP_CONFIG_H

#define APP_NAME "Qt OSM Map"
#define APP_VERS "0.0.7"
#define APP_DATE "2011-12-14"

#define APP_LOG  "qt_osm_map.txt";

// try the bing map layers
// #define USE_BING_LAYERS // FAILED???

// default locations
#define USE_DEFAULT_KSFO    // sinced added multiple destinations

#define KSFO_LAT    "37.618763"
#define KSFO_LON    "-122.374926"
#define KSFO_ZOOM   14

#define YGIL_LAT    "-31.699"
#define YGIL_LON    "148.635"
#define YGIL_ZOOM   12

// rather than the above miserly list, added a set of easy to
// select locations in a QListWidget ;=))
#define ADD_LIST_WIDGET

// Settings use INI file stored in
// QDir(QDesktopServices::storageLocation(QDesktopServices::DataLocation)).absolutePath();
// That is ~/.local/share/data/geoffair/Qt_OSM_Map/default.ini in Ubuntu
#define USE_INI_FILE
#define DEF_INI_FILE    "default.ini"

#define DEF_TIMEOUT 10000   // ten seconds for status messages

// Keys for Settings
// change these ONLY for a good reason
// ***********************************
#define APP_SETV "0.0.1"
#define APP_SETN "Qt_OSM_Map"

#define S_MAPLON    "map/lon"
#define S_MAPLAT    "map/lat"
#define S_MAPZOOM   "map/zoom"

#define S_FILENAME "previous/filename"
#define S_DIRNAME "previous/directory"

#define S_ROOT "current/fgroot"
#define S_SCENE "current/scenery"
#define S_LISTROOT "lists/fgroot"
#define S_LISTSCENE "lists/scenery"

#define S_NATDIR "native/directory"
#define S_NATOPTS "native/options"
#define S_NATFILE "native/filename"

// *************************************

#endif // APP_CONFIG_H
