/* ==================================================
   qt_osm_map project
   Created: Geoff R. McLane - Dec 2011
   License: GPL2 (or later)
   With special thanks to Yves for FGx, and its map widget
   ================================================== */

// loadAirports.cpp

#include "loadAirports.h"
#include "utilities/utilities.h"

loadAirports::loadAirports(QWidget *parent)
{
    parent = parent;
    last_path = "";
    done_threshold = false;
    airlist.clear();
}

loadAirports::~loadAirports()
{
    clear_list();
}

void loadAirports::clear_list()
{
    int i, max;
    max = airlist.count();
    for (i = 0; i < max; i++) {
        PAIRLOAD pal = airlist.at(i);
        delete pal;
    }
    airlist.clear();
}

QStringList loadAirports::getThresholdList(QString path)
{
    QTime tm;
    tm.start();
    QString msg;
    QStringList filter;
    filter << "*.threshold.xml";
    QStringList list = findFiles(path, filter, true);
    msg.sprintf("Got %d threshold.xml files",list.count());
    msg.append(", from path "+path+" in ");
    msg.append(getElapTimeStg(tm.elapsed()));
    outLog(msg);
    return list;
}

int loadAirports::readThreshold(QString path)
{
    QString msg;
    if (util_isValidFGSceneryDir(path)) {
        QString xFileName;
        int idxd, max, i, cnt;
        path.append("/Airports");
        QStringList list = getThresholdList(path);
        cnt = list.count();
        if (cnt) {
            // looking good to go...
            file_count = thresh_count = air_count = run_count = 0;
            //= Create domDocument - important dont pass string in  QDomConstrucor(string) as ERRORS.. took hours DONT DO IT
            QDomDocument dom;
            for (i = 0; i < cnt; i++) {
                //= Get file name
                xFileName = list.at(i);
                file_count++;
                //= Check if file entry is a *.threshold.xml - cos this is what we want
                // but now not really necessary since list is ONLY threshold.xml!!!
                // if(xFileName.endsWith(".threshold.xml") ) {

                    thresh_count++;
                    //= Split out "CODE.threshold.xml" with a "."
                    QFileInfo fileInfoThreshold(xFileName);
                    QString airport_code = fileInfoThreshold.fileName().split(".").at(0);
                    //==============================================================
                    // Parse the <CODE>.threshold.xml file to get runways
                    //==============================================================
                    /*
                    <?xml version="1.0"?>
                    <PropertyList>
                      <runway>
                        <threshold>
                          <lon>0.044298885776989</lon>
                          <lat>51.505569223906</lat>
                          <rwy>10</rwy>
                          <hdg-deg>92.88</hdg-deg>
                          <displ-m>95</displ-m>
                          <stopw-m>55</stopw-m>
                        </threshold>
                        <threshold>
                          <lon>0.065996952433288</lon>
                          <lat>51.5048897753222</lat>
                          <rwy>28</rwy>
                          <hdg-deg>272.88</hdg-deg>
                          <displ-m>71</displ-m>
                          <stopw-m>90</stopw-m>
                        </threshold>
                      </runway>
                    </PropertyList>
                    */

                    //* Get the contents of the file
                    // QString threshold_file( airport_dir.append("/").append(airport_code).append(".threshold.xml") );
                    QFile fileXmlThrehsold(xFileName);
                    if ( !fileXmlThrehsold.open(QIODevice::ReadOnly) ) {
                        outLog("WARNING: Failed to open "+xFileName);
                        continue;
                    }

                    //= Make file contents into a string from bytearray
                    QString xmlThresholdString = fileXmlThrehsold.readAll();

                    fileXmlThrehsold.close();   // done with file - close it...

                    if (xmlThresholdString.length() == 0) {
                        outLog("WARNING: Empty file "+xFileName);
                        continue;
                    }

                    if (!dom.setContent(xmlThresholdString)) { //* AFTER dom has been created, then set the content from a string from the file
                        outLog("WARNING: xml parsing error on file "+xFileName);
                        continue;
                    }

                    // we seem to have valid xml
                    if (air_count == 0) {
                        clear_list();   // remove any previous list of airports
                    }
                    // count a new airport
                    air_count++;
                    PAIRLOAD pal = new AIRLOAD;
                    pal->icao = airport_code;

                    QString fullpath = fileInfoThreshold.absoluteDir().absolutePath();
                    // outLog("Path: "+fullpath);
                    pal->path = fullpath;

                    //==================================
                    //= Get <runway> nodes
                    QDomNodeList nodeRunways = dom.elementsByTagName("runway");
                    max = nodeRunways.count();
                    run_count += max;
                    if (max > 0) {
                        for( idxd = 0; idxd < max; idxd++ ) {
                            // loops the <runway> nodes
                            RUNLOAD rl;
                            QDomNode nodeRunway = nodeRunways.at(idxd);

                            //= Runway threshold 0
                            QString rw1 = nodeRunway.childNodes().at(0).firstChildElement("rwy").text();
                            QString rw1lat = nodeRunway.childNodes().at(0).firstChildElement("lat").text();
                            QString rw1lon = nodeRunway.childNodes().at(0).firstChildElement("lon").text();
                            QString rw1hdg = nodeRunway.childNodes().at(0).firstChildElement("hdg-deg").text();

                            //= Runway threshold 1
                            QString rw2 = nodeRunway.childNodes().at(1).firstChildElement("rwy").text();
                            QString rw2lat = nodeRunway.childNodes().at(1).firstChildElement("lat").text();
                            QString rw2lon = nodeRunway.childNodes().at(1).firstChildElement("lon").text();
                            QString rw2hdg = nodeRunway.childNodes().at(1).firstChildElement("hdg-deg").text();

                            QString rwyid = rw1+"-"+rw2;
                            rl.id = rwyid;
                            rl.lat1 = rw1lat.toDouble();
                            rl.lon1 = rw1lon.toDouble();
                            rl.hdg1 = rw1hdg.toDouble();
                            rl.lat2 = rw2lat.toDouble();
                            rl.lon2 = rw2lon.toDouble();
                            rl.hdg2 = rw2hdg.toDouble();

                            pal->runlist.push_back(rl);

                            msg = airport_code;
                            msg.append(" ");
                            msg.append(rwyid);
                            msg.append(": ");
                            msg.append(rw1+" "+rw1lat+","+rw1lon+" "+rw1hdg);
                            msg.append(" ");
                            msg.append(rw2+" "+rw2lat+","+rw2lon+" "+rw2hdg);
                            outLog(msg);

                        }   // foreach 'runway' node
                    } else {
                        outLog("WARNING: No runway nodes in file "+xFileName);
                    }
                    airlist.push_back(pal);
                // }   // deal with only threshold.xml - that is what we got
            }   // while filtered list has files
        }   // found 'threshold.xml list in 'Airports' directory
        else {
            outLog("WARNING: No threshold.xml files found on path "+path);
        }
    }   // is valid scenery directory
    else {
        outLog("WARNING: Not valid scenery path "+path);
    }
    if (air_count) {
        done_threshold = true;
        last_path = path;
    }
    return air_count;
}

int loadAirports::readThreshold_OLD(QString path)
{
    QString msg;
    if (util_isValidFGSceneryDir(path)) {
        QString xFileName;
        int idxd, max;
        path.append("/Airports");
        QDir dir(path);
        if (dir.exists()) {
            QString dot = ".";
            QString dotdot = "..";
            // looking good to go...
            file_count = thresh_count = air_count = run_count = 0;
            QDirIterator loopFiles( path, QDirIterator::Subdirectories );
            while (loopFiles.hasNext()) {
                //= Get file handle if there is one
                xFileName = loopFiles.next();
                if ((xFileName == dot)||(xFileName == dotdot))
                    continue;   // forget these

                file_count++;
                //= Check if file entry is a *.threshold.xml - cos this is what we want
                if(xFileName.endsWith(".threshold.xml") ) {

                    thresh_count++;
                    //= Split out "CODE.threshold.xml" with a "."
                    QFileInfo fileInfoThreshold(xFileName);
                    QString airport_code = fileInfoThreshold.fileName().split(".").at(0);
                    //==============================================================
                    // Parse the <CODE>.threshold.xml file to get runways
                    //==============================================================
                    /*
                    <?xml version="1.0"?>
                    <PropertyList>
                      <runway>
                        <threshold>
                          <lon>0.044298885776989</lon>
                          <lat>51.505569223906</lat>
                          <rwy>10</rwy>
                          <hdg-deg>92.88</hdg-deg>
                          <displ-m>95</displ-m>
                          <stopw-m>55</stopw-m>
                        </threshold>
                        <threshold>
                          <lon>0.065996952433288</lon>
                          <lat>51.5048897753222</lat>
                          <rwy>28</rwy>
                          <hdg-deg>272.88</hdg-deg>
                          <displ-m>71</displ-m>
                          <stopw-m>90</stopw-m>
                        </threshold>
                      </runway>
                    </PropertyList>
                    */

                    //* Get the contents of the file
                    // QString threshold_file( airport_dir.append("/").append(airport_code).append(".threshold.xml") );
                    QFile fileXmlThrehsold(xFileName);
                    if ( !fileXmlThrehsold.open(QIODevice::ReadOnly) ) {
                        outLog("WARNING: Failed to open "+xFileName);
                        continue;
                    }

                    //= Make file contents into a string from bytearray
                    QString xmlThresholdString = fileXmlThrehsold.readAll();

                    fileXmlThrehsold.close();   // done with file - close it...

                    if (xmlThresholdString.length() == 0) {
                        outLog("WARNING: Empty file "+xFileName);
                        continue;
                    }
                    if (air_count == 0) {
                        clear_list();   // remove any previous list of airports
                    }

                    // count a new airport
                    air_count++;
                    PAIRLOAD pal = new AIRLOAD;
                    pal->icao = airport_code;

                    QString fullpath = fileInfoThreshold.absoluteDir().absolutePath();
                    outLog("Path: "+fullpath);

                    //= Create domDocument - important dont pass string in  QDomConstrucor(string) as ERRORS.. took hours DONT DO IT
                    QDomDocument dom;
                    dom.setContent(xmlThresholdString); //* AFTER dom has been created, then set the content from a string from the file

                    //==================================
                    //= Get <runway> nodes
                    QDomNodeList nodeRunways = dom.elementsByTagName("runway");
                    max = nodeRunways.count();
                    run_count += max;
                    if (max > 0) {
                        for( idxd = 0; idxd < max; idxd++ ) {
                            // loops the <runway> nodes
                            RUNLOAD rl;
                            QDomNode nodeRunway = nodeRunways.at(idxd);

                            //= Runway threshold 0
                            QString rw1 = nodeRunway.childNodes().at(0).firstChildElement("rwy").text();
                            QString rw1lat = nodeRunway.childNodes().at(0).firstChildElement("lat").text();
                            QString rw1lon = nodeRunway.childNodes().at(0).firstChildElement("lon").text();
                            QString rw1hdg = nodeRunway.childNodes().at(0).firstChildElement("hdg-deg").text();

                            //= Runway threshold 1
                            QString rw2 = nodeRunway.childNodes().at(1).firstChildElement("rwy").text();
                            QString rw2lat = nodeRunway.childNodes().at(1).firstChildElement("lat").text();
                            QString rw2lon = nodeRunway.childNodes().at(1).firstChildElement("lon").text();
                            QString rw2hdg = nodeRunway.childNodes().at(1).firstChildElement("hdg-deg").text();

                            QString rwyid = rw1+"-"+rw2;
                            rl.id = rwyid;
                            rl.lat1 = rw1lat.toDouble();
                            rl.lon1 = rw1lon.toDouble();
                            rl.hdg1 = rw1hdg.toDouble();
                            rl.lat2 = rw2lat.toDouble();
                            rl.lon2 = rw2lon.toDouble();
                            rl.hdg2 = rw2hdg.toDouble();

                            pal->runlist.push_back(rl);

                            msg = airport_code;
                            msg.append(" ");
                            msg.append(rwyid);
                            msg.append(": ");
                            msg.append(rw1+" "+rw1lat+","+rw1lon+" "+rw1hdg);
                            msg.append(" ");
                            msg.append(rw2+" "+rw2lat+","+rw2lon+" "+rw2hdg);
                            outLog(msg);

                        }   // foreach 'runway' node
                    } else {
                        outLog("WARNING: No runway nodes in file "+xFileName);
                    }
                    airlist.push_back(pal);
                }   // deal with only threshold.xml
            }   // while directory has files
        }   // found 'Airports' directory
    }   // is valid scenery directory
    if (air_count) {
        done_threshold = true;
        last_path = path;
    }
    return air_count;
}

// eof - loadAirports.cpp
