/* ==================================================
   qt_osm_map project
   Created: Geoff R. McLane - Dec 2011
   License: GPL2 (or later)
   With special thanks to Yves for FGx, and its map widget
   ================================================== */

// loadAirports.h

#ifndef LOADAIRPORTS_H
#define LOADAIRPORTS_H
#include <QWidget>
#include <QString>
#include <QDir>
#include <QDirIterator>
#include <QFile>
#include <QFileInfo>
#include <QIODevice>
#include <QDomDocument>
#include <QDomNodeList>
#include <QDomNode>
#include <QList>
#include <QStringList>

typedef struct tagRUNLOAD {
    QString id;
    double lat1,lon1,hdg1,lat2,lon2,hdg2;
}RUNLOAD, *PRUNLOAD;

typedef QList<RUNLOAD> RUNLIST;

typedef struct tagAIRLOAD {
    QString name;   // if known - need apt.dat.gz
    QString icao;   // ICAO
    QString path;   // found on path
    RUNLIST runlist;    // runway list
}AIRLOAD, *PAIRLOAD;

typedef QList<PAIRLOAD> LOADLIST;

class loadAirports
{
public:
    loadAirports(QWidget *parent = 0);
    ~loadAirports();
    QWidget *parent;
    QString last_path;
    bool done_threshold;
    int file_count, thresh_count, air_count, run_count;
    LOADLIST airlist;
    void clear_list();

    QStringList getThresholdList(QString);
    int readThreshold_OLD(QString);
    int readThreshold(QString);

};


#endif // LOADAIRPORTS_H
