#ifndef MOVEDIALOG_H
#define MOVEDIALOG_H

#include "app_config.h"
#include <QWidget>
#include <QDialog>
#include <QLabel>
#include <QLineEdit>
#include <QVBoxLayout>
#include <QToolButton>
#include <QGridLayout>
#include <QPushButton>
#include <QListWidget>
#include <QAbstractItemView>
#include <QTableWidget>
#include <QTableWidgetItem>
#include <QHeaderView>

class moveDialog : public QDialog
{
    Q_OBJECT
public:
    explicit moveDialog(QWidget *parent = 0);

    QLineEdit *latEd;   // = new QLineEdit(this);
    QLineEdit *lonEd;   // = new QLineEdit(this);
    QLineEdit *zoomEd;
    void select_table_row(QString,QString);

signals:
    void set_position(QString,QString,int);

public slots:
    void on_ok();
    void on_cancel();
#ifdef ADD_LIST_WIDGET
    void on_selection_changed();
#endif // #ifdef ADD_LIST_WIDGET

private:
    void finalise();
    QGridLayout *mainLayout;    // = new QGridLayout(this);
    QLabel *infoLab;       // = new QLabel("Enter new lat/lon location",this);
    QLabel *latLab;        // = new QLabel("Lat:",this);
    QLabel *lonLab;        // = new QLabel("Lon:",this);
    QLabel *zoom1Lab;      // = new QLabel("Zoom:",this);
    QLabel *zoom2Lab;      // = new QLabel(msg,this);
    //QListWidget *listWidget;    // = new QListWidget(this);
    QTableWidget *listWidget;   // = new QTableWidget(this);
    QPushButton *okButton;  // = new QPushButton(this);
    QPushButton *cancelBut; // = new QPushButton(this);

};

#endif // MOVEDIALOG_H
