// cmp_apt_lists.cpp

#include "test_aptdat.h"
#include "test_apt850.h"
#include "utilities.h"
#include "utilities/simgear/simgear.h"


void cmp_apt_lists()
{
    PAPT_LIST pal1 = get_apt_list();
    PAPT_LIST pal2 = get_apt850_list();
    int max1 = pal1->count();
    int max2 = pal2->count();
    QString msg;
    msg.sprintf("Counts: FG=%d, XP=%d", max1, max2);
    outLog(msg);
    if ((max1 == 0)||(max2 == 0))
        return;
    PAIRPORT2 pa1;
    PAIRPORT2 pa2;
    double dist1, lat1, lon1;
    QString icao1, name1;
    double dist2, lat2, lon2;
    QString icao2, name2;
    int i, j, fnd;
    QString posn;
    int not_found1 = 0;
    int not_found2 = 0;
    // FG to XP
    for (i = 0; i < max1; i++) {
        pa1 = pal1->at(i);
        dist1 = pa1->dist;
        lat1 = pa1->lat;
        lon1 = pa1->lon;
        icao1 = pa1->icao;
        name1 = pa1->name;
        pa1->flag = 0;
        pa1->rank = -1;
        fnd = 0;
        for (j = 0; j < max2; j++) {
            pa2 = pal2->at(j);
            dist2 = pa2->dist;
            lat2 = pa2->lat;
            lon2 = pa2->lon;
            icao2 = pa2->icao;
            name2 = pa2->name;
            if (icao1 == icao2) {
                fnd = 1;
                pa1->flag = 1;
                pa1->rank = j; // keep matching
                break;
            }
        }
        if (fnd) {
            // COULD CHECK MORE
        } else {
            // NOT FOUND
            not_found1++;
            posn.sprintf("%f,%f", lat1, lon1);
            msg.sprintf("FG %d: ",not_found1);
            msg.append(icao1+" "+name1+" "+posn+" NOT FOUND");
            outLog(msg);
        }
    }
    // XP to FG
    for (j = 0; j < max2; j++) {
        pa2 = pal2->at(j);
        dist2 = pa2->dist;
        lat2 = pa2->lat;
        lon2 = pa2->lon;
        icao2 = pa2->icao;
        name2 = pa2->name;
        pa2->flag = 0;
        pa2->rank = -1;
        fnd = 0;
        for (i = 0; i < max1; i++) {
            pa1 = pal1->at(i);
            dist1 = pa1->dist;
            lat1 = pa1->lat;
            lon1 = pa1->lon;
            icao1 = pa1->icao;
            name1 = pa1->name;
            if (icao1 == icao2) {
                fnd = 1;
                pa2->flag = 1;
                pa2->rank = i;
                break;
            }
        }
        if (fnd) {
            // COULD CHECK MORE
        } else {
            // NOT FOUND
            not_found2++;
            posn.sprintf("%f,%f", lat2, lon2);
            msg.sprintf("XP %d: ",not_found2);
            msg.append(icao2+" "+name2+" "+posn+" NOT FOUND");
            outLog(msg);
        }
    }
    // Now could do a deeper compare of FG - XP with matching ICAO
    msg.sprintf("FG NF = %d, XP NF = %d", not_found1, not_found2);
    outLog(msg);
}
