
#include <QtGui>

#include "mainwindow.h"
#include "utilities.h"
#include "test_dom.h"
#include "test_sort.h"
#include "test_aptdat.h"
#include "test_apt850.h"
#include "cmp_apt_lists.h"

QString test_url = "http://weather.noaa.gov/pub/data/observations/metar/stations/YSDU.TXT";

typedef struct tagTEST {
    int test_num;
    QTime tt;
}TEST, *PTEST;

QList<PTEST> test_list;

#ifdef BUILD_MENU_TEST
#include "example.cpp"
#else // !_BUILD_MENU_TEST

#include <QVBoxLayout>
#include <QMenuBar>
#include <QMenu>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    QSettings settings;

    doing_test = false;
    util_setStdLogFile();

    restoreGeometry(settings.value("mainWindowGeometry").toByteArray());

    //====================================================
    //** Main Central Widget and Layout
    //====================================================
    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    QVBoxLayout *mainLayout = new QVBoxLayout();
    //mainLayout->setContentsMargins(10, 10, 10, 10);
    mainLayout->setContentsMargins(0, 0, 0, 0);
    mainLayout->setSpacing(0);
    widget->setLayout(mainLayout);

#ifdef USE_OWN_MENUBAR
    //== Setup top menu
    menuBar = new QMenuBar();
#endif

    //== File Menu
    menuFile = new QMenu(tr("&File"));
    exitAct = menuFile->addAction(QIcon(":/icon/quit"), tr("&Quit"), this, SLOT(on_quit()));
//#ifdef Q_OS_WIN
//    testAct->setShortcut(QKeySequence(tr("Ctrl+q"))); // THIS BOMBED???
//#else
    exitAct->setShortcuts(QKeySequence::Quit);
//#endif
    exitAct->setStatusTip(tr("Quit the application"));
    exitAct->setIconVisibleInMenu(true);

    //== Test Menu
    menuTest = new QMenu(tr("&Actions"));
    testAct = menuTest->addAction(QIcon(":/icon/test"), tr("&Load apt.dat"), this, SLOT(on_test()));
    testAct->setShortcut(QKeySequence(tr("Ctrl+t")));
    testAct->setStatusTip(tr("Load FG apt.dat"));
    testAct->setIconVisibleInMenu(true);

    test2Act = menuTest->addAction(QIcon(":/icon/test2"), tr("&Get URL"), this, SLOT(on_test2()));
    test2Act->setStatusTip(tr("Test get URL"));
    test2Act->setIconVisibleInMenu(true);

    test3Act = menuTest->addAction(QIcon(":/icon/test2"), tr("Load &apt850.dat"), this, SLOT(on_test3()));
    test3Act->setStatusTip(tr("Load 850 apt.dat"));
    test3Act->setIconVisibleInMenu(true);

    test4Act = menuTest->addAction(QIcon(":/icon/test2"), tr("DO all tests"), this, SLOT(on_test_all()));
    test4Act->setStatusTip(tr("Do all tests"));
    test4Act->setIconVisibleInMenu(true);

    //== Help Menu
    menuHelp = new QMenu(tr("&Help"));
    aboutAct = new QAction(tr("&About"), this);
    aboutAct->setStatusTip(tr("Show the application's About box"));
    connect(aboutAct, SIGNAL(triggered()), this, SLOT(about()));

    aboutQtAct = new QAction(tr("About &Qt"), this);
    aboutQtAct->setStatusTip(tr("Show the Qt library's About box"));
    connect(aboutQtAct, SIGNAL(triggered()), qApp, SLOT(aboutQt()));
    //connect(aboutQtAct, SIGNAL(triggered()), this, SLOT(aboutQt()));

    menuHelp->addAction(aboutAct);
    menuHelp->addAction(aboutQtAct);

    //helpAct = menuHelp->addAction(QIcon(":/icon/help"), tr("Help"), this, SLOT(on_help()));
    //helpAct->setIconVisibleInMenu(true);

#ifdef USE_OWN_MENUBAR
    // establish menu bar items
    menuBar->addMenu(menuFile);
    menuBar->addMenu(menuTest);
    menuBar->addMenu(menuHelp);
#else
    menuBar()->addMenu(menuFile);
    menuBar()->addMenu(menuTest);
    menuBar()->addMenu(menuHelp);
#endif

    // center - text box
    txtExtraArgs = new QPlainTextEdit();

#ifdef USE_OWN_STATUS
    // Bottom Statusbar
    statusBar = new StatusBar();
    statusBar->setMinimumHeight(30);
    //statusBar->setContentsMargins(10,0,0,0);
    statusBar->setContentsMargins(0,0,0,0);
#endif

    //= establish main layout
#ifdef USE_OWN_MENUBAR
    mainLayout->addWidget(menuBar);
#endif
    //mainLayout->addSpacing(10);
    mainLayout->addWidget(txtExtraArgs);
    //mainLayout->addSpacing(10);
    QString message = tr("Ready");

#ifdef USE_OWN_STATUS
    mainLayout->addWidget(statusBar);
    setStatusBar(statusBar);
    statusBar->showMessage(message);
#else
    statusBar()->showMessage(message);
    QString msg = util_getTimestg();
    label = new QLabel(msg);
    //label->setFixedWidth(50);
    label->setFrameStyle(QFrame::Panel | QFrame::Raised);
    //label->setMargin(1);
    statusBar()->addPermanentWidget(label);

    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(set_time()));
    timer->start(1000);

#endif

    setWindowTitle(tr("Qt Test Gui"));
    //setMinimumSize(160, 160);
    //resize(480, 320);
    restoreState(settings.value("mainWindowState").toByteArray());

#ifdef USE_WORK_THREAD
    outLog("Allocating the worker...");
    worker = new workThread;
    connect(worker, SIGNAL(work_done(int,int)), this, SLOT(done_it(int,int)));
#endif

}

MainWindow::~MainWindow()
{
    clear_apt_list();
    clear_apt850_list();

#ifdef USE_WORK_THREAD
    outLog("Destroying the worker...");
    if (worker)
        delete worker;
#endif

}

// quit
void MainWindow::on_quit()
{
    close();
}
void MainWindow::about()
{
    QMessageBox::about(this, tr("About Qt Test Gui"),
            tr("The <b>Qt Test Gui</b> shows various aspects of Qt"));
}

void MainWindow::aboutQt()
{
    QMessageBox::aboutQt(this, "About Qt");
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    QSettings settings;
    settings.setValue("mainWindowGeometry", saveGeometry());
    settings.setValue("mainWindowState", saveState());
    outLog(util_getDateTimestg()+" - Application close");
    event->accept();
}

void MainWindow::setStatusMessage(QString msg)
{
    outLog("STATUS: "+msg);
#ifdef USE_OWN_STATUS
    statusBar->showMessage(msg);
#else
    statusBar()->showMessage(msg);
#endif
}


#ifndef USE_OWN_STATUS
void MainWindow::set_time()
{
    QString msg = util_getTimestg();
    if (doing_test)
        msg.append("*");
    label->setText(msg);
#ifndef USE_WORK_THREAD
#ifdef USE_CONCURRENT
    if (doing_test) {
        QString msg;
        msg = "Test ";
        if (future.isStarted())
            msg.append("started ");
        if (future.isRunning())
            msg.append("running ");
        if (future.isPaused())
            msg.append("paused ");

        if (future.isFinished()) {
            doing_test = false;
            msg.append("Ended in "+getElapTimeStg(tm.elapsed()));
        }
        setStatusMessage(msg);
    }
#endif // #ifdef USE_CONCURRENT
#endif // #ifndef USE_WORK_THREAD
}
#endif

// test

void MainWindow::on_test()
{
    QString msg;
#ifdef USE_WORK_THREAD
    // ===================================================
    // this is looking good
    PTEST pt = new TEST;
    doing_test++;
    test_list.append(pt);
    pt->tt.start();
    //int jn = worker->work(test_sort);
    int jn = worker->work(test_aptdat);
    pt->test_num = jn;
    msg.sprintf("File!test job %d to thread...",jn);
    setStatusMessage(msg);

    doing_test++;
    pt = new TEST;
    pt->tt.start();
    test_list.append(pt);
    pt->test_num = worker->work(do_apt_sort);

    // ===================================================
#else // !USE_WORK_THREAD
    if (doing_test) {
        outLog("Test is already running...");
        return; // do NOT start a second one ;=()
    }
    tm.start();
    // ===================================================
#ifdef USE_CONCURRENT
    // ***************************************************
    msg = "File!test to run concurrent";
    //QFuture<void> future = QtConcurrent::run(test_sort);
    setStatusMessage(msg);
    doing_test++;
    future = QtConcurrent::run(test_sort);
    // ***************************************************
#else // !USE_CONCURRENT
    // ***************************************************
    msg = "File!test to run direct";
    setStatusMessage(msg);
#ifdef USE_OWN_STATUS
    statusBar->update();
#else
    statusBar()->update();
#endif
    qApp->processEvents();
    //test_dom();
    test_sort();
    msg = "End File!test in "+getElapTimeStg(tm.elapsed());
    setStatusMessage(msg);
    // ***************************************************
#endif // USE_CONCURRENT y/n
    // ===================================================
#endif // USE_WORK_THREAD y/n

}

void MainWindow::on_test2()
{
    QTime tm;
    QString msg;
    http = new httpGet;
    connect(http, SIGNAL(http_done(QString,int)),this,SLOT(got_http(QString,int)));
    tm.start();
    http->getUrl(test_url);
    msg = "End File!test2 in "+getElapTimeStg(tm.elapsed());
    setStatusMessage(msg);
}

#ifdef USE_WORK_THREAD

// hmmm, since I now pass back a JOB NUMBER
// should perhaps search the list for this job number,
// but for the moment, will take just the first ;=()
void MainWindow::done_it(int jn, int ms)
{
    QString msg, tmp;
    if (!test_list.isEmpty()) {
        PTEST pt = test_list.takeFirst();
        int tn = pt->test_num;
        if (doing_test)
            doing_test--;
        tmp.sprintf(" Job %d (%d) in %d ms)",jn,tn,ms);
        msg = "Done it in "+getElapTimeStg(pt->tt.elapsed());
        msg.append(tmp);
        delete pt;
    } else {
        msg = "INTERNAL PROBLEM: No tests in QUEUE!";
    }
    setStatusMessage(msg);
}

#endif // #ifdef USE_WORK_THREAD

void MainWindow::got_http(QString txt, int ms)
{
    QString msg;
    msg = "Done http in "+getElapTimeStg(ms);
    setStatusMessage(msg);
    msg.append(" got ["+txt+"]");
    txtExtraArgs->appendHtml(msg);
}


void MainWindow::on_test3()
{
#ifdef USE_WORK_THREAD
    QString msg;
    // ===================================================
    // this is looking good
    doing_test++;
    PTEST pt = new TEST;
    test_list.append(pt);
    pt->tt.start();
    int jn = worker->work(load_apt850);
    pt->test_num = jn;
    msg.sprintf("File!test job %d to thread...",jn);
    setStatusMessage(msg);

    doing_test++;
    pt = new TEST;
    pt->tt.start();
    test_list.append(pt);
    pt->test_num = worker->work(do_apt850_sort);

#endif
}

void MainWindow::on_test_all()
{
    QString msg;
    on_test();
    on_test3();

    doing_test++;
    PTEST pt = new TEST;
    test_list.append(pt);
    pt->tt.start();
    int jn = worker->work(cmp_apt_lists);
    pt->test_num = jn;
    msg.sprintf("Test ALL job %d to thread...",jn);
    setStatusMessage(msg);

}



#endif // BUILD_MENU_TEST y/n

