#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSettings>

QT_BEGIN_NAMESPACE
class QAction;
class QActionGroup;
class QLabel;
class QMenu;
QT_END_NAMESPACE

#include <QPlainTextEdit>
#include <QAction>
#include <QTimer>
#include <QLabel>
#include <QTime>

#include "test_config.h"
#ifdef USE_WORK_THREAD
#include "workThread.h"
#else // !USE_WORK_THREAD
#ifdef USE_CONCURRENT
#include <QtConcurrentRun>
#include <QFuture>
#endif
#endif // USE_WORK_THREAD y/n

#ifdef USE_OWN_STATUS
#include "statusbar.h"
#endif
#include "httpGet.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:

    QTime tm; // test timer
    int doing_test;

#ifdef BUILD_MENU_TEST

    MainWindow();

protected:
    void contextMenuEvent(QContextMenuEvent *event);

private slots:
    void newFile();
    void open();
    void save();
    void print();
    void undo();
    void redo();
    void cut();
    void copy();
    void paste();
    void bold();
    void italic();
    void leftAlign();
    void rightAlign();
    void justify();
    void center();
    void setLineSpacing();
    void setParagraphSpacing();
    void about();
    void aboutQt();

    void on_quit();
    void on_test();

private:
    void createActions();
    void createMenus();

    QMenu *fileMenu;
    QMenu *editMenu;
    QMenu *formatMenu;
    QMenu *helpMenu;
    QActionGroup *alignmentGroup;
    QAction *newAct;
    QAction *openAct;
    QAction *saveAct;
    QAction *printAct;
    QAction *exitAct;
    QAction *undoAct;
    QAction *redoAct;
    QAction *cutAct;
    QAction *copyAct;
    QAction *pasteAct;
    QAction *boldAct;
    QAction *italicAct;
    QAction *leftAlignAct;
    QAction *rightAlignAct;
    QAction *justifyAct;
    QAction *centerAct;
    QAction *setLineSpacingAct;
    QAction *setParagraphSpacingAct;
    QAction *aboutAct;
    QAction *aboutQtAct;

    QAction *testAct;

    // central information label
    QLabel *infoLabel;

#else // !BUILD_MENU_TEST

    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    QPlainTextEdit *txtExtraArgs;

#ifdef USE_OWN_STATUS
    StatusBar *statusBar;
#else
    QTimer *timer;
    QLabel *label;
#endif
    void setStatusMessage(QString msg);

#ifdef USE_OWN_MENUBAR
    //= Menu
    QMenuBar *menuBar;
#endif
    //= Menu Bar
    QMenu *menuFile;
    QMenu *menuTest;
    QMenu *menuHelp;
    //= Actions
    QAction *exitAct;
    QAction *testAct;
    QAction *test2Act;
    QAction *test3Act;
    QAction *test4Act;
    QAction *aboutAct;
    QAction *aboutQtAct;

    void closeEvent(QCloseEvent *event);
#ifdef USE_CONCURRENT
    QFuture<void> future;
#endif
#ifdef USE_WORK_THREAD
    workThread * worker;
#endif
    httpGet *http;

public slots:
    // * Action slots

    //void on_help();
    void about();
    void aboutQt();
    void on_test();
    void on_test2();
    void on_test3();
    void on_test_all();
    void on_quit();
#ifndef USE_OWN_STATUS
    void set_time();
#endif
#ifdef USE_WORK_THREAD
    void done_it(int jn, int ms);
#endif
#endif // BUILD_MENU_TEST y/n
    void got_http(QString txt, int ms);
};


#endif // MAINWINDOW_H
