#ifndef TEST_APTDAT_H
#define TEST_APTDAT_H

#include <QHash>
#include <QString>
#include <QTime>
#include <QFile>
#include <QRegExp>

typedef struct tagRUNWAY2 {
    double lat,lon,heading;
    int len_ft;
    QString rwy_no;
}RUNWAY2, * PRUNWAY2;

typedef QList<PRUNWAY2> RWY_LIST;

typedef struct tagAIRPORT2 {
    QString icao;
    double lat, lon;
    int elev; // feet MSL
    QString name;
    QString path;
    double dist;
    RWY_LIST rways;
    int rank;
    int flag;
}AIRPORT2, * PAIRPORT2;

typedef QList<PAIRPORT2> APT_LIST;
typedef APT_LIST * PAPT_LIST;

extern APT_LIST apt_list;  // final AIRPORT list

extern void test_aptdat();
extern void clear_apt_list();
extern void do_apt_sort();

extern PAPT_LIST get_apt_list(); // { return &apt_list; }

extern bool import_icao_only;


#endif // TEST_APTDAT_H
