// test-sort.cpp
// to read the 'airports.txt' file, into an ICAO list
#include <QtGui/QDesktopServices>
#include "test_config.h"
#include "utilities.h"
#include "test_dom.h"
#include "test_sort.h"

//typedef struct tagAIRPORT {
//    QString icao;
//    double lat, lon;
//    QString name;
//    QString path;
//    double dist;
//    int rank;
//}AIRPORT, * PAIRPORT;

QList<PAIRPORT> airportList;

//QString MainObject::data_file(QString file_name){
QString data_file(QString file_name) {

    QString storedir = QDir(QDesktopServices::storageLocation(QDesktopServices::DataLocation)).absolutePath();

    // create path is not exist
    if(!QFile::exists(storedir)){
        QDir *dir = new QDir("");
        dir->mkpath(storedir);
    }
    return storedir.append("/").append(file_name);
}

//==============================================================
// Load Runways
//==============================================================
//int AirportsWidget::load_runways_node(QString airport_dir, QString airport_code){
bool load_runways_node(QString airport_dir, QString airport_code, double * plat, double * plon)
{

    //= Create the Runways Node
    //QTreeWidgetItem *runwaysParent = new QTreeWidgetItem();
    //runwaysParent->setText(0, "Runways" );
    //runwaysParent->setIcon(0, QIcon(":/icon/folder"));
    //treeWidgetAirportInfo->addTopLevelItem(runwaysParent);
    //treeWidgetAirportInfo->setItemExpanded(runwaysParent, true);
    //treeWidgetAirportInfo->setFirstItemColumnSpanned(runwaysParent, true);


    //==============================================================
    // Parse the <CODE>.threshold.xml file to get runways
    //==============================================================
    /*
    <?xml version="1.0"?>
    <PropertyList>
      <runway>
        <threshold>
          <lon>0.044298885776989</lon>
          <lat>51.505569223906</lat>
          <rwy>10</rwy>
          <hdg-deg>92.88</hdg-deg>
          <displ-m>95</displ-m>
          <stopw-m>55</stopw-m>
        </threshold>
        <threshold>
          <lon>0.065996952433288</lon>
          <lat>51.5048897753222</lat>
          <rwy>28</rwy>
          <hdg-deg>272.88</hdg-deg>
          <displ-m>71</displ-m>
          <stopw-m>90</stopw-m>
        </threshold>
      </runway>
    </PropertyList>
    */
    bool res = false;
    //* Get the contents of the file
    QString threshold_file( airport_dir.append("/").append(airport_code).append(".threshold.xml") );
    QFile fileXmlThrehsold(threshold_file);
    QString slat, slon;
    double lat, lon;
    int count = 0;
    double tot_lat = 0;
    double tot_lon = 0;
    if (fileXmlThrehsold.open(QIODevice::ReadOnly))
    {

        //= Make file contents into a string from bytearray
        QString xmlThresholdString = fileXmlThrehsold.readAll();

        //= Create domDocument - important dont pass string in  QDomConstrucor(string) as ERRORS.. took hours DONT DO IT
        QDomDocument dom;
        dom.setContent(xmlThresholdString); //* AFTER dom has been created, then set the content from a string from the file


        //==================================
        //= Get <runway> nodes
        QDomNodeList nodeRunways = dom.elementsByTagName("runway");

        if (nodeRunways.count() > 0){
            for(int idxd =0; idxd < nodeRunways.count(); idxd++){

                // loops the <runway> nodes
                QDomNode nodeRunway = nodeRunways.at(idxd);
                QDomNodeList nodeChild = nodeRunway.childNodes();
                for (int r = 0; r < nodeChild.count(); r++)
                {
                    slat = nodeChild.at(r).firstChildElement("lat").text();
                    slon = nodeChild.at(r).firstChildElement("lon").text();
                    if (slat.length() && slon.length()) {
                        bool tok = false;
                        bool nok = false;
                        lat = slat.toDouble(&tok);
                        lon = slon.toDouble(&nok);
                        if (tok && nok) {
                            tot_lat += lat;
                            tot_lon += lon;
                            count++;
                        }

                    }
                }
                //== Add runway parent ie X - Y both ends
                //QTreeWidgetItem *rItem = new QTreeWidgetItem(runwaysParent);
                //rItem->setIcon(0, QIcon(":/icon/runways"));
                //rItem->setText(CI_RUNWAYS, "1");
                //rItem->setText(CI_NODE, nodeRunway.childNodes().at(0).firstChildElement("rwy").text().append(
                //                        " - ").append(
                //                                nodeRunway.childNodes().at(1).firstChildElement("rwy").text()
                //                        ));
                //treeWidgetAirportInfo->setItemExpanded(rItem, true);
                //treeWidgetAirportInfo->setFirstItemColumnSpanned(rItem, true);

                //= Runway threshold 0
                //QTreeWidgetItem *tItem0 = new QTreeWidgetItem(rItem);
                //tItem0->setIcon(0, QIcon(":/icon/runway"));
                //tItem0->setText(CI_NODE,  nodeRunway.childNodes().at(0).firstChildElement("rwy").text());
                //tItem0->setText(CI_LAT,  nodeRunway.childNodes().at(0).firstChildElement("lat").text());
                //tItem0->setText(CI_LON,  nodeRunway.childNodes().at(0).firstChildElement("lon").text());
                //tItem0->setText(CI_HEADING,  nodeRunway.childNodes().at(0).firstChildElement("hdg-deg").text());
                //tItem0->setText(CI_TYPE, "runway");
                //tItem0->setText(CI_SETTING_KEY, QString(airport_code).append("runway").append(
                //                                nodeRunway.childNodes().at(0).firstChildElement("rwy").text()));

                //= Runway  threshold 1
                //QTreeWidgetItem *tItem1 = new QTreeWidgetItem(rItem);
                //tItem1->setIcon(0, QIcon(":/icon/runway"));
                //tItem1->setText(CI_NODE,  nodeRunway.childNodes().at(1).firstChildElement("rwy").text());
                //tItem1->setText(CI_LAT,  nodeRunway.childNodes().at(1).firstChildElement("lat").text());
                //tItem1->setText(CI_LON,  nodeRunway.childNodes().at(1).firstChildElement("lon").text());
                //tItem1->setText(CI_HEADING,  nodeRunway.childNodes().at(1).firstChildElement("hdg-deg").text());
                //tItem1->setText(CI_TYPE, "runway");
                //tItem1->setText(CI_SETTING_KEY, QString(airport_code).append("runway").append(
                //                                nodeRunway.childNodes().at(1).firstChildElement("rwy").text()));

                //mapWidget->add_runway(	airport_code,
                //                      tItem0->text(CI_NODE),
                //                      tItem1->text(CI_NODE),
                //                      tItem0->text(CI_LAT), tItem0->text(CI_LON),
                //                      tItem1->text(CI_LAT), tItem1->text(CI_LON)
                //                      );


            }
        }

    }
    if (count) {
        lat = tot_lat / count;
        lon = tot_lon / count;
        *plat = lat;
        *plon = lon;
        //res.sprintf("%.8f,%.8f",lat,lon);
        res = true;
    }

    //return runwaysParent->childCount();
    return res;
}


//==============================================================
// Load Tower Node
//==============================================================
bool load_tower_node(QString airport_dir, QString airport_code, double * plat, double * plon)
{
    bool res = false;
    QString slat, slon;
    double lat, lon;
    //* Create the Parkings Node
    //QTreeWidgetItem *towerParent = new QTreeWidgetItem();
    //towerParent->setText(0, "No Tower" );
    //towerParent->setText(CI_TYPE, "tower");
    //towerParent->setIcon(0, QIcon(":/icon/tower"));
    //treeWidgetAirportInfo->addTopLevelItem(towerParent);
    //treeWidgetAirportInfo->setItemExpanded(towerParent, false);

    //=======================================================================
    // Parse the ICAO.twr.xml file for Tower Postiton
    //=======================================================================
    /*
        <?xml version="1.0"?>
        <PropertyList>
          <tower>
            <twr>
              <lon>4.762789</lon>
              <lat>52.307064</lat>
              <elev-m>60.96</elev-m>
            </twr>
          </tower>
        </PropertyList>
    */

    //= Files in terrasync are named "groundnet.xml"; in scenery their "parking.xml" -- Why asks pete??
    QString file_path(airport_dir.append("/").append(airport_code).append(".twr.xml"));

    //= Check tower file exists
    if(QFile::exists(file_path)){

        //* Open file and read contents to string
        QFile ppfile(file_path);
        ppfile.open(QIODevice::ReadOnly);
        QString xmlString = ppfile.readAll();

        //= Create domDocument - important - don't pass string in  QDomConstrucor(string) as ERRORS.. took hours DONT DO IT
        QDomDocument dom;
        dom.setContent(xmlString); //* AFTER dom has been created, then set the content from a string from the file

        //= Get <tower> nodes
        QDomNodeList towersNode = dom.elementsByTagName("tower");

        slat = towersNode.at(0).childNodes().at(0).firstChildElement("lat").text();
        slon = towersNode.at(0).childNodes().at(0).firstChildElement("lon").text();
        if (slat.length() && slon.length()) {
            bool tok = false;
            bool nok = false;
            lat = slat.toDouble(&tok);
            lon = slon.toDouble(&nok);
            if (tok && nok) {
                *plat = lat;
                *plon = lon;
                res = true;
            }

        }
        //towerParent->setText(CI_LAT, towersNode.at(0).childNodes().at(0).firstChildElement("lat").text());
        //towerParent->setText(CI_LON, towersNode.at(0).childNodes().at(0).firstChildElement("lon").text());

        //mapWidget->add_tower(airport_code, towerParent->text(CI_LAT), towerParent->text(CI_LON));
        //towerParent->setText(0, QString("%1 - Tower").arg(airport_code) );


    } /* File Exists */

    //* return the lat,lon
    return res;
}

bool set_distances( QString icao, PAIRPORT *ppa )
{
    bool success = false;
    QTime tm;
    int i, found;
    int ind;
    double lat, lon, dist, min_dist;
    PAIRPORT pfnd, pa;
    QString msg;
    int max = airportList.count();
    msg.sprintf("List of %d airports, ",max);
    msg.append("centering on "+icao);
    outLog(msg);
    tm.start();
    min_dist = 99999.0;
    ind = -1;
    *ppa = 0;
    for (i = 0; i < max; i++) {
        pa = airportList.at(i);
        if (pa->icao == icao)
            break;
    }
    if ( i < max ) {
        found = i;
        pfnd = airportList.at(found);
        lat = pfnd->lat;
        lon = pfnd->lon;
        for (i = 0; i < max; i++) {
            pa = airportList.at(i);
            if (i == found) {
                pa->dist = 0.0;
                pa->rank = 0;
            } else {
                if (pa->icao == "YSDU")
                    dist = 0;
                dist = dist_est_km(lat, lon, pa->lat, pa->lon);
                if (dist < 1.0)
                    dist = 1.0;
                pa->dist = dist;
                if (dist < min_dist) {
                    min_dist = dist;
                    ind = i;
                }
            }
        }
        success = true;
    }
    if (ind != -1)
        *ppa = airportList.at(ind);
    msg = getElapTimeStg(tm.elapsed());
    if (success)
        outLog("Airport sort done in "+msg);
    else
        outLog("FAILED, in "+msg);
    return success;
}

bool get_next_distance( double mdist, PAIRPORT *ppa )
{
    bool success = false;
    int i;
    int ind;
    double dist, min_dist;
    PAIRPORT pa;
    int max = airportList.count();
    min_dist = 99999.0;
    ind = -1;
    *ppa = 0;
    for (i = 0; i < max; i++) {
        pa = airportList.at(i);
        dist = pa->dist;
        if (dist > mdist) {
            if (dist < min_dist) {
                min_dist = dist;
                ind = i;
            }
        }
    }
    if (ind != -1) {
        *ppa = airportList.at(ind);
        success = true;
    }
    return success;
}

void test_abc()
{
    QString msg, tmp;
    char *pt;
    pt = abc_to_telephony('F');
    if (pt) {
        tmp = pt;
        msg = "Letter 'F' - telephony ["+tmp+"]";
    } else {
        msg = "Failed to find 'F'";
    }
    outLog(msg);
    pt = telephony_to_phonetic((char *)"Juliet");
    if (pt) {
        tmp = pt;
        msg = "telephony 'Juliet' - phonetic ["+tmp+"]";
    } else {
        msg = "Failed to find 'Juliet'";
    }
    outLog(msg);
    QString cs, sent, phon;
    cs = "GA0100";
    sent = callsign_to_sentence(cs);
    phon = callsign_to_phonetics(cs);
    outLog("For ["+cs+"],\n telephony ["+sent+"],\n phonetics ["+phon+"]");
    cs = "GA-200";
    sent = callsign_to_sentence(cs);
    phon = callsign_to_phonetics(cs);
    outLog("For ["+cs+"],\n telephony ["+sent+"],\n phonetics ["+phon+"]");
    cs = "a*?_b=c><d";
    sent = callsign_to_sentence(cs);
    phon = callsign_to_phonetics(cs);
    outLog("For ["+cs+"],\n telephony ["+sent+"],\n phonetics ["+phon+"]");
}

void test_sort()
{
    QTime tm;
    QString tmp;
    PAIRPORT pa;
    QString icao;
    QString name;
    QString path;
    QString posn;
    double dist;
    tm.start();
    QFile dataFile(data_file("airports.txt"));
    double lat, lon;
    int count = 0;
    int failed = 0;
    // line = in.readLine();
    // test_abc();
    outLog("Processing ["+dataFile.fileName()+"]");
    if (!dataFile.open(QIODevice::ReadOnly | QIODevice::Text)){
        outLog("FAILED to open ["+dataFile.fileName()+"]");
         return;
    }
    QTextStream in(&dataFile);
    QString line = in.readLine();
    while ( !line.isNull() ) {
        QStringList cols = line.split("\t");
        if (cols.size() >= 3) {
            //QStandardItem *itemAirportCode = new QStandardItem();
            //itemAirportCode->setText(cols.at(0));
            //QStandardItem *itemAirportName = new QStandardItem();
            //itemAirportName->setText(cols.at(1));
            //QStandardItem *itemAirportDir = new QStandardItem();
            //itemAirportDir->setText(cols.at(2));
            //QList<QStandardItem *> items;
            //items << itemAirportCode << itemAirportName << itemAirportDir;
            //model->appendRow(items);
            icao = cols.at(0);
            name = cols.at(1);
            path = cols.at(2);
            if (!load_runways_node(path,icao,&lat, &lon)) {
                if (!load_tower_node(path, icao, &lat, &lon)) {
                    // anywhere else to LOOK???
                    outLog("FAILED: "+icao+"\tno position\t"+name+"\t"+path);
                    failed++;
                }
            } else {
                pa = new AIRPORT;
                pa->icao = icao;
                pa->lat = lat;
                pa->lon = lon;
                pa->name = name;
                pa->path = path;
                pa->rank = 0;
                airportList.append(pa);
                //tmp.sprintf("%.8f,%.8f",lat,lon);
                //outLog(icao+"\t"+posn+"\t"+name+"\t"+path);
                count++;

            }
        }
        line = in.readLine();
    }

    line.sprintf("Loaded %d airports, %d failed, in ", count, failed);
    tmp = getElapTimeStg(tm.elapsed());
    line.append(tmp);
    outLog(line);
    if (set_distances("YGIL", &pa)) {
        icao = pa->icao;
        lat = pa->lat;
        lon = pa->lon;
        name = pa->name;
        path = pa->path;
        dist = pa->dist;
        posn.sprintf("%f,%f %f", lat, lon, dist);
        line = "nearest "+icao+" "+posn+" "+name;
        int i = 0;
        while ( (i < 5) && get_next_distance(dist,&pa)) {
            dist = pa->dist;
            icao = pa->icao;
            line.append(" "+icao);
            i++;
        }
        outLog(line);
    }
}

// eof - test_sort.cpp

