// httpGet.cpp

#include "httpGet.h"

httpGet::httpGet()
{
    reply = 0;
    httpRequestAborted = false;
    //url = urls;
    //startRequest(url);
}

void httpGet::getUrl(QString in_url)
{
    url = in_url;
    httpDone = false;
    text_reply = "";
    tm.start();
    startRequest(url);
}

// httpGet::~httpGet() { }

void httpGet::startRequest(QUrl url)
{
    reply = qnam.get(QNetworkRequest(url));

    connect(reply, SIGNAL(finished()),
            this, SLOT(httpFinished()));

    connect(reply, SIGNAL(readyRead()),
            this, SLOT(httpReadyRead()));
    //connect(reply, SIGNAL(downloadProgress(qint64,qint64)),
    //        this, SLOT(updateDataReadProgress(qint64,qint64)));
}

void httpGet::httpFinished()
{
    httpDone = true;
    int ms = tm.elapsed();

    if (httpRequestAborted) {
        reply->deleteLater();
        return;
    }

    QVariant redirectionTarget = reply->attribute(QNetworkRequest::RedirectionTargetAttribute);
    if (reply->error()) {
        //QMessageBox::information(this, tr("HTTP"),
        //                        tr("Download failed: %1.")
        //                         .arg(reply->errorString()));
        text_reply.append(" FAILED: "+reply->errorString());
    } else if (!redirectionTarget.isNull()) {
        QUrl newUrl = url.resolved(redirectionTarget.toUrl());
        //if (QMessageBox::question(this, tr("HTTP"),
        //                          tr("Redirect to %1 ?").arg(newUrl.toString()),
        //                          QMessageBox::Yes | QMessageBox::No) == QMessageBox::Yes) {
            url = newUrl;
            reply->deleteLater();
            //file->open(QIODevice::WriteOnly);
            //file->resize(0);
            startRequest(url);
            return;
        //}
    } else {
       // QString fileName = QFileInfo(QUrl(urlLineEdit->text()).path()).fileName();
       // statusLabel->setText(tr("Downloaded %1 to current directory.").arg(fileName));
       // downloadButton->setEnabled(true);
    }

    reply->deleteLater();
    reply = 0;
    //delete file;
    //file = 0;
    emit http_done(text_reply,ms);
}

void httpGet::httpReadyRead()
{
    // this slot gets called every time the QNetworkReply has new data.
    // We read all of its new data and write it into the file.
    // That way we use less RAM than when reading it at the finished()
    // signal of the QNetworkReply
    //if (file)
    //    file->write(reply->readAll());
    text_reply.append(reply->readAll());
}

// eof - httpGet.cpp
