// test-dom.cpp
#include "test_dom.h"
#include "utilities.h"

QString file_path("/home/geoff/Scenery-1.0.1/Airports/Y/G/I/YGIL.parking.xml");




void test_dom()
{
    QString msg;
    outLog("Check parking file "+file_path+" exists");
    if(QFile::exists(file_path)){

        //* Open file and read contents to string
        QFile ppfile(file_path);
        ppfile.open(QIODevice::ReadOnly);
        QString xmlString = ppfile.readAll();
        //qDebug() << xmlString;
        //* Create domDocument - important - don't pass string in  QDomConstrucor(string) as ERRORS.. took hours DONT DO IT
        QDomDocument dom;
        dom.setContent(xmlString); //* AFTER dom has been created, then set the content from a string from the file



        //===================================
        //= Get Frequencies
        //QTreeWidgetItem *towerItem = treeWidgetAirportInfo->findItems("tower", Qt::MatchExactly, CI_TYPE).at(0);
        QDomNodeList nodeFreqs = dom.elementsByTagName("frequencies");

        for(int idxf =0; idxf < nodeFreqs.at(0).childNodes().count(); idxf++){
            double freq = nodeFreqs.at(0).childNodes().at(idxf).firstChild().nodeValue().toDouble() / 100;
            //QTreeWidgetItem *freqItem = new QTreeWidgetItem(towerItem);
            QString node = QString("%1 - %2").arg(	nodeFreqs.at(0).childNodes().at(idxf).nodeName()
                                                    ).arg( QString::number(freq, 'f', 2));
            //freqItem->setText(CI_NODE,
            //				  QString("%1 - %2").arg(	nodeFreqs.at(0).childNodes().at(idxf).nodeName()
            //											).arg( QString::number(freq, 'f', 2)
            //					));

        }


        //== Parking Positions
        QStringList listParkingPositions;
        QString slat, slon;
        QString lat, lon;
        //= Get <Parking/> nodes and loop thru them and add to list (removing dupes)
        QDomNodeList parkingNodes = dom.elementsByTagName("Parking");
        msg.sprintf("Got %d 'Parking' nodes...",parkingNodes.count());
        outLog(msg);
        if (parkingNodes.count() > 0){
            for(int idxd =0; idxd < parkingNodes.count(); idxd++){

                 QDomNode parkingNode = parkingNodes.at(idxd);
                 QDomNamedNodeMap attribs = parkingNode.attributes();
                 QString stand(attribs.namedItem("name").nodeValue());
                 stand.append(attribs.namedItem("number").nodeValue());

                //= Check it doesnt already exist - pete is confused as to multiple entries
                if(!listParkingPositions.contains(stand)){
                     if(attribs.namedItem("type").nodeValue() == "gate"){

                        //= Append position to eliminate dupes
                        if(!stand.contains(" ")){
                            //listParkingPositions.append(stand);
                            //QTreeWidgetItem *pItem = new QTreeWidgetItem(parkingParent);
                            slat = attribs.namedItem("lat").nodeValue();
                            slon = attribs.namedItem("lon").nodeValue();
                            lat = hmm_to_decimal(slat);
                            lon = hmm_to_decimal(slon);
                            msg.sprintf("%d",idxd+1);
                            outLog(msg+": slat="+slat+", lat="+lat+", slon="+slon+", lon="+lon);
                            //lat = Helpers::hmm_to_decimal(slat);
                            //lon = Helpers::hmm_to_decimal(slon);
                            //pItem->setIcon(0, QIcon(":/icon/stand"));
                            //pItem->setText(CI_NODE, stand);
                            //pItem->setText(CI_TYPE, "stand");
                            //pItem->setText(CI_LAT, Helpers::hmm_to_decimal(attribs.namedItem("lat").nodeValue()));
                            //pItem->setText(CI_LON, Helpers::hmm_to_decimal(attribs.namedItem("lon").nodeValue()));
                            //pItem->setText(CI_LAT, lat);
                            //pItem->setText(CI_LON, lon);
                            //pItem->setText(CI_HEADING, attribs.namedItem("heading").nodeValue());
                            //pItem->setText(CI_SETTING_KEY, QString(airport_code).append("stand").append(stand));
                            //mapWidget->add_stand( airport_code,
                            //					  stand,
                            //					  pItem->text(CI_LAT),
                            //					  pItem->text(CI_LON)
                            //					 );
                        }
                    }
                }
            }

        }


    } else {
        outLog("File does NOT exist!");
    }

}
