
#include "statusbar.h"
#include "utilities.h"

StatusBar::StatusBar(QWidget *parent) :
    QStatusBar(parent)
{
    QString msg = util_getTimestg();
    label = new QLabel(msg);
    //label->setFixedWidth(50);
    label->setFrameStyle(QFrame::Panel | QFrame::Raised);
    //label->setMargin(1);
    addPermanentWidget(label);

    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(set_time()));
    timer->start(1000);
}

//** Show Error **
void StatusBar::showError(QString mesage, int timeout){
    QStatusBar::showMessage(mesage, timeout);
}
void StatusBar::showError(QString mesage){
    QStatusBar::showMessage(mesage);
}


//** Show Message **
void StatusBar::showMessage(QString mesage, int timeout){
    QStatusBar::showMessage(mesage, timeout);
}
void StatusBar::showMessage(QString mesage){
    QStatusBar::showMessage(mesage);
}

void StatusBar::set_time()
{
    QString msg = util_getTimestg();
    label->setText(msg);
}

// eof - statusbar.cpp
