/* ----------------------------------------------------------
// simgear
// This is an extract from the http://flightGear.org project
// Full source available from http://gitorious.org/fg
// Specifically extracted from SGGeodesy.cxx

// header from that file
// Copyright (C) 2006  Mathias Froehlich - Mathias.Froehlich@web.de
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
   Minor modification for this qt_test_gui project
   by Geoff R. McLane 2011-08-21
  ---------------------------------------------------------------- */
#ifndef SIMGEAR_H
#define SIMGEAR_H

#include <math.h>

// These are hard numbers from the WGS84 standard.  DON'T MODIFY
// unless you want to change the datum.
#define _EQURAD 6378137.0
#define _FLATTENING 298.257223563

#define SGD_PI 3.1415926535

#define deg2rad(val) ((val * SGD_PI) / 180.0)
#define rad2deg(val) ((val * 180) / SGD_PI )

/** Feet to Meters */
#define SG_FEET_TO_METER    0.3048

/** Meters to Feet */
#define SG_METER_TO_FEET    3.28083989501312335958

/** For divide by zero avoidance, this will be close enough to zero */
#define SG_EPSILON 0.0000001

// simgear services
// ================
// given lat1, lon1, lat2, lon2, calculate starting and ending
// az1, az2 and distance (s).  Lat, lon, and azimuth are in degrees.
// distance in meters
extern int _geo_inverse_wgs_84( double lat1, double lon1, double lat2,
                                double lon2, double *az1, double *az2,
                                            double *s );

// given, lat1, lon1, az1 and distance (s), calculate lat2, lon2
// and az2.  Lat, lon, and azimuth are in degrees.  distance in meters
extern int _geo_direct_wgs_84 ( double lat1, double lon1, double az1,
                        double s, double *lat2, double *lon2,
                        double *az2 );


#endif // SIMGEAR_H
// eof - simgear.h
