/* ==================================================
   qt_test_gui project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
// cmp_apt_lists.cpp

#include "test_aptdat.h"
#include "test_apt850.h"
#include "utilities.h"
#include "utilities/simgear/simgear.h"

int is_icao_in_fg(QString in_icao)
{
    QString icao;
    icao = in_icao.simplified();
    if (icao.isEmpty())
        return 3;   // icao is null
    PAPT_LIST pal = get_apt_list();
    int max = pal->count();
    if (max == 0)
        return 2;   // list is NULL
    PAIRPORT2 pa;
    int i;
    for (i = 0; i < max; i++) {
        pa = pal->at(i);
        if (icao == pa->icao)
            return 0; // SUCCESS - found this ICAO in LIST

    }
    return 1; // NOT FOUND
}

int is_icao_in_xp(QString in_icao)
{
    QString icao;
    icao = in_icao.simplified();
    if (icao.isEmpty())
        return 3;   // icao is null
    PAPT_LIST pal = get_apt850_list();
    int max = pal->count();
    if (max == 0)
        return 2;   // list is NULL
    PAIRPORT2 pa;
    int i;
    for (i = 0; i < max; i++) {
        pa = pal->at(i);
        if (icao == pa->icao)
            return 0; // SUCCESS - found this ICAO in LIST

    }
    return 1; // NOT FOUND
}


void cmp_apt_lists()
{
    PAPT_LIST pal1 = get_apt_list();
    PAPT_LIST pal2 = get_apt850_list();
    int max1 = pal1->count();
    int max2 = pal2->count();
    QString msg;
    msg.sprintf("Airports counts: FG=%d, XP=%d", max1, max2);
    outLog(msg);
    if ((max1 == 0)||(max2 == 0))
        return;
    PAIRPORT2 pa1;
    PAIRPORT2 pa2;
    double dist1, lat1, lon1;
    QString icao1, name1;
    double dist2, lat2, lon2;
    QString icao2, name2;
    int i, j, fnd;
    QString posn;
    int not_found1 = 0;
    int not_found2 = 0;
    // FG to XP
    for (i = 0; i < max1; i++) {
        pa1 = pal1->at(i);
        dist1 = pa1->dist;
        lat1 = pa1->lat;
        lon1 = pa1->lon;
        icao1 = pa1->icao;
        name1 = pa1->name;
        pa1->flag = 0;
        pa1->rank = -1;
        fnd = 0;
        for (j = 0; j < max2; j++) {
            pa2 = pal2->at(j);
            dist2 = pa2->dist;
            lat2 = pa2->lat;
            lon2 = pa2->lon;
            icao2 = pa2->icao;
            name2 = pa2->name;
            if (icao1 == icao2) {
                fnd = 1;
                pa1->flag = 1;
                pa1->rank = j; // keep matching
                break;
            }
        }
        if (fnd) {
            // COULD CHECK MORE
        } else {
            // NOT FOUND
            not_found1++;
            posn.sprintf("%f,%f", lat1, lon1);
            msg.sprintf("FG %d: ",not_found1);
            msg.append(icao1+" "+name1+" "+posn+" NOT FOUND");
            outLog(msg);
        }
    }
    // XP to FG
    for (j = 0; j < max2; j++) {
        pa2 = pal2->at(j);
        dist2 = pa2->dist;
        lat2 = pa2->lat;
        lon2 = pa2->lon;
        icao2 = pa2->icao;
        name2 = pa2->name;
        pa2->flag = 0;
        pa2->rank = -1;
        fnd = 0;
        for (i = 0; i < max1; i++) {
            pa1 = pal1->at(i);
            dist1 = pa1->dist;
            lat1 = pa1->lat;
            lon1 = pa1->lon;
            icao1 = pa1->icao;
            name1 = pa1->name;
            if (icao1 == icao2) {
                fnd = 1;
                pa2->flag = 1;
                pa2->rank = i;
                break;
            }
        }
        if (fnd) {
            // COULD CHECK MORE
        } else {
            // NOT FOUND
            not_found2++;
            posn.sprintf("%f,%f", lat2, lon2);
            msg.sprintf("XP %d: ",not_found2);
            msg.append(icao2+" "+name2+" "+posn+" NOT FOUND");
            outLog(msg);
        }
    }
    // Now could do a deeper compare of FG - XP with matching ICAO
    int same1 = max1 - not_found1;
    double pct1 = (double)same1 / (double)max1;
    int ipct1 = (int)((pct1 + 0.0005) * 1000.0);
    pct1 = (double)ipct1 / 10.0;
    double pct2 = (double)(max2 - not_found2) / (double)max2;
    int ipct2 = (int)((pct2 + 0.0005) * 1000.0);
    pct2 = (double)ipct2 / 10.0;
    msg.sprintf("APT: FG NF %5d of %6d, %5.1f%% SAME, XP NF %5d of %6d, %5.1f%% SAME %6d",
                not_found1, max1, pct1,
                not_found2, max2, pct2, same1);
    outLog(msg,0x4001);
}
