/* ==================================================
   qt_test_gui project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
// test_apt850.cpp

// load the latest apt.dat from X-Plane

#include "test_config.h"
#include "test_apt850.h"
#include "utilities.h"
#include "utilities/simgear/simgear.h"
#include "test_aptdat.h"

QString def_xpapt_file = DEF_APT850_FILE;
void set_xpapt_dat(QString file ) { def_xpapt_file = file; };
QString get_xpapt_dat() { return def_xpapt_file; };


APT_LIST apt850_list;  // final AIRPORT list

PAPT_LIST get_apt850_list()
{
    return &apt850_list;
}

void clear_airport2_list(PAPT_LIST pal)
{
    PAIRPORT2 pa2;
    while (!pal->isEmpty()) {
        pa2 = pal->takeFirst();
        // clear the other lists first
        while (!pa2->rways.isEmpty())
            delete pa2->rways.takeFirst();
        while (!pa2->ws.isEmpty())
            delete pa2->ws.takeFirst();
        while (!pa2->cl.isEmpty())
            delete pa2->cl.takeFirst();
        delete pa2; // then delete the memory
    }
}


void clear_apt850_list()
{
    clear_airport2_list(get_apt850_list());
}

bool set_distances3( QString icao, PAPT_LIST pal, PAIRPORT2 *ppa )
{
    bool success = false;
    QTime tm;
    int i, found;
    int ind;
    double lat, lon, dist, min_dist;
    PAIRPORT2 pfnd, pa;
    QString msg;
    int max = pal->count();
    msg.sprintf("List of %d airports, ",max);
    msg.append("centering on "+icao);
    outLog(msg);
    tm.start();
    min_dist = 99999.0;
    ind = -1;
    *ppa = 0;
    for (i = 0; i < max; i++) {
        //pa = airportList.at(i);
        pa = pal->at(i);
        if (pa->icao == icao)
            break;
    }
    if ( i < max ) {
        found = i;
        //pfnd = airportList.at(found);
        pfnd = pal->at(found);
        lat = pfnd->lat;
        lon = pfnd->lon;
        for (i = 0; i < max; i++) {
            //pa = airportList.at(i);
            pa = pal->at(i);
            if (i == found) {
                pa->dist = 0.0;
                pa->rank = 0;
            } else {
                dist = dist_est_km(lat, lon, pa->lat, pa->lon);
                if (dist < 1.0)
                    dist = 1.0;
                pa->dist = dist;
                if (dist < min_dist) {
                    min_dist = dist;
                    ind = i;
                }
            }
        }
        success = true;
    }
    if (ind != -1)
        *ppa = pal->at(ind);
        //*ppa = airportList.at(ind);
    msg = getElapTimeStg(tm.elapsed());
    if (success)
        outLog("Airport sort done in "+msg);
    else
        outLog("FAILED, in "+msg);
    return success;
}

bool get_next_distance3( double mdist, PAPT_LIST pal, PAIRPORT2 *ppa )
{
    bool success = false;
    int i;
    int ind;
    double dist, min_dist;
    PAIRPORT2 pa;
    int max = pal->count();
    min_dist = 99999.0;
    ind = -1;
    *ppa = 0;
    for (i = 0; i < max; i++) {
        pa = pal->at(i);
        dist = pa->dist;
        if (dist > mdist) {
            if (dist < min_dist) {
                min_dist = dist;
                ind = i;
            }
        }
    }
    if (ind != -1) {
        *ppa = pal->at(ind);
        success = true;
    }
    return success;
}


void do_apt850_sort()
{
    PAIRPORT2 pa2;
    QString icao, name, path, line, posn;
    double lat, lon, dist;
    if (set_distances3("YGIL", &apt850_list, &pa2)) {
        icao = pa2->icao;
        lat = pa2->lat;
        lon = pa2->lon;
        name = pa2->name;
        path = pa2->path;
        dist = pa2->dist;
        posn.sprintf("%.2f Km, at %f,%f", dist, lat, lon);
        line = "nearest "+icao+" "+posn+" "+name;
        outLog(line);
        int i = 0;
        while ( (i < 5) && get_next_distance3(dist, &apt850_list, &pa2)) {
            i++;
            dist = pa2->dist;
            lat = pa2->lat;
            lon = pa2->lon;
            icao = pa2->icao;
            name = pa2->name;
            posn.sprintf("%.2f Km, at %f,%f", dist, lat, lon);
            line.sprintf("next %d: ", i);
            line.append(icao+" "+posn+" "+name);
            outLog(line);
        }
    }
}

#if 0
static RWY_LIST _s_rwy_list;  // temporary RUNWAY list
void load_apt850( void )
{
    QTime tm;
    QString def_file = get_xpapt_dat();
    QFile f(def_file);
    if (!f.exists()) {
        outLog("ERROR: Failed to find ["+def_file+"! NO AIRPORT FILE DATA!");
        return;
    }
    tm.start();
    if (!f.open(QIODevice::ReadOnly)) {
        outLog("ERROR: Failed to open ["+def_file+"! NO AIRPORT FILE DATA!");
        return;
    }
    outLog("Processing file ["+def_file+"]");
    QString line, row_code, elevation, msg;
    QStringList parts;
    int pcnt, elev_ft, tower, bldgs, res, p;
    QString sp(" ");
    QString apt("1");
    QString rwy("100");
    QString one("1");
    QString end("99");
    QString airport_code, airport_name, rwy_number;
    double lat, lon, lat1, lon1, lat2, lon2;
    double az1, az2, s;
    int line_counter, rwy_cnt, got_apt, rwy_count, air_count, ms;
    double sum_lat, sum_lon;
    QRegExp rxICAOAirport("[A-Z]{4}");

    line_counter = 2; // done 2 lines
    rwy_cnt = 0;
    got_apt = 0;
    elev_ft = 0;
    rwy_count = 0;
    air_count = 0;
    sum_lat = 0.0;
    sum_lon = 0.0;
    _s_rwy_list.clear();
    clear_apt850_list();

    //* ignore first line
    f.readLine();
    QString credits = f.readLine();

    int version = 999;
    if(credits.startsWith("850 Version")) {
        version = 850;
        outLog("Dealing with Version 850");
    } else {
        credits.chop(credits.length() - 12);
        outLog("ERROR: Dealing with UNKNOWN version "+credits);
        f.close();
        return;
    }

    while (!f.atEnd()) {
        line = f.readLine();
        line = line.trimmed();
        line_counter++;
        row_code = line.section(' ',0, 0);
        parts = line.split(" ", QString::SkipEmptyParts);
        pcnt = parts.size();
        if (row_code == apt) {
            if (rwy_cnt && got_apt) {
                // get 'average' center of last airport
                lat = sum_lat / (double)rwy_cnt;
                lon = sum_lon / (double)rwy_cnt;
                PAIRPORT2 pa2 = new AIRPORT2;
                pa2->icao = airport_code;
                pa2->name = airport_name;
                pa2->elev = elev_ft;
                pa2->lat  = lat;
                pa2->lon  = lon;
                while (!_s_rwy_list.isEmpty())
                    pa2->rways.append(_s_rwy_list.takeFirst());
                apt850_list.append(pa2);
            }

            got_apt = 0;
            if (pcnt < A85_MIN) {
                outLog("BAD AIRPORT LINE ["+line+"]");
                continue;
            }
            elevation = parts[A85_ELEV];
            elev_ft = elevation.toInt();
            tower = (parts[A85_TWR] == one) ? 1 : 0;
            bldgs = (parts[A85_DEP] == one) ? 1 : 0;
            airport_code = parts[A85_ICAO];
            airport_name = parts[A85_NAME];
            for(p = A85_MIN; p < pcnt; p++){
                airport_name.append(sp+parts[p]);
            }
            airport_name = airport_name.trimmed();
            if (import_icao_only) {
                if( rxICAOAirport.exactMatch(airport_code) ) {
                    // airports[airport_code] = airport_name;
                    air_count++;
                    got_apt = 1;
                }
            } else {
                // airports[airport_code] = airport_name;
                air_count++;
                got_apt = 1;
            } /* if(is_icao) */

            // done airport init - restart runway stuff
            sum_lat = 0.0;
            sum_lon = 0.0;
            rwy_cnt = 0;
            // clear the runway list
            while (!_s_rwy_list.isEmpty())
                 delete _s_rwy_list.takeFirst();

        } else if (row_code == rwy) {
            if (pcnt != R85_SIZE) {
                outLog("BAD RUNWAY LINE ["+line+"]");
                continue;
            }
            if ( !got_apt )
                continue;   // no airport, so no runways !!!

            rwy_number = parts[R85_NUM1];
            lat1 = parts[R85_LAT1].toDouble();
            lat2 = parts[R85_LAT2].toDouble();
            lon1 = parts[R85_LON1].toDouble();
            lon2 = parts[R85_LON2].toDouble();
            res = _geo_inverse_wgs_84( lat1, lon1, lat2,
                        lon2, &az1, &az2, &s );
            lat = (lat1 + lat2) / 2.0;
            lon = (lon1 + lon2) / 2.0;
            PRUNWAY2 pr2 = new RUNWAY2;
#ifdef USE_850_FORMAT
            pr2->lat1 = lat1;
            pr2->lon1 = lon1;
            pr2->lat2 = lat2;
            pr2->lon2 = lon2;
            pr2->i_heading = az1;
            pr2->i_len_ft = (int)(s * SG_METER_TO_FEET);
#else
            pr2->heading = az1; // **CHECK** maybe should be az2????
            pr2->lat = lat;
            pr2->lon = lon;
            pr2->len_ft = s * SG_METER_TO_FEET;
#endif
            pr2->rwy_no = rwy_number;
            _s_rwy_list.append(pr2);
            rwy_cnt++;
            // accumulate
            sum_lat += lat;
            sum_lon += lon;
            rwy_count++;

        } else if (row_code == end) {
            break;
        }
    }
    if (rwy_cnt && got_apt) {
        // get 'average' center of last airport
        lat = sum_lat / (double)rwy_cnt;
        lon = sum_lon / (double)rwy_cnt;
        PAIRPORT2 pa2 = new AIRPORT2;
        pa2->icao = airport_code;
        pa2->name = airport_name;
        pa2->elev = elev_ft;
        pa2->lat  = lat;
        pa2->lon  = lon;
        while (!_s_rwy_list.isEmpty())
            pa2->rways.append(_s_rwy_list.takeFirst());
        apt850_list.append(pa2);
    }

    f.close();

    msg.sprintf("Done %d lines, found %d airports (%d), %d runways",
                line_counter,air_count,
                apt850_list.count(),
                rwy_count);
    ms = tm.elapsed();
    outLog(msg+", in "+getElapTimeStg(ms));

    return;
}
#endif // 0 - OLD CODE

// eof - test_apt850.cpp
