/* ==================================================
   qt_test_gui project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
#ifndef LOAD_APT_H
#define LOAD_APT_H
#include <QString>
#include <QList>
#include "test_config.h"

typedef struct tagRUNWAY2 {
    int code;
#ifdef USE_850_FORMAT
    double lat1, lon1;
    double lat2, lon2;
    double i_heading;
    int i_len_ft;
#else
    double lat,lon,heading;
    int len_ft;
#endif
    QString rwy_no;
}RUNWAY2, * PRUNWAY2;

typedef QList<PRUNWAY2> RWY_LIST;

typedef struct tagWINDSOCK {
    int code;
    double lat, lon;
    int lit;
    QString name; // optional
}WINDSOCK, * PWINDSOCK;

typedef QList<PWINDSOCK> WS_LIST;

typedef struct tagCOMITEM {
    int code;
    double freq;
    QString name;
}COMITEM, * PCOMITEM;

typedef QList<PCOMITEM> COMM_LIST;


typedef struct tagAIRPORT2 {
    int code;
    QString icao;
    double lat, lon;
    int elev; // feet MSL
    QString name;
    QString path;
    double dist;
    RWY_LIST rways;
    WS_LIST  ws;
    COMM_LIST cl;
    int rank;
    int flag;
}AIRPORT2, * PAIRPORT2;

typedef QList<PAIRPORT2> APT_LIST;
typedef APT_LIST * PAPT_LIST;

extern void clear_airport2_list(PAPT_LIST pal);


#endif // LOAD_APT_H
// eof - load_pat.h
