/* ==================================================
   qt_test_gui project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
#ifndef TEST_CONFIG_H
#define TEST_CONFIG_H
#include <QtGui>

// HISTORY - GROWING UPWARDS
#define PGM_VERSION "0.0.6" // load groundnet XML files
#define PGM_DATE "2011-09-09"
#define ADD_GROUNDNET_XML

// PGM_VERSION "0.0.5" // New runway, like 850 dataset
// PGM_DATE "2011-08-27"
#define USE_850_FORMAT

// PGM_VERSION "0.0.4" // After cycling through Ubuntu and back - final
// PGM_DATE "2011-08-24"
// PGM_VERSION "0.0.3" // FIX20110823 - dist_est_km() returned 'nan' if virtually the same point
// PGM_DATE "2011-08-23"
// PGM_VERSION "0.0.2"
// PGM_DATE "2011-08-21"

// DEFAULT FILE LOCATIONS
// Fix as suitable for your environment
#ifdef Q_OS_MAC

#define DEF_APT810_FILE "/home/geoff/fg/fg15/fgfs/data/Airports/apt.dat.gz"
#define DEF_APT850_FILE "/home/geoff/downloads/AptNav-X/apt.dat"

#define DEF_FGNAV_FILE "/home/geoff/fg/fg15/fgfs/data/Navaids/nav.dat.gz"
#define DEF_XPNAV_FILE "/home/geoff/downloads/AptNav-X/earth_nav.dat"

#define DEF_FGAWY_FILE "/home/geoff/fg/fg15/fgfs/data/Navaids/awy.dat.gz"
#define DEF_XPAWY_FILE "/home/geoff/downloads/AptNav-X/earth_awy.dat"

#define DEF_FGFIX_FILE "/home/geoff/fg/fg15/fgfs/data/Navaids/fix.dat.gz"
#define DEF_XPFIX_FILE "/home/geoff/downloads/AptNav-X/earth_fix.dat"

#ifdef ADD_GROUNDNET_XML
#define DEF_FGGN_DIR    "/home/geoff/fg/fg16/fgfs/data/AI/Traffic"
#endif // ADD_GROUNDNET_XML

#else
#ifdef Q_OS_UNIX

#define DEF_APT810_FILE "/home/geoff/fg/fg15/fgfs/data/Airports/apt.dat.gz"
#define DEF_APT850_FILE "/home/geoff/downloads/AptNav-X/apt.dat"

#define DEF_FGNAV_FILE "/home/geoff/fg/fg15/fgfs/data/Navaids/nav.dat.gz"
#define DEF_XPNAV_FILE "/home/geoff/downloads/AptNav-X/earth_nav.dat"

#define DEF_FGAWY_FILE "/home/geoff/fg/fg15/fgfs/data/Navaids/awy.dat.gz"
#define DEF_XPAWY_FILE "/home/geoff/downloads/AptNav-X/earth_awy.dat"

#define DEF_FGFIX_FILE "/home/geoff/fg/fg15/fgfs/data/Navaids/fix.dat.gz"
#define DEF_XPFIX_FILE "/home/geoff/downloads/AptNav-X/earth_fix.dat"

#ifdef ADD_GROUNDNET_XML
#define DEF_FGGN_DIR    "/home/geoff/fg/fg16/fgfs/data/AI/Traffic"
#endif // ADD_GROUNDNET_XML

#else

#define DEF_APT810_FILE "C:\\FGCVS\\flightgear\\data\\Airports\\apt.dat.gz"
#define DEF_APT850_FILE "C:\\DTEMP\\FG\\AptNav-X\\apt.dat"

#define DEF_FGNAV_FILE "C:\\FGCVS\\flightgear\\data\\Navaids\\nav.dat.gz"
#define DEF_XPNAV_FILE "C:\\DTEMP\\FG\\AptNav-X\\earth_nav.dat"

#define DEF_FGAWY_FILE "C:\\FGCVS\\flightgear\\data\\Navaids\\awy.dat.gz"
#define DEF_XPAWY_FILE "C:\\DTEMP\\FG\\AptNav-X\\earth_awy.dat"

#define DEF_FGFIX_FILE "C:\\FGCVS\\flightgear\\data\\Navaids\\fix.dat.gz"
#define DEF_XPFIX_FILE "C:\\DTEMP\\FG\\AptNav-X\\earth_fix.dat"

#ifdef ADD_GROUNDNET_XML
#define DEF_FGGN_DIR    "C:\\FGCVS\\flightgear\\data\\AI\\Traffic"
#endif // ADD_GROUNDNET_XML

#endif // #ifdef Q_OS_UNIX y/n
#endif // #ifdef Q_OS_MAC y/n

// SOME FEATURES
// Changing any of these switches may NOT be fully supported

#define USE_WORK_THREAD // Use QThread - this works great

#undef USE_OWN_STATUS   // seems no need...
#undef USE_OWN_MENUBAR  // again, seems no need

#undef TEST_FGX_SETTINGS    // was just to get access to 'cache'

#undef USE_CONCURRENT    // Use QtConcurrent - does not seem so useful

#undef BUILD_MENU_TEST  // only for ideas, and SHOULD BE REMOVED


#endif // TEST_CONFIG_H
// eof - test_config.h
