/* ==================================================
   qt_test_gui project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "test_config.h"
#include <QMainWindow>
#include <QSettings>

QT_BEGIN_NAMESPACE
class QAction;
class QActionGroup;
class QLabel;
class QMenu;
QT_END_NAMESPACE

#include <QPlainTextEdit>
#include <QAction>
#include <QTimer>
#include <QLabel>
#include <QTime>
#include <QPushButton>
#include <QLineEdit>
#include <QCheckBox>
#include <QIODevice>

#include <QDomDocument>
#include <QDomElement>
#include <QDomNode>
#include <QXmlAttributes>
#include <QXmlDefaultHandler>
#include <QXmlStreamReader>
#include <QStringRef>
#include <QDomNodeList>

#ifdef ADD_PROGRESS_DIALOG
#include <QProgressDialog>
#endif // #ifdef ADD_PROGRESS_DIALOG
#ifdef USE_WORK_THREAD
#include "workThread.h"
#else // !USE_WORK_THREAD
#ifdef USE_CONCURRENT
#include <QtConcurrentRun>
#include <QFuture>
#endif
#endif // USE_WORK_THREAD y/n

#ifdef USE_OWN_STATUS
#include "statusbar.h"
#endif
#include "httpGet.h"

typedef struct tagTEST {
    int test_num;
    QTime tt;
    QString desc;
}TEST, *PTEST;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:

    QTime tm; // test timer
    int doing_test;

#ifdef BUILD_MENU_TEST

    MainWindow();

protected:
    void contextMenuEvent(QContextMenuEvent *event);

private slots:
    void newFile();
    void open();
    void save();
    void print();
    void undo();
    void redo();
    void cut();
    void copy();
    void paste();
    void bold();
    void italic();
    void leftAlign();
    void rightAlign();
    void justify();
    void center();
    void setLineSpacing();
    void setParagraphSpacing();
    void about();
    void aboutQt();

    void on_quit();
    void on_test();

private:
    void createActions();
    void createMenus();

    QMenu *fileMenu;
    QMenu *editMenu;
    QMenu *formatMenu;
    QMenu *helpMenu;
    QActionGroup *alignmentGroup;
    QAction *newAct;
    QAction *openAct;
    QAction *saveAct;
    QAction *printAct;
    QAction *exitAct;
    QAction *undoAct;
    QAction *redoAct;
    QAction *cutAct;
    QAction *copyAct;
    QAction *pasteAct;
    QAction *boldAct;
    QAction *italicAct;
    QAction *leftAlignAct;
    QAction *rightAlignAct;
    QAction *justifyAct;
    QAction *centerAct;
    QAction *setLineSpacingAct;
    QAction *setParagraphSpacingAct;
    QAction *aboutAct;
    QAction *aboutQtAct;

    QAction *testAct;

    // central information label
    QLabel *infoLabel;

#else // !BUILD_MENU_TEST

    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    int processCommands();
    void saveSettings();
    void appendTestList(PTEST pt);
    int test_count;
    QCheckBox *checkIcao;
    QCheckBox *checkAptNav;

    QPlainTextEdit *infoText;
    void appendInfo(QString);
    void setInfo(QString);

#ifdef USE_OWN_STATUS
    StatusBar *statusBar;
#else
    QTimer *timer;
    QLabel *label;
#endif
    void setStatusMessage(QString msg, int timeout = 0);

#ifdef USE_OWN_MENUBAR
    //= Menu
    QMenuBar *menuBar;
#endif
    //= Menu Bar
    QMenu *menuFile;
    QMenu *menuTest;
    QMenu *menuHelp;
    //= Actions
    QAction *exitAct;
    QAction *testAct;
    QAction *test2Act;
    QAction *test3Act;
    QAction *test4Act;
    QAction *test5Act;
    QAction *test6Act;
    QAction *test7Act;
    QAction *aboutAct;
    QAction *aboutQtAct;

    // layout
    QLabel *FGaptLabel;
    QLineEdit *FGaptLineEdit;
    QPushButton *FGaptBrowse;
    QLabel *XPaptLabel;
    QLineEdit *XPaptLineEdit;
    QPushButton *XPaptBrowse;

    QLabel *FGnavLabel;
    QLineEdit *FGnavLineEdit;
    QPushButton *FGnavBrowse;
    QLabel *XPnavLabel;
    QLineEdit *XPnavLineEdit;
    QPushButton *XPnavBrowse;

    QLabel *FGawyLabel;
    QLineEdit *FGawyLineEdit;
    QPushButton *FGawyBrowse;
    QLabel *XPawyLabel;
    QLineEdit *XPawyLineEdit;
    QPushButton *XPawyBrowse;

    QLabel *FGfixLabel;
    QLineEdit *FGfixLineEdit;
    QPushButton *FGfixBrowse;
    QLabel *XPfixLabel;
    QLineEdit *XPfixLineEdit;
    QPushButton *XPfixBrowse;

#ifdef ADD_GROUNDNET_XML
    // add ground net XML parsing
    QLabel *FGgnLabel;          // = new QLabel(tr("FG gn dir:"));
    QLineEdit *FGgnLineEdit;    // = new QLineEdit(tmp,this);
    QPushButton *FGgnBrowse;    // = new QPushButton("...",this);
    QAction *fggnAct;
    void on_load_xml(QString file, QStringList &aircvs, QStringList & fltcvs, int *air, int *flt);
    void enumerate_a_node(QDomNode &n, QStringList &list);
#endif // ADD_GROUNDNET_XML

#ifdef ADD_PROGRESS_DIALOG
    QCheckBox *useModal;    // = new QCheckBox("Use modal dialog",this);
    QCheckBox *addDialog;   // = new QCheckBox("Add progress dialog",this);
#endif // ADD_PROGRESS_DIALOG

    QString browseFile(QString title, QString current, QString filter);
    QString browseDir(QString title, QString curr);

    void closeEvent(QCloseEvent *event);
#ifdef USE_CONCURRENT
    QFuture<void> future;
#endif
#ifdef USE_WORK_THREAD
    workThread * worker;
#endif
    httpGet *http;
    void add2Log(QString msg, int flag = 1);
    quint64 m_lastLogSize;
public slots:
    // * Action slots

    //void on_help();
    void about();
    void aboutQt();

    void on_test2(); // URL fetch test

    void on_test(); // depreciated - load apt
    void on_test3(); // depreciated - load apt

    void on_test_all();
    void on_load_apt(); // replace on_test, and on_test3
    void on_load_nav();
    void on_load_awy();
    void on_load_fix();
    void on_quit();

    void on_fgapt_text();
    void on_fgapt_browse();
    void on_xpapt_text();
    void on_xpapt_browse();

    void on_fgnav_text();
    void on_fgnav_browse();
    void on_xpnav_text();
    void on_xpnav_browse();

    void on_fgawy_text();
    void on_fgawy_browse();
    void on_xpawy_text();
    void on_xpawy_browse();

    void on_fgfix_text();
    void on_fgfix_browse();
    void on_xpfix_text();
    void on_xpfix_browse();

#ifdef ADD_GROUNDNET_XML
    void on_fggn_text();    // connect(FGgnLineEdit,SIGNAL(editingFinished()),this,SLOT(on_fggn_text()));
    void on_fggn_browse();  // connect(FGgnBrowse,SIGNAL(pressed()),this,SLOT(on_fggn_browse()));
    void on_fggn_load();
#endif // ADD_GROUNDNET_XML

#ifdef ADD_PROGRESS_DIALOG
    void on_adddialog_toggle(bool); // connect(addDialog,SIGNAL(clicked(bool)),this,SLOT(on_adddialog_toggle(bool)));
    void on_modal_toggle(bool); // connect(useModal,SIGNAL(clicked(bool)),this,SLOT(on_modal_toggle(bool)));
#endif // ADD_PROGRESS_DIALOG

    void on_check_icao();
    void on_check_aptnav();

#ifndef USE_OWN_STATUS
    void set_time();
#endif
#ifdef USE_WORK_THREAD
    void done_it(int jn, int ms);
#endif
#endif // BUILD_MENU_TEST y/n
    void got_http(QString txt, int ms);
};


#endif // MAINWINDOW_H
