// utils.cpp

#include "util.h"


// given millisecond, return appropriate (nice) string
QString getElapTimeStg(int ms)
{
    QString fmt = "";
    if (ms < 1000) {
        fmt.sprintf("%d ms", ms);
    } else {
        int secs = ms / 1000;
        ms = ms % 1000;
        if (secs < 60) {
            if (ms)
                fmt.sprintf("%d.%03d secs", secs, ms);
            else
                fmt.sprintf("%d secs", secs);
        } else {
            int mins = secs / 60;
            secs = secs % 60;
            if (mins < 60) {
                if (ms)
                    fmt.sprintf("%d:%02d.%03d mins", mins, secs, ms);
                else {
                    if (secs)
                        fmt.sprintf("%d:%02d mins", mins, secs);
                    else
                        fmt.sprintf("%d mins", mins);
                }
            } else {
                int hrs = mins / 60;
                mins = mins % 60;
                if (ms)
                    fmt.sprintf("%d:%02d:%02d.%03d hrs", hrs, mins, secs, ms);
                else {
                    if (secs)
                        fmt.sprintf("%d:%02d:%02d hrs", hrs, mins, secs);
                    else {
                        if (mins)
                            fmt.sprintf("%d:%02d hrs", hrs, mins);
                        else
                            fmt.sprintf("%d hrs", hrs);
                    }
                }
            }
        }
    }
    return fmt;
}

// eof - utils.cpp

