/**
* Qt4.1 Simple dialog example
*
*	author: Jan Koci
*	http://kengine.sourceforge.net/tutorial/
*
* 06.06.13 - First version
*/

#include "ui_simpledialog.h"
#include "simpledialog.h"
#include <QString>
#include <QStringList>
#include <QFile>
#include <QFileInfo>
#include <QTextStream>
#include <QDir>
#include <QFileDialog>

QString m_inFile = "simpledialog.ui";
QString m_inFile2 = "tempout.txt";

CSimpleDialog::CSimpleDialog(QWidget *parent): QDialog(parent)
{
    QString info;
    QString nd;
    int i;

    setupUi(this);
    // Set label text
    m_pLabel->setText("Simple dialog correctly initialized");
    // Set signal and slot for "OK Button"
    connect(m_pOkButton, SIGNAL(clicked()), this, SLOT(OkButtonClicked()));

    // addition by me, by way of experimentations...
    m_pLabel2->setText(""); // clear the 2nd text box
    // see if we can find a file to load...
    QFile f(m_inFile); // set default file
    // if user gave a FILE NAME on the command line
    // use that...
    QStringList cmdline_args = QCoreApplication::arguments();
    for (i = 1; i < cmdline_args.size(); i++) {
        info = cmdline_args[i];
        if (f.exists(info))
            f.setFileName(info);
    }

    if (!f.exists()) {
        // just some messy games when running debug version
        QString cd = QDir::currentPath();
        QStringList sl = cd.split(QChar('/'));
        QString nd;
        QString last;
        for (i = 0; i < sl.size(); i++)
        {
            if ((i + 1) < sl.size()) {
                if (nd.size())
                    nd += "/";
                nd += sl[i];
            } else {
                last = sl[i];
            }
        }
        if (nd.size()) {
            sl = last.split(QChar('-'));
            nd += "/";
            nd += sl[0];
            nd += "/";
            nd += m_inFile;
            if (f.exists(nd))
                f.setFileName(nd);
        }
    }

    // if still NO, try file 2
    if (!f.exists() && f.exists(m_inFile2)) {
        f.setFileName(m_inFile2);
    }

    if (f.exists() && (f.open(QFile::ReadOnly | QFile::Text))) {
        QFileInfo fi(f);
        QTextStream stream(&f);
        textBrowser->setText(stream.readAll());
        qint64 sz = f.size();
        info = "Loaded file ["+fi.fileName()+"]";
        nd = tr(", size %1 bytes").arg(sz);
        info += nd;
        m_pLabel2->setText(info);
        m_inFile = f.fileName();
        f.close();
    } else {
        QString cd = QDir::currentPath();
        info = "Unable to locate file ["+m_inFile+"]\n";
        info += "Current directory is ["+cd+"]\n";
        textBrowser->setText(info);
    }
}

void CSimpleDialog::OkButtonClicked()
{
	m_pLabel->setText("OK Button clicked ...");
}

void CSimpleDialog::on_pushButton_clicked()
{
    QFile f;
    QString info;
    QString nd;
    QString fileName = QFileDialog::getOpenFileName(this,
                                                    tr("Select File"),
                                                     m_inFile,
                                                     tr("All (*.*)"));
    if (fileName.size() && f.exists(fileName)) {
        f.setFileName(fileName);
        if (f.exists() && (f.open(QFile::ReadOnly | QFile::Text))) {
            QFileInfo fi(f);
            QTextStream stream(&f);
            textBrowser->setText(stream.readAll());
            qint64 sz = f.size();
            info = "Loaded file ["+fi.fileName()+"]";
            nd = tr(", size %1 bytes").arg(sz);
            info += nd;
            m_pLabel2->setText(info);
            m_inFile = f.fileName();
            f.close();
        }
    }
}
