/* ==================================================
   Threading project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
#include "mainwindow.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    m_Settings = new QSettings();

    restoreGeometry(m_Settings->value("mainWindowGeometry").toByteArray());

    util_setStdLogFile();

    do_quit = false;
    //====================================================
    //** Main Central Widget and Layout
    //====================================================
    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    QVBoxLayout *mainLayout = new QVBoxLayout();
    //mainLayout->setContentsMargins(10, 10, 10, 10);
    mainLayout->setContentsMargins(0, 0, 0, 0);
    mainLayout->setSpacing(0);
    widget->setLayout(mainLayout);

    //== File Menu
    menuFile = new QMenu(tr("&File"));
    //exitAct = menuFile->addAction(QIcon(":/icon/quit"), tr("&Quit"), this, SLOT(on_quit()));
    exitAct = menuFile->addAction(tr("&Quit"), this, SLOT(on_quit()));
    exitAct->setShortcuts(QKeySequence::Quit);
    exitAct->setStatusTip(tr("Quit the application"));
    menuFile->addAction(exitAct);
    //exitAct->setIconVisibleInMenu(true);

    menuTest = new QMenu(tr("&Actions"));
    testAct = menuTest->addAction(tr("&Test"), this, SLOT(on_test()));
    testAct->setStatusTip(tr("Run first test"));

    menuHelp = new QMenu(tr("&Help"));
    //exitAct = menuFile->addAction(QIcon(":/icon/quit"), tr("&Quit"), this, SLOT(on_quit()));
    aboutAct = menuHelp->addAction(tr("&About"), this, SLOT(on_about()));
    aboutAct->setStatusTip(tr("Show About dialog"));
    //exitAct->setIconVisibleInMenu(true);
    menuHelp->addAction(tr("About Qt"), this, SLOT(on_about_qt()));

    m_MenuBar = new QMenuBar(this);
    m_MenuBar->addMenu(menuFile);
    m_MenuBar->addMenu(menuTest);
    m_MenuBar->addMenu(menuHelp);

    // main window area
    textEdit = new QPlainTextEdit();

    // status bar
    m_StatusBar = new QStatusBar(this);
    connect(m_StatusBar, SIGNAL(messageChanged(QString)),
            this, SLOT(on_message_changed(QString)));
    m_StatusBar->showMessage("Ready");
    QString msg = util_getTimestg();
    labelTimer = new QLabel(msg);
    //label->setFixedWidth(50);
    labelTimer->setFrameStyle(QFrame::Panel | QFrame::Raised);
    //label->setMargin(1);
    m_StatusBar->addPermanentWidget(labelTimer);
    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(on_timer()));
    timer->start(1000);

    mainLayout->addWidget(m_MenuBar);
    mainLayout->addWidget(textEdit);
    mainLayout->addWidget(m_StatusBar);

}

MainWindow::~MainWindow()
{

}

void MainWindow::closeEvent(QCloseEvent *event)
{
    //saveSettings();
    outLog(util_getDateTimestg()+" - Application closeEvent()",0x8001);
    event->accept();
}

void MainWindow::on_timer()
{
    QString msg = util_getTimestg();
    if (do_quit)
        on_quit();
    labelTimer->setText(msg);
}
void MainWindow::on_message_changed(QString msg)
{
    if (msg.isEmpty())
        statusBar()->showMessage("Ready");

}

void MainWindow::saveSettings()
{
    m_Settings->setValue("mainWindowGeometry", saveGeometry());
    m_Settings->setValue("mainWindowState", saveState());
}

void MainWindow::on_quit()
{
    close();
}

void MainWindow::on_test()
{

}

void MainWindow::on_about()
{
    QString msg(PGM_NAME);
    msg.append(" Version: ");
    msg.append(PGM_VERSION);
    msg.append(", dated ");
    msg.append(PGM_DATE);
    msg.append("\n");
    msg.append("Built: ");
    msg.append(__DATE__);
    msg.append(" at ");
    msg.append(__TIME__);
    msg.append("\n\n");
    msg.append("Developing and testing threading\n\n");
    msg.append("License: GPL v2 or later\n\n");
    //msg.append("Source: http://geoffair.org/projects/threading.htm");
    QMessageBox::about(this, tr("About Threading"), msg);
}

void MainWindow::on_about_qt()
{
    QMessageBox::aboutQt(this, "About Qt");
}
