/* ==================================================
   Threading project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
#include "mainwindow.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    m_Settings = new QSettings();

    restoreGeometry(m_Settings->value("mainWindowGeometry").toByteArray());

    util_setStdLogFile();

    do_quit = false;
    //====================================================
    //** Main Central Widget and Layout
    //====================================================
    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    QVBoxLayout *mainLayout = new QVBoxLayout();
    //mainLayout->setContentsMargins(10, 10, 10, 10);
    mainLayout->setContentsMargins(0, 0, 0, 0);
    mainLayout->setSpacing(0);
    widget->setLayout(mainLayout);

    //== File Menu
    menuFile = new QMenu(tr("&File"));
    //exitAct = menuFile->addAction(QIcon(":/icon/quit"), tr("&Quit"), this, SLOT(on_quit()));
    exitAct = menuFile->addAction(tr("&Quit"), this, SLOT(on_quit()));
    exitAct->setShortcuts(QKeySequence::Quit);
    exitAct->setStatusTip(tr("Quit the application"));
    menuFile->addAction(exitAct);
    //exitAct->setIconVisibleInMenu(true);

    menuTest = new QMenu(tr("&Actions"));
    testAct = menuTest->addAction(tr("&Test"), this, SLOT(on_test()));
    testAct->setStatusTip(tr("Run first test"));

    menuHelp = new QMenu(tr("&Help"));
    //exitAct = menuFile->addAction(QIcon(":/icon/quit"), tr("&Quit"), this, SLOT(on_quit()));
    aboutAct = menuHelp->addAction(tr("&About"), this, SLOT(on_about()));
    aboutAct->setStatusTip(tr("Show About dialog"));
    //exitAct->setIconVisibleInMenu(true);
    menuHelp->addAction(tr("About Qt"), this, SLOT(on_about_qt()));

    m_MenuBar = new QMenuBar(this);
    m_MenuBar->addMenu(menuFile);
    m_MenuBar->addMenu(menuTest);
    m_MenuBar->addMenu(menuHelp);

    // main window area
    textEdit = new QPlainTextEdit();

    // status bar
    m_StatusBar = new QStatusBar(this);
    connect(m_StatusBar, SIGNAL(messageChanged(QString)),
            this, SLOT(on_message_changed(QString)));
    m_StatusBar->showMessage("Ready");
    QString msg = util_getTimestg();
    labelTimer = new QLabel(msg);
    //label->setFixedWidth(50);
    labelTimer->setFrameStyle(QFrame::Panel | QFrame::Raised);
    //label->setMargin(1);
    m_StatusBar->addPermanentWidget(labelTimer);
    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(on_timer()));
    timer->start(1000);

    mainLayout->addWidget(m_MenuBar);
    mainLayout->addWidget(textEdit);
    mainLayout->addWidget(m_StatusBar);


    workthread = new workThread;
    connect(workthread, SIGNAL(work_done(int,int)), this, SLOT(done_work(int,int)));
    work_count = 0;
    total_work = 0;
}

MainWindow::~MainWindow()
{
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    saveSettings();
    outLog("closeEvent(event)",3);
    if (workthread) {
        if (workthread->isRunning()) {
            // ok, it has been run, once or more
            if (workthread->in_function) {
                // ok, it is in the USER function - no idea about for HOW LONG, so
                outLog("closeEvent - thread running in function - using 'terminate()'",3);
                workthread->terminate();
                workthread->was_terminated = true;
            }
        }
        delete workthread;
        outLog("closeEvent: deleted workthread",3);
    }
    workthread = 0;
    clearWorkList();
    outLog(util_getDateTimestg()+" - Application closeEvent()",0x8001);
    event->accept();
}

void MainWindow::on_timer()
{
    QString msg = util_getTimestg();
    if (do_quit)
        on_quit();
    if (work_count)
        msg.append("*");
    labelTimer->setText(msg);
}
void MainWindow::on_message_changed(QString msg)
{
    if (msg.isEmpty())
        setStatusMessage("Ready");

}

void MainWindow::saveSettings()
{
    m_Settings->setValue("mainWindowGeometry", saveGeometry());
    m_Settings->setValue("mainWindowState", saveState());
}

void MainWindow::on_quit()
{
    outLog("on_quit()",3);
    close();
}

void MainWindow::on_test()
{
    QString msg;
    PWORK pw = new WORK;
    pw->done = false;
    appendWorkList(pw);
    pw->desc.sprintf("Waste Time %d", total_work);
    pw->tt.start();
#ifdef ADD_VOID_PTR
    pw->test_num = workthread->work(waste_time,pw);
#else
    pw->test_num = workthread->work(waste_time);
#endif
    msg.sprintf("Waste Time: Job %d to thread...", pw->test_num);
    setStatusMessage(msg);
}

void MainWindow::setStatusMessage(QString msg)
{
    m_StatusBar->showMessage(msg);
    outLog("STATUS: "+msg);
}

void MainWindow::appendWorkList(PWORK pw)
{
    m_workList.append(pw);
    work_count++;
    total_work++;
}
void MainWindow::clearWorkList()
{
    while (!m_workList.isEmpty())
        delete m_workList.takeFirst();
}

void MainWindow::done_work(int id, int ms)
{
    QString msg, tmp;
    int max = m_workList.count();
    PWORK pw;
    int i;
    int done_cnt = 0;
    int ind = -1;
    for (i = 0; i < max; i++) {
        pw = m_workList.at(i);
        if (pw->done)
            done_cnt++;
        if (pw->test_num == id)
            ind = i;
    }
    done_cnt++; // count one more as DONE
    if (work_count)
        work_count--;
    if (ind != -1) {
        pw = m_workList.at(ind);
        pw->done = true;
        msg = "Work: '"+pw->desc+"'' in "+getElapTimeStg(ms);
        tmp.sprintf(", done %d of %d. ",done_cnt,max);
        msg.append(tmp);
        if (done_cnt == max)
            msg.append("LAST");
    } else {
        msg.sprintf("INTERNAL PROBLEM: No 'work' of num %d in QUEUE of %d!", id, max);
    }
    setStatusMessage(msg);
}

// TRY HTML MSG
void MainWindow::on_about()
{
    QString msg;
    msg.append("<html><body><p>");
    msg.append(PGM_NAME);
    msg.append(" Version: ");
    msg.append(PGM_VERSION);
    msg.append(", dated ");
    msg.append(PGM_DATE);
    msg.append("</p><p>");
    msg.append("Built: ");
    msg.append(__DATE__);
    msg.append(" at ");
    msg.append(__TIME__);
    msg.append("</p>");
    msg.append("<p>Purpose: Developing and testing Qt threading</p>");
    msg.append("<p><b>Source: <a href=\"http://geoffair.org/projects/threading.htm\">http://geoffair.org/projects/threading.htm</a></b></p>");
    msg.append("<p>License: GNU GPL v2 or later - see LICENSE.txt</p>");
    msg.append("<p>Copyright: &copy; Geoff R. McLane</p>");
    msg.append("</body></html>");
    QMessageBox::about(this, tr("About Threading"), msg);
}

void MainWindow::on_about_qt()
{
    QMessageBox::aboutQt(this, "About Qt");
}

#define WAIT_MS 10000
#ifdef ADD_VOID_PTR
void MainWindow::waste_time(void * vp)
{
    QTime tm;
    QString msg;
    PWORK pw = (PWORK)vp;
    msg = pw->desc;
    outLog("Starting: "+msg,3);
    tm.start();
    qulonglong cycles = 0;
    while (tm.elapsed() < WAIT_MS)
        cycles++;
    msg = "Ending: ";
    msg.append(pw->desc);
    msg.append(" Done in ");
    msg.append(getElapTimeStg(tm.elapsed()));
    msg.append(", cycles ");
    msg.append(util_getNiceNumber(QString::number(cycles)));
    outLog(msg,3);
}
#else
void MainWindow::waste_time()
{
    QTime tm;
    QString msg;
    tm.start();
    qulonglong cycles = 0;
    while (tm.elapsed() < WAIT_MS)
        cycles++;
    msg = "waste_time: Done in ";
    msg.append(getElapTimeStg(tm.elapsed()));
    msg.append(", cycles ");
    msg.append(util_getNiceNumber(QString::number(cycles)));
    outLog(msg);
}
#endif

// eof - mainwindow.cpp
