/* ==================================================
   Threading project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QSettings>
#include <QVBoxLayout>
#include <QMenu>
#include <QAction>
#include <QMenuBar>
#include <QCloseEvent>
#include <QString>
#include <QLabel>
#include <QFrame>
#include <QTimer>
#include <QStatusBar>
#include <QPlainTextEdit>
#include <QMessageBox>
#include "app_config.h"
#include "utilities/utilities.h"
#include "utilities/workThread.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    void closeEvent(QCloseEvent *event);
    void saveSetting();

    workThread * workthread;
    WORK_LIST m_workList;   // list of actions passed to thread
    void appendWorkList(PWORK pw);
    void clearWorkList();
#ifdef ADD_VOID_PTR
    static void waste_time(void * vp);
#else
    static void waste_time();
#endif
    int work_count;
    int total_work;

    QSettings *m_Settings;
    void saveSettings();

    //= Menu Bar
    QMenuBar *m_MenuBar;

    QMenu *menuFile;
    QMenu *menuTest;
    QMenu *menuHelp;
    //= Actions
    QAction *exitAct;
    QAction *testAct;
    QAction *aboutAct;

    QPlainTextEdit *textEdit;

    QStatusBar *m_StatusBar;
    QLabel *labelTimer;
    QTimer *timer;
    void setStatusMessage(QString msg);

    bool do_quit;

public slots:
    void on_quit();
    void on_test();
    void on_about();
    void on_about_qt();
    void on_timer();
    void on_message_changed(QString msg);
    void done_work(int,int);

};

#endif // MAINWINDOW_H
