/* ==================================================
   Threading project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
#include "mainwindow.h"

#define WAIT_MS 10000

#ifdef ADD_PROGRESS_DIALOG
int max_secs = (int)(WAIT_MS / 1000);
QProgressDialog *dialog;
//dialog->setLabelText("Progress information...");
int cur_secs = 0;
int last_secs = 0;
bool g_UserCancel = false;
#endif // ADD_PROGRESS_DIALOG

QStringList logged;
bool g_inCloseEvent = false;

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    m_Settings = new QSettings();

    restoreGeometry(m_Settings->value("mainWindowGeometry").toByteArray());

    // main window area
    textEdit = new QPlainTextEdit();
    textEdit->setReadOnly(true);

    util_setStdLogFile();

    do_quit = false;
    //====================================================
    //** Main Central Widget and Layout
    //====================================================
    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    QVBoxLayout *mainLayout = new QVBoxLayout();
    //mainLayout->setContentsMargins(10, 10, 10, 10);
    mainLayout->setContentsMargins(0, 0, 0, 0);
    mainLayout->setSpacing(0);
    widget->setLayout(mainLayout);

    //== File Menu
    menuFile = new QMenu(tr("&File"));
    //exitAct = menuFile->addAction(QIcon(":/icon/quit"), tr("&Quit"), this, SLOT(on_quit()));
    exitAct = menuFile->addAction(tr("&Quit"), this, SLOT(on_quit()));
    exitAct->setShortcuts(QKeySequence::Quit);
    exitAct->setStatusTip(tr("Quit the application"));
    menuFile->addAction(exitAct);
    //exitAct->setIconVisibleInMenu(true);

    menuTest = new QMenu(tr("&Actions"));
    testAct = menuTest->addAction(tr("&Test"), this, SLOT(on_test()));
    testAct->setStatusTip(tr("Run first test"));

    menuHelp = new QMenu(tr("&Help"));
    //exitAct = menuFile->addAction(QIcon(":/icon/quit"), tr("&Quit"), this, SLOT(on_quit()));
    aboutAct = menuHelp->addAction(tr("&About"), this, SLOT(on_about()));
    aboutAct->setStatusTip(tr("Show About dialog"));
    //exitAct->setIconVisibleInMenu(true);
    menuHelp->addAction(tr("About Qt"), this, SLOT(on_about_qt()));

    m_MenuBar = new QMenuBar(this);
    m_MenuBar->addMenu(menuFile);
    m_MenuBar->addMenu(menuTest);
    m_MenuBar->addMenu(menuHelp);

    // status bar
    m_StatusBar = new QStatusBar(this);
    connect(m_StatusBar, SIGNAL(messageChanged(QString)),
            this, SLOT(on_message_changed(QString)));
    m_StatusBar->showMessage("Ready");
    QString msg = util_getTimestg();
    labelTimer = new QLabel(msg);
    //label->setFixedWidth(50);
    labelTimer->setFrameStyle(QFrame::Panel | QFrame::Raised);
    //label->setMargin(1);
    m_StatusBar->addPermanentWidget(labelTimer);
    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(on_timer()));
    timer->start(1000);

    mainLayout->addWidget(m_MenuBar);
#ifdef ADD_PROGRESS_DIALOG
    useModal = new QCheckBox("Use modal progress dialog on Action->test",this);
    connect(useModal,SIGNAL(clicked(bool)),this,SLOT(on_modal_toggle(bool)));
    useModal->setChecked(m_Settings->value("check/modal","1").toBool());
    mainLayout->addWidget(useModal);
#endif // ADD_PROGRESS_DIALOG
    mainLayout->addWidget(textEdit);
    mainLayout->addWidget(m_StatusBar);

    m_workThread = new workThread;
    connect(m_workThread, SIGNAL(work_done(int,int)), this, SLOT(done_work(int,int)));
    work_count = 0;
    total_work = 0;
}

MainWindow::~MainWindow()
{
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    g_inCloseEvent = true;
    saveSettings();
    add2Log("closeEvent(event)",3);
    if (m_workThread) {
        if (m_workThread->isRunning()) {
            // ok, it has been run, once or more
            if (m_workThread->in_function) {
                // ok, it is in the USER function - no idea about for HOW LONG, so
                add2Log("closeEvent - thread running in function - using 'terminate()'",3);
                m_workThread->was_terminated = true;
                m_workThread->terminate(); // this MAY fail in UNIX
            }
        }
        delete m_workThread;
        add2Log("closeEvent: deleted workthread",3);
    }
    m_workThread = 0;
    clearWorkList();
    add2Log(util_getDateTimestg()+" - Application closeEvent()",0x8001);
    event->accept();
}

void MainWindow::add2Log(QString msg, int flag)
{
    outLog(msg,flag);
    // main window area
    textEdit->appendPlainText(msg);
    if (flag & 1)
        textEdit->appendPlainText("\n");
}

void MainWindow::on_timer()
{
    QString msg = util_getTimestg();
    if (do_quit)
        on_quit();
    if (work_count)
        msg.append("*");
    labelTimer->setText(msg);
#ifdef ADD_PROGRESS_DIALOG
    if (dialog && (cur_secs != last_secs)) {
        last_secs = cur_secs;
        dialog->setValue(cur_secs);
    }
#endif // ADD_PROGRESS_DIALOG
    int max = logged.count();
    if (max) {
        msg = logged.join("\n");
        logged.clear();
        textEdit->appendPlainText(msg);
    }
}
void MainWindow::on_message_changed(QString msg)
{
    if (msg.isEmpty())
        setStatusMessage("Ready");

}

void MainWindow::saveSettings()
{
    m_Settings->setValue("mainWindowGeometry", saveGeometry());
    m_Settings->setValue("mainWindowState", saveState());
}

void MainWindow::on_quit()
{
    add2Log("on_quit()",3);
    close();
}

void MainWindow::on_test()
{
    QString msg;
    PWORK pw;
#ifdef ADD_PROGRESS_DIALOG
    PEXTWORK pew = new EXTWORK;
    dialog = new QProgressDialog(this);
    g_UserCancel = false;
    connect(dialog,SIGNAL(canceled()),this,SLOT(on_user_cancel()));

    pew->dialog = dialog; // new QProgressDialog(this);
    if (useModal->isChecked()) {
        dialog->setWindowTitle("Modal Progress Dialog");
        pew->dialog->setWindowModality(Qt::WindowModal);
    } else {
        dialog->setWindowTitle("Modeless Progress Dialog");
        pew->dialog->setWindowModality(Qt::NonModal);
    }
    int max_secs = (int)(WAIT_MS / 1000);
    msg.sprintf("Progress information... estimate %d seconds...",max_secs);
    pew->dialog->setLabelText(msg);
    cur_secs = 0;
    last_secs = 0;
    pew->dialog->setRange(cur_secs,max_secs);
    pew->dialog->show();
    dialog->raise();
    pw = (PWORK)pew;
#else  // !ADD_PROGRESS_DIALOG y/n
    pw = new WORK;
#endif // ADD_PROGRESS_DIALOG y/n

    pw->done = false;
    appendWorkList(pw);
    pw->desc.sprintf("Waste Time %d", total_work);
    pw->tt.start();
#ifdef ADD_VOID_PTR
    pw->test_num = m_workThread->work(waste_time,pw);
#else
    pw->test_num = m_workThread->work(waste_time);
#endif
    msg.sprintf("Waste Time: Job %d to thread...", pw->test_num);
    setStatusMessage(msg);
}

void MainWindow::setStatusMessage(QString msg)
{
    m_StatusBar->showMessage(msg);
    add2Log("STATUS: "+msg);
}

void MainWindow::appendWorkList(PWORK pw)
{
    m_workList.append(pw);
    work_count++;
    total_work++;
}
void MainWindow::clearWorkList()
{
    while (!m_workList.isEmpty())
        delete m_workList.takeFirst();
}

void MainWindow::done_work(int id, int ms)
{
    if (g_inCloseEvent)
        return; // closing
    QString msg, tmp;
    int max = m_workList.count();
    PWORK pw;
    int i;
    int done_cnt = 0;
    int ind = -1;
    for (i = 0; i < max; i++) {
        pw = m_workList.at(i);
        if (pw->done)
            done_cnt++;
        if (pw->test_num == id)
            ind = i;
    }
    done_cnt++; // count one more as DONE
    if (work_count)
        work_count--;
    if (ind != -1) {
        pw = m_workList.at(ind);
        pw->done = true;
        msg = "Work: '"+pw->desc+"'' in "+getElapTimeStg(ms);
        tmp.sprintf(", done %d of %d. ",done_cnt,max);
        msg.append(tmp);
        if (done_cnt == max)
            msg.append("LAST");
#ifdef ADD_PROGRESS_DIALOG
        PEXTWORK pew = (PEXTWORK)pw;
        if (pew->dialog) {
            pew->dialog->hide();
            delete pew->dialog;
        }
        pew->dialog = 0;
        dialog = 0;
#endif // ADD_PROGRESS_DIALOG
    } else {
        msg.sprintf("INTERNAL PROBLEM: No 'work' of num %d in QUEUE of %d!", id, max);
    }
    setStatusMessage(msg);
}

#ifdef ADD_PROGRESS_DIALOG
void MainWindow::on_user_cancel()
{
    if (dialog)
        dialog->setLabelText("Registered user abort... await thread exit...");
    g_UserCancel = true;
}
void MainWindow::on_modal_toggle(bool b)
{
    m_Settings->setValue("check/modal",b);
}

#endif // ADD_PROGRESS_DIALOG

// TRY HTML MSG
void MainWindow::on_about()
{
    QString msg;
    msg.append("<html><body><p>");
    msg.append(PGM_NAME);
    msg.append(" Version: ");
    msg.append(PGM_VERSION);
    msg.append(", dated ");
    msg.append(PGM_DATE);
    msg.append("</p><p>");
    msg.append("Built: ");
    msg.append(__DATE__);
    msg.append(" at ");
    msg.append(__TIME__);
    msg.append("</p>");
    msg.append("<p>Purpose: Developing and testing Qt threading</p>");
    msg.append("<p><b>Source: <a href=\"http://geoffair.org/projects/threading.htm\">http://geoffair.org/projects/threading.htm</a></b></p>");
    msg.append("<p>License: GNU GPL v2 or later - see LICENSE.txt</p>");
    msg.append("<p>Copyright: &copy; Geoff R. McLane</p>");
    msg.append("</body></html>");
    QMessageBox::about(this, tr("About Threading"), msg);
}

void MainWindow::on_about_qt()
{
    QMessageBox::aboutQt(this, "About Qt");
}

#ifdef ADD_VOID_PTR
void MainWindow::waste_time(void * vp)
{
    QTime tm;
    QString msg;
    int ms;
    PWORK pw = (PWORK)vp;
    msg = "Starting: "+pw->desc;
    outLog(msg,3);
    logged.append(msg);
    tm.start();
    qulonglong cycles = 0;
#ifdef ADD_PROGRESS_DIALOG
    //PEXTWORK pew = (PEXTWORK)pw;
    max_secs = (int)(WAIT_MS / 1000);
    //QProgressDialog *dialog = pew->dialog;
    //dialog = pew->dialog;
    //dialog->setLabelText("Progress information...");
    cur_secs = 0;
    last_secs = 0;
    //dialog->setRange(cur_secs,max_secs);
    //dialog->show(); ***THIS BLOWS UP!!!***
    //dialog->raise(); *** AND THIS ***
#endif // ADD_PROGRESS_DIALOG
    ms = tm.elapsed();
    msg = "";
    while (ms < WAIT_MS) {
        cycles++;
#ifdef ADD_PROGRESS_DIALOG
        if (g_UserCancel) {
            msg = "User cancel: ";
            break;
        }
        cur_secs = (int)(ms / 1000);
//        if (cur_secs != last_secs) {
//            last_secs = cur_secs;
//            if (cur_secs > max_secs)
//                cur_secs = max_secs;
//            dialog->setValue(cur_secs); ***THIS BLOWS UP***
//        }
#endif // ADD_PROGRESS_DIALOG
        ms = tm.elapsed();
    }
#ifdef ADD_PROGRESS_DIALOG
//    dialog->hide();
//    delete dialog;
#endif // ADD_PROGRESS_DIALOG

    msg.append("Ending: ");
    msg.append(pw->desc);
    msg.append(" Done in ");
    msg.append(getElapTimeStg(tm.elapsed()));
    msg.append(", cycles ");
    msg.append(util_getNiceNumber(QString::number(cycles)));
    outLog(msg,3);  // add2Log(msg,3);
    logged.append(msg);
}
#else
void MainWindow::waste_time()
{
    QTime tm;
    QString msg;
    tm.start();
    qulonglong cycles = 0;
    while (tm.elapsed() < WAIT_MS)
        cycles++;
    msg = "waste_time: Done in ";
    msg.append(getElapTimeStg(tm.elapsed()));
    msg.append(", cycles ");
    msg.append(util_getNiceNumber(QString::number(cycles)));
    add2Log(msg);
}
#endif

// eof - mainwindow.cpp
