	
// TidyDocument.h : Declaration of the CTidyDocument

#ifndef __TIDYDOCUMENT_H_
#define __TIDYDOCUMENT_H_

#include "resource.h"       // main symbols

#define __TIDYENUM_H__
#include <tidy.h>
#undef null
#include "TidyCOMCP.h"

#define LIBRARY_MAJOR 1
#define LIBRARY_MINOR 0

/////////////////////////////////////////////////////////////////////////////
// CTidyDocument
class ATL_NO_VTABLE CTidyDocument : 
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CTidyDocument, &CLSID_TidyDocument>,
	public ISupportErrorInfo,
	public IConnectionPointContainerImpl<CTidyDocument>,
	public IDispatchImpl<ITidyDocument, &IID_ITidyDocument, &LIBID_TidyATL>,
	public CProxy_ITidyDocumentEvents< CTidyDocument >,
  public IProvideClassInfo2Impl<&CLSID_TidyDocument, 
                                &DIID_ITidyDocumentEvents,
                                &LIBID_TidyATL,
                                LIBRARY_MAJOR, LIBRARY_MINOR>

{
protected:
  TidyDoc _tdoc;

  static Bool ReportFilter( TidyDoc tdoc, TidyReportLevel lvl,
                            uint line, uint col, ctmbstr mssg );

public:
	CTidyDocument()
    : _tdoc( NULL )
	{
		m_pUnkMarshaler = NULL;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_TIDYDOCUMENT)
DECLARE_GET_CONTROLLING_UNKNOWN()

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CTidyDocument)
	COM_INTERFACE_ENTRY(ITidyDocument)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY_AGGREGATE(IID_IMarshal, m_pUnkMarshaler.p)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
  COM_INTERFACE_ENTRY(IProvideClassInfo2)
  COM_INTERFACE_ENTRY(IProvideClassInfo)
END_COM_MAP()

BEGIN_CONNECTION_POINT_MAP(CTidyDocument)
CONNECTION_POINT_ENTRY(DIID_ITidyDocumentEvents)
END_CONNECTION_POINT_MAP()

	HRESULT FinalConstruct();
	void FinalRelease();

	CComPtr<IUnknown> m_pUnkMarshaler;

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// ITidyDocument
public:
	STDMETHOD(GetOptInt)(/*[in]*/ TidyOptionId optId, /*[out, retval]*/ long* val);
	STDMETHOD(GetOptBool)(/*[in]*/ TidyOptionId optId, /*[out, retval]*/ BOOL* val);
	STDMETHOD(GetOptValue)(/*[in]*/ TidyOptionId optId, /*[out, retval]*/ BSTR* val);
	STDMETHOD(SetOptInt)(/*[in]*/ TidyOptionId optId, /*[in]*/ long val, /*[out, retval]*/ int* status);
	STDMETHOD(SetOptBool)(/*[in]*/ TidyOptionId optId, /*[in]*/ BOOL val, /*[out, retval]*/ int* status);
	STDMETHOD(SetOptValue)(/*[in]*/ TidyOptionId optId, BSTR val, /*[out, retval]*/ int* status);
	STDMETHOD(SetErrorFile)(/*[in]*/ BSTR errorFilename, /*[out, retval]*/ int* status);
	STDMETHOD(SaveString)(/*[out, retval]*/ BSTR* putHere);
	STDMETHOD(ParseString)(/*[in]*/ BSTR content, /*[out, retval]*/ int* status);
	STDMETHOD(RunDiagnostics)(/*[out, retval]*/ int* status);
	STDMETHOD(CleanAndRepair)(/*[out, retval]*/ int* status);
	STDMETHOD(SaveFile)(/*[in]*/ BSTR contentFile, /*[out, retval]*/ int* status);
	STDMETHOD(ParseFile)(/*[in]*/ BSTR contentFilename, /*[out, retval]*/ int* status);
	STDMETHOD(LoadConfig)(/*[in]*/ BSTR configFilename, /*[out, retval]*/ int* status);
};

#endif //__TIDYDOCUMENT_H_
