Imports System.IO
Public Class INIFileHandler
    Private m_sections As Sections
    Public Sub New()
        m_sections = New Sections
    End Sub
    '''<summary>Reads in INI File</summary>
    ''' <param name="strINIFile">FullPath of INI file to read in</param>
    Public Sub New(ByVal strINIFile As String)
        Me.New()
        ReadFile(strINIFile)
    End Sub
    Public Sub Dispose()
        If m_sections IsNot Nothing Then
            m_sections = Nothing
        End If
    End Sub
    Public ReadOnly Property Sections() As Sections
        Get
            Return m_sections
        End Get
    End Property
    Public ReadOnly Property Sections(ByVal name As String) As Section
        Get
            Dim secReturn As New Section("")

            Try
                secReturn = m_sections.Sections(Name)

            Catch ex As Exception

            End Try

            If secReturn IsNot Nothing Then
                Return secReturn
            Else
                Return New section("")
            End If

        End Get
    End Property
    Public ReadOnly Property Sections(ByVal index As Integer) As Section
        Get
            Dim secReturn As New Section("")

            Try
                secReturn = m_sections.Sections(index)

            Catch ex As Exception

            End Try

            If secReturn IsNot Nothing Then
                Return secReturn
            Else
                Return New section("")
            End If
        End Get
    End Property
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '~ ReadFile: Pass in name of INI File, returns true if OK
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '''<summary>Reads in INI File</summary>
    '''<returns>Returns TRUE if OK</returns>
    ''' <param name="strINIFile">FullPath of INI file to read in</param>
    Public Function ReadFile(ByVal strINIFile As String) As Boolean

        Dim blnOK As Boolean = False

        Try

            Dim srFile As StreamReader = File.OpenText(strINIFile)
            Dim strFile As String = srFile.ReadToEnd()

            Dim strSectionName As String = ""
            Dim strSetting() As String = Nothing
            Dim strKey As String = ""
            Dim strValue As String = ""
            Dim strLine() As String = Split(strFile, vbCrLf)

            '~~~~~~~~~~~~~~~~~~~~~~~~
            '~ Zap files
            '~~~~~~~~~~~~~~~~~~~~~
            strFile = Nothing
            srFile.Close()
            srFile.Dispose()
            srFile = Nothing

            '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            '~ Loop for each line in file
            '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            For nI As Integer = 0 To strLine.Length - 1
                Debug.Write(strLine(nI).ToString & vbCrLf)
                If (strLine(nI).Trim.Length > 0) AndAlso (Not strLine(nI).StartsWith(";")) Then
                    If strLine(nI).ToUpper.StartsWith("[") Then '~ line is a section header, e.g. [GENERAL]
                        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                        '~ Section
                        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                        strSectionName = strLine(nI).Substring(1, strLine(nI).Length - 2)
                        m_sections.AddSection(strSectionName)
                    Else
                        If strSectionName.Length > 0 Then
                            strSetting = Split(strLine(nI), "=", 2)
                            strKey = strSetting(0).ToString.Trim
                            strValue = strSetting(1).ToString.Trim
                            m_sections.AddSetting(strKey, strValue)
                        End If
                    End If
                End If
            Next

            blnOK = True

        Catch ex As Exception
            blnOK = False

        End Try

        Return blnOK

    End Function
    Public Function WriteINIFile(ByVal strFileName As String) As Boolean

        Dim blnOK As Boolean = False

        Try
            Dim strINIDoc As String = Me.ToString()

            If strINIDoc IsNot Nothing AndAlso strINIDoc.Length > 0 Then
                'If Not strPath.EndsWith("\") Then
                ' strPath = strPath & "\"
                'End If
                Dim fs As New FileStream(strFileName, FileMode.Create, FileAccess.Write)
                Dim writer As New StreamWriter(fs)

                writer.Write(strINIDoc)

                writer.Flush()
                fs.Flush()
                fs.Close()
                fs.Dispose()
                fs = Nothing

                blnOK = True
            Else
                blnOK = False
            End If

        Catch ex As Exception
            blnOK = False

        End Try

        Return blnOK

    End Function
    Public Overrides Function ToString() As String

        Dim strReturn As String = ""

        Try
            Dim strINIDoc As String = ""

            For nSec As Integer = 0 To m_sections.Count - 1

                strINIDoc &= "[" & m_sections.Sections(nSec).Name & "]" & vbCrLf

                For nSetting As Integer = 0 To m_sections.Sections(nSec).Settings.Count - 1
                    Dim strSetting As String = m_sections.Sections(nSec).Settings(nSetting)
                    Dim strKey As String = m_sections.Sections(nSec).Keys(nSetting)
                    strINIDoc &= strKey & "=" & strSetting & vbCrLf
                Next

                strINIDoc &= "" & vbCrLf
            Next

            strReturn = strINIDoc.Trim

        Catch ex As Exception
            strReturn = ""

        End Try

        Return strReturn

    End Function

End Class
Public Class Sections
    Inherits System.Collections.Specialized.NameObjectCollectionBase
    Private m_section As Section
    Public Sub New()
        '~ 
    End Sub
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '~ AddSection: Adds a Section(Name)
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '''<summary>Adds Setting(Key, Value) to Section </summary>
    ''' <param name="Name">The Key(name) of the setting</param>
    Public Sub AddSection(ByVal name As String)
        m_section = New Section(Name)
        MyBase.BaseAdd(Name, m_section)
    End Sub
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '~ AddSetting: Adds Setting(Key, Value) to Section 
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '''<summary>Adds Setting(Key, Value) to Section </summary>
    ''' <param name="Name">The Key(name) of the setting</param>
    ''' <param name="Value">The Value of the setting</param>
    Public Sub AddSetting(ByVal name As String, ByVal value As String)
        m_section.AddSetting(Name, Value)
    End Sub
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '~ Sections
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '''<summary>Get Named section</summary>
    '''<returns>Returns Section</returns>
    ''' <param name="Name">Name of Section</param>
    Public ReadOnly Property Sections(ByVal name As String) As Section
        Get
            Return CType(MyBase.BaseGet(Name), Section)
        End Get
    End Property
    '''<summary>Get Named section</summary>
    '''<returns>Returns Section</returns>
    ''' <param name="Index"># of Section</param>
    Public ReadOnly Property Sections(ByVal index As Integer) As Section
        Get
            Return CType(MyBase.BaseGet(Index), Section)
        End Get
    End Property
End Class
Public Class Section
    Private m_colSettings As New System.Collections.Specialized.NameValueCollection
    Private m_strSectionName As String = ""
    Friend Sub New(ByVal name As String)
        m_strSectionName = Name
    End Sub
    Friend Sub dispose()
        If m_colSettings IsNot Nothing Then
            m_colSettings = Nothing
        End If
    End Sub
    Public ReadOnly Property Name() As String
        Get
            Return m_strSectionName
        End Get
    End Property
    Friend Sub AddSetting(ByVal name As String, ByVal value As String)
        m_colSettings.Add(name, value)
    End Sub
    Friend Sub SetSetting(ByVal name As String, ByVal value As String)
        m_colSettings.Set(name, value)
    End Sub
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '~ Returns a Settings collection
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '''<summary>Get Settings collection</summary>
    '''<returns>Returns Settings Collection</returns>
    Public ReadOnly Property Settings() As System.Collections.Specialized.NameValueCollection
        Get
            Return m_colSettings
        End Get
    End Property
    Public ReadOnly Property Settings(ByVal name As String) As String
        Get
            Dim strReturn As String = ""

            Try
                strReturn = m_colSettings(name)

            Catch ex As Exception
                strReturn = ""

            End Try

            If strReturn IsNot Nothing Then
                Return strReturn
            Else
                Return ""
            End If

        End Get
    End Property
    Public ReadOnly Property Settings(ByVal index As Integer) As String
        Get
            Dim strReturn As String = ""

            Try
                strReturn = m_colSettings(index)

            Catch ex As Exception
                strReturn = ""

            End Try

            If strReturn IsNot Nothing Then
                Return strReturn
            Else
                Return ""
            End If

        End Get
    End Property
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '~ Returns the Keyname of a setting from index
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '''<summary>Get Key by Index</summary>
    '''<returns>Returns Key name of Setting(index)</returns>
    Public ReadOnly Property Keys(ByVal index As Integer) As String
        Get
            Dim strReturn As String = ""

            Try
                strReturn = m_colSettings.GetKey(index)

            Catch ex As Exception
                strReturn = ""

            End Try

            If strReturn IsNot Nothing Then
                Return strReturn
            Else
                Return ""
            End If

        End Get
    End Property
End Class
