Option Strict Off
Option Explicit On
Imports System
Imports System.IO
Friend Class TidyInputForm
    Inherits System.Windows.Forms.Form
    Private WithEvents tdoc As Tidy.Document
    'Private WithEvents tdoc As TidyATL.TidyDocument
    Private Const INI_FILE As String = "TidyCOM.ini"
    Private Const filSect As String = "Files"
    Private Const inpSect As String = "Input"
    Private Const outSect As String = "Output"
    Private Const errSect As String = "ErrorFile"
    Private Const cfgSect As String = "ConfigFile"
    Private Const TmLog As Boolean = True
    Dim iniFile As String
    Dim logFile As String
    Dim nl As String
    Dim ini As INIFileHandler
    Public Const LOG_FILE As String = "temptidy.txt"
    Public slog As StreamWriter

    Function Slurp(ByRef filename As String) As String
        Dim content As String
        On Error GoTo Slurp_Error

        content = New String(" ", FileLen(filename) + 1)
        FileOpen(1, filename, OpenMode.Binary, OpenAccess.Read)
        FileGet(1, content)
        FileClose(1)
        Slurp = content
        Exit Function

Slurp_Error:
        Slurp = ""
    End Function
    Function UnSlurp(ByRef filename As String, ByRef content As String) As Integer
        On Error GoTo Unslurp_Error

        FileOpen(1, filename, OpenMode.Binary, OpenAccess.Write)
        FilePut(1, content)
        FileClose(1)
        UnSlurp = 0
        Exit Function

Unslurp_Error:
        UnSlurp = -Err.Number
    End Function

    Private Sub Add2INI(ByRef opt As String, ByRef val As String)
        Dim sec As Section
        Dim secs As Sections
        Dim lval As Integer, lopt As Integer
        lval = Len(val)
        lopt = Len(opt)
        If ((lval > 0) And (lopt > 0)) Then
            secs = ini.Sections
            sec = secs.Sections(filSect)
            If sec Is Nothing Then
                secs.AddSection(filSect)
                sec = secs.Sections(filSect)
            End If
            If sec IsNot Nothing Then
                sec.SetSetting(opt, val)
            End If
        End If
        Log("Added " & opt & "=" & val & " to INI set.")
    End Sub
    Private Sub Browse4Config_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Browse4Config.Click
        Dim txt As String

        On Error GoTo SkipIt

        OpenConfigDlgOpen.ShowDialog()
        txt = OpenConfigDlgOpen.FileName
        ConfigFile.Text = txt
        Add2INI(cfgSect, txt)

SkipIt:

    End Sub

    Private Sub Browse4Error_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Browse4Error.Click
        Dim txt As String
        On Error GoTo SkipIt

        ChooseErrorDlgOpen.ShowDialog()
        txt = ChooseErrorDlgOpen.FileName
        ErrorFile.Text = txt
        Add2INI(errSect, txt)

SkipIt:

    End Sub

    Private Sub Browse4Input_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Browse4Input.Click
        Dim txt As String
        On Error GoTo SkipIt

        OpenInputDlgOpen.ShowDialog()
        txt = OpenInputDlgOpen.FileName
        InputFile.Text = txt
        Add2INI(inpSect, txt)

SkipIt:

    End Sub


    Private Sub Browse4Output_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Browse4Output.Click
        Dim txt As String

        On Error GoTo SkipIt

        ChooseOutputDlgOpen.ShowDialog()
        txt = ChooseOutputDlgOpen.FileName
        OutputFile.Text = txt
        Add2INI(outSect, txt)

SkipIt:

    End Sub

    Private Sub SetInitialStatus(ByRef stg As String)
        Dim msg As String
        msg = "Parsing [" & InputFile.Text & "] " & stg & "..."
        If Len(ConfigFile.Text) Then
            msg = msg & nl & "Config: " & ConfigFile.Text
        End If
        If Len(ErrorFile.Text) Then
            msg = msg & nl & "Info: " & ErrorFile.Text
        End If
        If Len(OutputFile.Text) Then
            msg = msg & nl & "Ouptut: " & OutputFile.Text
        End If
        StatusInfo.Text = msg
        MarkupInput.Text = ""
        MarkupOutput.Text = ""
        Log("Set status to: " & msg)
    End Sub

    Private Sub DoFileAsString_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles DoFileAsString.Click
        Dim contentIn As String
        Dim contentOut As String
        Dim stat, ok As Integer
        Dim msg As String

        On Error GoTo DamnIt
        stat = 0
        SetInitialStatus("as string")
        contentIn = ""
        If Len(InputFile.Text) = 0 Then
            stat = -1
            msg = "ERROR: File name must be given!"
            Log(msg)
            MsgBox(msg)
        End If
        If stat >= 0 Then
            contentIn = Slurp(InputFile.Text)
            MarkupInput.Text = contentIn
            Log("IN: [" & contentIn & "]")
        End If

        If contentIn = "" Then
            stat = -1
            Log("NO content IN!")
        End If
        If stat >= 0 And Len(ErrorFile.Text) > 0 Then
            stat = tdoc.SetErrorFile(ErrorFile.Text)
            Log("SetErrorFile( " & ErrorFile.Text & ")")
        End If
        If stat >= 0 And Len(ConfigFile.Text) Then
            stat = tdoc.LoadConfig(ConfigFile.Text)
            Log("LoadConfig( " & ConfigFile.Text & ")")
        End If
        If stat >= 0 Then
            Log("Doing ParseString() ...")
            stat = tdoc.ParseString(contentIn)
        End If
        If stat >= 0 Then
            Log("Doing CleanAndRepair() ...")
            stat = tdoc.CleanAndRepair()
        End If
        If stat >= 0 Then
            Log("Doing RunDiagnostics() ...")
            stat = tdoc.RunDiagnostics()
        End If
        If stat >= 2 Then
            Log("Doing SetOptBool to force output ...")
            ok = tdoc.SetOptBool(TidyATL.__MIDL___MIDL_itf_Tidy_0000_0002.TidyForceOutput, True)
        End If
        If stat >= 0 Then
            Log("Gettting Tidied string ...")
            contentOut = tdoc.SaveString()
            MarkupOutput.Text = contentOut
            Log("OUT: [" & contentOut & "]")
            If Len(OutputFile.Text) Then
                stat = UnSlurp(OutputFile.Text, contentOut)
                Log("Written to " & OutputFile.Text & " ...")
            End If
        End If
        GoTo Done

DamnIt:
        Log("FuBar: In DoFileAsString_Click")
        MsgBox("Major FuBar running Tidy")
Done:
    End Sub

    Private Sub DoTidy_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles DoTidy.Click
        Dim stat, ok As Integer, msg As String
        Dim contentOut As String
        Dim contentIn As String

        On Error GoTo DamnIt
        stat = 0

        SetInitialStatus("")
        If Len(InputFile.Text) = 0 Then
            stat = -1
            msg = "ERROR: File name must be given!"
            Log(msg)
            MsgBox(msg)
        Else
            contentIn = Slurp(InputFile.Text)
            MarkupInput.Text = contentIn
            Log("IN: [" & contentIn & "]")
        End If
        If stat >= 0 And Len(ErrorFile.Text) > 0 Then
            Log("SetErrorFile(" & ErrorFile.Text & ")")
            stat = tdoc.SetErrorFile(ErrorFile.Text)
        End If
        If stat >= 0 And Len(ConfigFile.Text) > 0 Then
            Log("LoadConfig(" & ConfigFile.Text & ")")
            stat = tdoc.LoadConfig(ConfigFile.Text)
        End If
        If stat >= 0 Then
            Log("ParseFile(" & InputFile.Text & ")")
            stat = tdoc.ParseFile(InputFile.Text)
        End If
        If stat >= 0 Then
            Log("Doing CleanAndRepair() ...")
            stat = tdoc.CleanAndRepair()
        End If
        If stat >= 0 Then
            Log("Doing RunDiagnostics() ...")
            stat = tdoc.RunDiagnostics()
        End If
        If stat > 1 Then
            Log("Doing SetOptBool to force output ...")
            ok = tdoc.SetOptBool(TidyATL.__MIDL___MIDL_itf_Tidy_0000_0002.TidyForceOutput, True)
        End If
        If stat >= 0 Then
            contentOut = tdoc.SaveString()
            MarkupOutput.Text = contentOut
            Log("OUT: [" & contentOut & "]")
            If Len(OutputFile.Text) > 0 Then
                Log("Written to " & OutputFile.Text & " ...")
                stat = tdoc.SaveFile(OutputFile.Text)
            End If
        End If
        GoTo Done

DamnIt:
        Log("FuBar: In DoTidy_Click")
        MsgBox("Major FuBar running Tidy")
Done:
    End Sub

    Private Sub DoTidyStrings_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles DoTidyStrings.Click
        Dim stat, ok As Integer
        Dim msg As String
        Dim contentOut As String
        On Error GoTo DamnIt

        msg = "Parsing input string ..."
        StatusInfo.Text = msg
        Log(msg)
        stat = 0
        If Len(ErrorFile.Text) > 0 Then
            Log("SetErrorFile(" & ErrorFile.Text & ")")
            stat = tdoc.SetErrorFile(ErrorFile.Text)
        End If
        If stat >= 0 And Len(ConfigFile.Text) Then
            Log("LoadConfig(" & ConfigFile.Text & ")")
            stat = tdoc.LoadConfig(ConfigFile.Text)
        End If
        If stat >= 0 Then
            If Len(MarkupInput.Text) Then
                Log("IN: to ParseString(" & MarkupInput.Text & ")")
                stat = tdoc.ParseString(MarkupInput.Text)
            Else
                msg = msg & nl & "ERROR: No text to Tidy!"
                StatusInfo.Text = msg
                Log(msg)
                stat = -1
            End If
        End If
        If stat >= 0 Then
            Log("Doing CleanAndRepair() ...")
            stat = tdoc.CleanAndRepair()
        End If
        If stat >= 0 Then
            Log("Doing RunDiagnostics() ...")
            stat = tdoc.RunDiagnostics()
        End If
        If stat > 1 Then
            Log("Doing SetOptBool to force output ...")
            ok = tdoc.SetOptBool(TidyATL.__MIDL___MIDL_itf_Tidy_0000_0002.TidyForceOutput, True)
        End If
        If stat >= 0 Then
            Log("Doing SetOptInt to output BOM...")
            ok = tdoc.SetOptInt(TidyATL.__MIDL___MIDL_itf_Tidy_0000_0002.TidyOutputBOM, False)
            contentOut = tdoc.SaveString()
            MarkupOutput.Text = contentOut
            Log("OUT: [" & contentOut & "]")
            If Len(OutputFile.Text) > 0 Then
                Log("Written to " & OutputFile.Text & " ...")
                stat = tdoc.SaveFile(OutputFile.Text)
            End If
        End If
        msg = msg & nl & "Status = " & stat
        StatusInfo.Text = msg
        GoTo Done

DamnIt:
        Log("FuBar: In DoTidyStrings_Click")
        MsgBox("Major FuBar running Tidy")
Done:
    End Sub

    Private Sub TidyInputForm_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        Dim secs As Sections
        Dim sec As Section
        Dim str As String
        Dim I As Integer
        Dim J As Integer
        Dim nv As System.Collections.Specialized.NameValueCollection
        Dim ky As String
        Dim va() As String
        Dim val As String
        Try
            str = Directory.GetCurrentDirectory()
            iniFile = str & "\" & INI_FILE
            logFile = str & "\" & LOG_FILE
            nl = Chr(13) & Chr(10)
            slog = File.CreateText(logFile) ' CREATE the logging file
            Log("Created log file " & logFile)
            Log("Creating Tidy DOCUMENT ...")
            'tdoc = New TidyATL.TidyDocument
            tdoc = New Tidy.Document
            Log("Loading INI " & iniFile)
            ErrorFile.Text = ""
            ConfigFile.Text = ""
            InputFile.Text = ""
            OutputFile.Text = ""
            StatusInfo.Text = ""
            ini = New INIFileHandler(iniFile)
            secs = ini.Sections
            sec = secs.Sections(filSect)
            For I = 0 To secs.Count - 1
                str = secs.Keys(I)
                sec = secs.Sections(str)
                nv = sec.Settings()
                For J = 0 To nv.Count - 1
                    ky = nv.GetKey(J)
                    va = nv.GetValues(ky)
                    val = va(0)
                    If va.Length() = 1 Then
                        ' inpSect = "Input"
                        ' outSect = "Output"
                        ' errSect = "ErrorFile"
                        ' cfgSect = "ConfigFile"
                        If Len(val) Then
                            If ky = inpSect Then
                                InputFile.Text = val
                            ElseIf ky = outSect Then
                                OutputFile.Text = val
                            ElseIf ky = errSect Then
                                ErrorFile.Text = val
                            ElseIf ky = cfgSect Then
                                ConfigFile.Text = val
                            End If
                        End If
                    End If
                Next J
            Next I
        Catch ex As Exception
            str = "ERROR: Exception ... " & ex.Message
            GoTo DamnIt
        End Try
        GoTo Done
DamnIt:
        val = "Major FuBar running Tidy"
        val = val & Chr(13) & Chr(10)
        val = val & str
        val = val & Chr(13) & Chr(10)
        val = val & "On OK, will abort application ..."
        MsgBox(val)
        Log(val)
        Me.Close()
Done:
    End Sub

    ' enum __MIDL___MIDL_itf_Tidy_0000_0009 {
    'TidyInfo	     = 0,
    'TidyWarning     = TidyInfo + 1,
    'TidyConfig	     = TidyWarning + 1,
    'TidyAccess	     = TidyConfig + 1,
    'TidyError	     = TidyAccess + 1,
    'TidyBadDocument = TidyError + 1,
    'TidyFatal	     = TidyBadDocument + 1
    '} 	TidyReportLevel;
    Private Sub tdoc_OnMessage(ByVal level As TidyATL.TidyReportLevel, ByVal line As Integer, ByVal col As Integer, ByVal msg As String)
        'Dim TidySystem As Object
        Dim lvl As String, lin As String

        lvl = ""
        If level = TidyATL.__MIDL___MIDL_itf_Tidy_0000_0009.TidyInfo Then
            lvl = "Info: "
        ElseIf level = TidyATL.__MIDL___MIDL_itf_Tidy_0000_0009.TidyWarning Then
            lvl = "Warning: "
        ElseIf level = TidyATL.__MIDL___MIDL_itf_Tidy_0000_0009.TidyConfig Then
            lvl = "Config: "
        ElseIf level = TidyATL.__MIDL___MIDL_itf_Tidy_0000_0009.TidyAccess Then
            lvl = "Access: "
        ElseIf level = TidyATL.__MIDL___MIDL_itf_Tidy_0000_0009.TidyError Then
            lvl = "Error: "
        ElseIf level = TidyATL.__MIDL___MIDL_itf_Tidy_0000_0009.TidyBadDocument Then
            lvl = "Doc: "
        ElseIf level = TidyATL.__MIDL___MIDL_itf_Tidy_0000_0009.TidyFatal Then
            lvl = "Fatal: "
        Else
            lvl = "???: "
        End If

        If line > 0 Then
            lin = lvl & "Line " & line & "Col " & col & ", " & msg
        Else
            lin = lvl & msg
        End If

        Log(lin)

        If Len(StatusInfo.Text) > 0 Then
            StatusInfo.Text = StatusInfo.Text & nl & lin
        Else
            StatusInfo.Text = lin
        End If
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        On Error GoTo DamnIt
        Log("In EXIT - Write INI file " & iniFile)
        ini.WriteINIFile(iniFile)
        slog.Close()
DamnIt:
        Me.Close()
    End Sub

    Private Sub tdoc_OnMessage1(ByVal level As TidyATL.TidyReportLevel, ByVal line As Integer, ByVal col As Integer, ByVal message As String) Handles tdoc.OnMessage
        tdoc_OnMessage(level, line, col, message)
    End Sub

    Private Sub Log(ByRef msg As String)
        On Error GoTo DamnIt
        If TmLog Then
            TimeLog(msg, slog)
        Else
            slog.WriteLine(msg)
            slog.Flush()
        End If
DamnIt:
    End Sub

    Private Function LogTime(ByVal dt As DateTime) As String
        Dim dtxt As String = dt.ToString("T")
        Dim txt As String = ""
        If dtxt.Substring(1, 1) = ":" Then
            txt = " " & dtxt
        Else
            txt = dtxt
        End If
        txt &= " "
        dtxt = dt.ToString("d")
        If dtxt.Substring(1, 1) = "/" Then
            txt &= " " & dtxt
        Else
            txt &= dtxt
        End If
        LogTime = txt
    End Function

    Private Sub TimeLog(ByVal msg As String, ByVal w As TextWriter)
        Dim dt As DateTime = DateTime.Now
        Dim arr As Array = msg.Split(ControlChars.Lf)
        Dim I, J As Integer
        Dim txt As String
        For I = 0 To UBound(arr)
            txt = CStr(arr.GetValue(I)).Trim()
            If txt.Length() > 0 Then
                J = txt.IndexOf(ControlChars.Cr)
                If J > 0 Then
                    txt = txt.Substring(0, J)
                End If
                If I = 0 Then
                    w.Write("{0} ", LogTime(dt))
                Else
                    w.Write("                    ")
                End If
                w.WriteLine("[{0}]", txt)
            End If
        Next
        w.Flush()
    End Sub

End Class
