VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form TidyInputForm 
   Caption         =   "TidyInputForm"
   ClientHeight    =   6225
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5955
   ScaleHeight     =   6225
   ScaleWidth      =   5955
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox MarkupInput 
      Height          =   1212
      Left            =   720
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   13
      Top             =   2220
      Width           =   5172
   End
   Begin VB.TextBox StatusInfo 
      Height          =   1212
      Left            =   720
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   17
      Top             =   4860
      Width           =   5112
   End
   Begin VB.CommandButton DoFileAsString 
      Caption         =   "Tidy File as Strings!"
      Height          =   432
      Left            =   4560
      TabIndex        =   19
      Top             =   720
      Width           =   1272
   End
   Begin VB.CommandButton DoTidyStrings 
      Caption         =   "Tidy Strings!"
      Height          =   432
      Left            =   4620
      TabIndex        =   20
      Top             =   1620
      Width           =   1272
   End
   Begin VB.TextBox MarkupOutput 
      Height          =   1212
      Left            =   720
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   15
      Top             =   3540
      Width           =   5172
   End
   Begin VB.CommandButton Browse4Error 
      Caption         =   "Choose..."
      Height          =   312
      Left            =   3660
      TabIndex        =   11
      Top             =   1500
      Width           =   792
   End
   Begin VB.TextBox ErrorFile 
      Height          =   288
      Left            =   780
      TabIndex        =   10
      Top             =   1500
      Width           =   2832
   End
   Begin MSComDlg.CommonDialog OpenConfigDlg 
      Left            =   360
      Top             =   180
      _ExtentX        =   688
      _ExtentY        =   688
      _Version        =   393216
      DialogTitle     =   "Open Tidy Configuration File"
      Filter          =   "Tidy Config(*.tidy)|*.tidy|Text Files (*.txt)|*.txt|Config Files (*.cfg)|*.cfg|All Files (*.*)|*.*"
      Flags           =   4096
   End
   Begin VB.CommandButton DoTidy 
      Caption         =   "&Tidy!"
      Height          =   432
      Left            =   4560
      TabIndex        =   18
      Top             =   180
      Width           =   1272
   End
   Begin VB.CommandButton Browse4Output 
      Caption         =   "Choose..."
      Height          =   312
      Left            =   3660
      TabIndex        =   8
      Top             =   1080
      Width           =   792
   End
   Begin VB.TextBox OutputFile 
      Height          =   288
      Left            =   780
      TabIndex        =   7
      Top             =   1080
      Width           =   2832
   End
   Begin VB.CommandButton Browse4Input 
      Caption         =   "Browse..."
      Height          =   312
      Left            =   3660
      TabIndex        =   5
      Top             =   660
      Width           =   792
   End
   Begin VB.TextBox InputFile 
      Height          =   288
      Left            =   780
      TabIndex        =   4
      Top             =   660
      Width           =   2832
   End
   Begin VB.CommandButton Browse4Config 
      Caption         =   "Browse..."
      Height          =   312
      Left            =   3660
      TabIndex        =   2
      Top             =   240
      Width           =   792
   End
   Begin VB.TextBox ConfigFile 
      Height          =   288
      Left            =   780
      TabIndex        =   1
      Top             =   240
      Width           =   2832
   End
   Begin MSComDlg.CommonDialog OpenInputDlg 
      Left            =   360
      Top             =   660
      _ExtentX        =   688
      _ExtentY        =   688
      _Version        =   393216
      DialogTitle     =   "Open Markup File"
      Filter          =   "HTML File (*.htm,*.htm)|*.html;*.htm|XML Files (*.xml,*.xsd,*.xsl)|*.xml;*.xsd;*.xsl|All Files (*.*)|*.*"
      Flags           =   4096
   End
   Begin MSComDlg.CommonDialog ChooseOutputDlg 
      Left            =   360
      Top             =   1080
      _ExtentX        =   688
      _ExtentY        =   688
      _Version        =   393216
      DialogTitle     =   "Choose Markup Output File"
      Filter          =   "HTML File (*.html,*.htm)|*.html;*.htm|XML Files (*.xml,*.xsd,*.xsl)|*.xml;*.xsd;*.xsl|All Files (*.*)|*.*"
      Flags           =   2050
   End
   Begin MSComDlg.CommonDialog ChooseErrorDlg 
      Left            =   360
      Top             =   1500
      _ExtentX        =   688
      _ExtentY        =   688
      _Version        =   393216
      DialogTitle     =   "Choose Error File"
      FileName        =   "tidyerr.txt"
      Filter          =   "Text Files (*.txt)|*.txt|All Files (*.*)|*.*"
      Flags           =   2050
   End
   Begin VB.Label MsgLabel 
      Caption         =   "Msgs"
      Height          =   192
      Left            =   120
      TabIndex        =   16
      Top             =   4920
      Width           =   492
   End
   Begin VB.Label Label3 
      Caption         =   "Output"
      Height          =   192
      Left            =   120
      TabIndex        =   14
      Top             =   3540
      Width           =   492
   End
   Begin VB.Label Label2 
      Caption         =   "Input"
      Height          =   192
      Left            =   180
      TabIndex        =   12
      Top             =   2280
      Width           =   432
   End
   Begin VB.Label Label1 
      Caption         =   "Error"
      Height          =   252
      Left            =   60
      TabIndex        =   9
      Top             =   1560
      Width           =   432
   End
   Begin VB.Label OutputLabel 
      Caption         =   "Output"
      Height          =   252
      Left            =   60
      TabIndex        =   6
      Top             =   1140
      Width           =   552
   End
   Begin VB.Label InputLabel 
      Caption         =   "Input"
      Height          =   252
      Left            =   120
      TabIndex        =   3
      Top             =   720
      Width           =   492
   End
   Begin VB.Label ConfigLabel 
      Caption         =   "Config"
      Height          =   252
      Left            =   120
      TabIndex        =   0
      Top             =   240
      Width           =   552
   End
End
Attribute VB_Name = "TidyInputForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private WithEvents tdoc As TidyDocument
Attribute tdoc.VB_VarHelpID = -1
Dim nl As String
Function Slurp(filename As String) As String
  Dim content As String
  Dim size As Long
  On Error GoTo Slurp_Error
    
  content = String(FileLen(filename) + 1, " ")
  Open filename For Binary Access Read As #1
  Get #1, , content
  Close #1
  Slurp = content
  Exit Function
  
Slurp_Error:
  Slurp = ""
End Function
Function UnSlurp(filename As String, content As String) As Long
  Dim size As Long
  On Error GoTo Unslurp_Error
 
  Open filename For Binary Access Write As #1
  Put #1, , content
  Close #1
  UnSlurp = 0
  Exit Function
  
Unslurp_Error:
  UnSlurp = -Err.Number
End Function
Private Sub Browse4Config_Click()

OpenConfigDlg.CancelError = True
On Error GoTo SkipIt

OpenConfigDlg.ShowOpen
ConfigFile = OpenConfigDlg.filename
SkipIt:

End Sub

Private Sub Browse4Error_Click()

ChooseErrorDlg.CancelError = True
On Error GoTo SkipIt

ChooseErrorDlg.ShowOpen
ErrorFile = ChooseErrorDlg.filename
SkipIt:

End Sub

Private Sub Browse4Input_Click()

OpenInputDlg.CancelError = True
On Error GoTo SkipIt

OpenInputDlg.ShowOpen
InputFile = OpenInputDlg.filename
SkipIt:

End Sub


Private Sub Browse4Output_Click()

ChooseOutputDlg.CancelError = True
On Error GoTo SkipIt

ChooseOutputDlg.ShowOpen
OutputFile = ChooseOutputDlg.filename
SkipIt:

End Sub

Private Sub DoFileAsString_Click()
  Dim contentIn As String
  Dim contentOut As String
  Dim stat As Long, ok As Long
  
  On Error GoTo DamnIt
  stat = 0
  StatusInfo = "Parsing " & InputFile & " as string ..."
  contentIn = Slurp(InputFile)
  MarkupInput = contentIn
  If contentIn = "" Then
    stat = -1
  End If
  If stat >= 0 And Len(ErrorFile) > 0 Then
    stat = tdoc.SetErrorFile(ErrorFile)
  End If
  If stat >= 0 Then
      stat = tdoc.LoadConfig(ConfigFile)
  End If
  If stat >= 0 Then
    stat = tdoc.ParseString(contentIn)
  End If
  If stat >= 0 Then
    stat = tdoc.CleanAndRepair()
  End If
  If stat >= 0 Then
    stat = tdoc.RunDiagnostics()
  End If
  If stat >= 2 Then
    ok = tdoc.SetOptBool(TidyForceOutput, True)
  End If
  If stat >= 0 Then
    contentOut = tdoc.SaveString()
    MarkupOutput = contentOut
    stat = UnSlurp(OutputFile, contentOut)
  End If
  GoTo Done
  
DamnIt:
  MsgBox "Major FuBar running Tidy"
  
Done:
End Sub

Private Sub DoTidy_Click()
  Dim stat As Long, ok As Long
  
  On Error GoTo DamnIt
  stat = 0
  StatusInfo = "Parsing " & InputFile & " ..."
  If Len(ErrorFile) > 0 Then
    stat = tdoc.SetErrorFile(ErrorFile)
  End If
  If stat >= 0 Then
      stat = tdoc.LoadConfig(ConfigFile)
  End If
  If stat >= 0 Then
    stat = tdoc.ParseFile(InputFile)
  End If
  If stat >= 0 Then
    stat = tdoc.CleanAndRepair()
  End If
  If stat >= 0 Then
    stat = tdoc.RunDiagnostics()
  End If
  If stat > 1 Then
    ok = tdoc.SetOptBool(TidyForceOutput, True)
  End If
  If stat >= 0 Then
    stat = tdoc.SaveFile(OutputFile)
  End If
  GoTo Done
  
DamnIt:
  MsgBox "Major FuBar running Tidy"
  
Done:
End Sub

Private Sub DoTidyStrings_Click()
  Dim stat As Long, ok As Long
  
  StatusInfo = "Parsing input string ..."
  
  On Error GoTo DamnIt
  stat = 0
  If Len(ErrorFile) > 0 Then
    stat = tdoc.SetErrorFile(ErrorFile)
  End If
  If stat >= 0 Then
    stat = tdoc.LoadConfig(ConfigFile)
  End If
  If stat >= 0 Then
    stat = tdoc.ParseString(MarkupInput)
  End If
  If stat >= 0 Then
    stat = tdoc.CleanAndRepair()
  End If
  If stat >= 0 Then
    stat = tdoc.RunDiagnostics()
  End If
  If stat > 1 Then
    ok = tdoc.SetOptBool(TidyForceOutput, True)
  End If
  If stat >= 0 Then
    ok = tdoc.SetOptInt(TidyOutputBOM, False)
    MarkupOutput = tdoc.SaveString()
  End If
  GoTo Done
  
DamnIt:
  MsgBox "Major FuBar running Tidy"
  
Done:
End Sub

Private Sub Form_Load()
    nl = Chr(13) & Chr(10)
    Set tdoc = New TidyDocument
End Sub


Private Sub tdoc_OnMessage(ByVal level As TidyReportLevel, ByVal line As Long, ByVal col As Long, ByVal msg As String)
  Dim lvl As String, lin As String
  
  If level = TidyInfo Then
    lvl = "Info: "
  ElseIf level = TidyAccess Then
    lvl = "Access: "
  ElseIf level = TidyWarning Then
    lvl = "Warning: "
  ElseIf level = TidyConfig Then
    lvl = "Config: "
  ElseIf level = TidyError Then
    lvl = "Error: "
  ElseIf level = TidySystem Then
    lvl = "Doc: "
  Else
    lvl = "???: "
  End If
  
  If line > 0 Then
    lin = lvl & "Line " & line & "Col " & col & ", " & msg
  Else
    lin = lvl & msg
  End If
  
  If Len(StatusInfo) > 0 Then
    StatusInfo = StatusInfo & nl & lin
  Else
    StatusInfo = lin
  End If
End Sub
