// TidyDocument.cpp : Implementation of CTidyDocument
#include "stdafx.h"
#include "TidyATL.h"
#include "TidyDocument.h"

#include <buffio.h>
#include <errno.h>

/////////////////////////////////////////////////////////////////////////////
// CTidyDocument

STDMETHODIMP CTidyDocument::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_ITidyDocument
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (::ATL::InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

HRESULT CTidyDocument::FinalConstruct()
{
  _tdoc = tidyCreate();
  tidySetAppData( _tdoc, (void *) this );
  tidySetReportFilter( _tdoc, ReportFilter );
  // tidySetErrorSink( _tdoc, NULL );

	return CoCreateFreeThreadedMarshaler(
		GetControllingUnknown(), &m_pUnkMarshaler.p);
}

void CTidyDocument::FinalRelease()
{
  tidyRelease( _tdoc );
  _tdoc = NULL;
	m_pUnkMarshaler.Release();
}


STDMETHODIMP CTidyDocument::LoadConfig(BSTR configFilename, int* status)
{
  USES_CONVERSION;
  ctmbstr filnam = W2CA( configFilename );
	assert( _tdoc != NULL );
  *status = tidyLoadConfig( _tdoc, filnam );
  return ( *status < 0 ? S_FALSE : S_OK );
}

STDMETHODIMP CTidyDocument::ParseFile(BSTR contentFilename, int* status)
{
  USES_CONVERSION;
  ctmbstr filnam = W2CA( contentFilename );
	assert( _tdoc != NULL );
  *status = tidyParseFile( _tdoc, filnam );
  return ( *status < 0 ? S_FALSE : S_OK );
}

STDMETHODIMP CTidyDocument::SaveFile(BSTR contentFilename, int* status)
{
  USES_CONVERSION;
  ctmbstr filnam = W2CA( contentFilename );
	assert( _tdoc != NULL );
  *status = tidySaveFile( _tdoc, filnam );
  return ( *status < 0 ? S_FALSE : S_OK );
}

STDMETHODIMP CTidyDocument::CleanAndRepair(int* status)
{
	assert( _tdoc != NULL );
  *status = tidyCleanAndRepair( _tdoc );
  return ( *status < 0 ? S_FALSE : S_OK );
}

STDMETHODIMP CTidyDocument::RunDiagnostics(int* status)
{
	assert( _tdoc != NULL );
  *status = tidyRunDiagnostics( _tdoc );
  return ( *status < 0 ? S_FALSE : S_OK );
}

STDMETHODIMP CTidyDocument::ParseString(BSTR content, int *status)
{
  TidyBuffer buf = {0};
	assert( _tdoc != NULL );
  ctmbstr saveEnc = tidyOptGetCurrPick( _tdoc, TidyCharEncoding );
#if defined(UNICODE)
  USES_CONVERSION;
  BSTR wEnc = _T("UTF16LE");
  ctmbstr charStg = W2CA(wEnc);
  tidySetCharEncoding( _tdoc, charStg );
#else
  tidySetCharEncoding( _tdoc, _T("UTF16LE") );
#endif
  tidyBufInit( &buf );
  tidyBufAttach( &buf, (byte *)content, ::SysStringByteLen(content) );
  *status = tidyParseBuffer( _tdoc, &buf );
  tidySetCharEncoding( _tdoc, saveEnc );
  return ( *status < 0 ? S_FALSE : S_OK );
}

STDMETHODIMP CTidyDocument::SaveString(BSTR *putHere)
{
  TidyBuffer outbuf = {0};
	assert( _tdoc != NULL );
  ctmbstr saveEnc = tidyOptGetCurrPick( _tdoc, TidyCharEncoding );
  tidyBufInit( &outbuf );
#if defined(UNICODE)
  USES_CONVERSION;
  BSTR wEnc = _T("UTF16LE");
  ctmbstr charStg = W2CA(wEnc);
  tidySetCharEncoding( _tdoc, charStg );
#else
  tidySetCharEncoding( _tdoc, _T("UTF16LE") );
#endif
  int status = tidySaveBuffer( _tdoc, &outbuf );
  if ( status >= 0 )
  {
    ::SysFreeString(*putHere);   // Free previous string, if any.
    *putHere = ::SysAllocStringLen( (BSTR) outbuf.bp, outbuf.size / sizeof(OLECHAR) );
  }
  tidyBufFree( &outbuf );
  tidySetCharEncoding( _tdoc, saveEnc );
  return ( status < 0 ? S_FALSE : S_OK );
}

STDMETHODIMP CTidyDocument::SetErrorFile(BSTR errorFilename, int *status)
{
  USES_CONVERSION;
  ctmbstr filnam = W2CA( errorFilename );
	assert( _tdoc != NULL );
  *status = ( tidySetErrorFile(_tdoc, filnam) != NULL ? 0 : -errno );
  return ( *status < 0 ? S_FALSE : S_OK );
}


Bool TIDY_CALL CTidyDocument::ReportFilter( TidyDoc tdoc, TidyReportLevel lvl,
                                  uint line, uint col, ctmbstr mssg )
{
  USES_CONVERSION;
  CTidyDocument* comDoc = (CTidyDocument*) tidyGetAppData( tdoc );
  if ( comDoc )
  {
    BSTR wmsg = A2W( mssg );
    comDoc->Fire_OnMessage( lvl, line, col, wmsg );
  }
  return yes;
}

STDMETHODIMP CTidyDocument::SetOptValue(TidyOptionId optId, BSTR val, int *status)
{
  USES_CONVERSION;
  Bool ok = no;
  TidyOption topt = tidyGetOption( _tdoc, optId );
  if ( topt )
  {
    ctmbstr optnam = tidyOptGetName( topt );
    ctmbstr optval = W2CA( val );
    ok = tidyOptParseValue( _tdoc, optnam, optval );
  }
  *status = ( ok ? 0 : -EINVAL );
  return ( *status < 0 ? S_FALSE : S_OK );
}

STDMETHODIMP CTidyDocument::SetOptBool(TidyOptionId optId, BOOL val, int *status)
{
  Bool ok = tidyOptSetBool( _tdoc, optId, (val ? yes : no) );
  *status = ( ok ? 0 : -EINVAL );
  return ( *status < 0 ? S_FALSE : S_OK );
}

STDMETHODIMP CTidyDocument::SetOptInt(TidyOptionId optId, long val, int *status)
{
  Bool ok = tidyOptSetInt( _tdoc, optId, (uint)val );
  *status = ( ok ? 0 : -EINVAL );
  return ( *status < 0 ? S_FALSE : S_OK );
}

STDMETHODIMP CTidyDocument::GetOptValue(TidyOptionId optId, BSTR *val)
{
	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CTidyDocument::GetOptBool(TidyOptionId optId, BOOL *val)
{
	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CTidyDocument::GetOptInt(TidyOptionId optId, long *val)
{
	// TODO: Add your implementation code here

	return S_OK;
}
