/* ================================================================================
// gentests.c
// To read a test input file, and generate a windows batch file
// This includes dealing with the special batch characters <, >, |, &, ^, and space
//
// Exit Codes
// 0 - complete success
// 1 - error overlooked
// 2 - some PROBLEM - file may not have been written

   Code is PUBLIC DOMAIN. Do with it what you want ;=))
   CODE NOT FIX FOR ANY PURPOSE!!!
   Praise me if you will, but do _NOT_ blame me!!!
   2008.05.24 - Geoff McLane - http://geoffair.net/unix/grep.htm
  ================================================================================= */

#ifdef _MSC_VER
#pragma warning(disable:4996)
#endif   /* _MSC_VER */

#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <direct.h>  // for _getcwd()
#include <conio.h>   // for _getch()
#include <ctype.h>   // for toupper()

#include <sys/types.h>
#include <sys/stat.h>   // for _stat()
#ifdef _MSC_VER
/* just for checking for redirection of output */
#include <Windows.h> // for GetStdHandle( STD_OUTPUT_HANDLE );
#define VH(a)  ( a != INVALID_HANDLE_VALUE )
#endif /* _MSC_VER */

#define  PROGRAM_VERSION   "0.9"
#define  CHKMEM(a)   if( !a ) { fprintf(stderr, "ERROR: MEMORY FAILED!\n"); pgm_exit(2); }
#define  EndBuf(a)   ( a + strlen(a) )
#define  MEOR     "\r\n"
#define  Def_Verbosity 1
#define DEF_REMOVE_ESC  1   /* remove '\' char from expression */
#define DEF_ECHO "REM"      /* stay in quiet mode, if possible */
#define DEF_GREP_FILE   "tempgrep.txt"
#define ADD_GREP_TEXT 1     /* add everything to DEF_GREP_FILE for later diag */
#if ADD_GREP_TEXT
#define DEF_GREP_TEXT   ">> "DEF_GREP_FILE;
#else
#define DEF_GREP_TEXT   "> nul"
#endif
#define DEF_GREP_OPTS   "-E -e"

/* ONLY USED IN A DEBUG SITUATION
   ****************************** */
/* relative to build folder */
#define  DEF_IN_FILE "..\\tests\\spencer1.tests"
/* #define  DEF_IN_FILE "..\\tests\\spencer2.tests" */
#define  DEF_OUT_FILE   "temptest.bat"


#define  ISNUM(a)    (( a >= '0' ) && ( a <= '9' ))
#define  MX_BAT_BUFF    2048  /* max size of one batch entry */
#define  MX_ONE_CHIP    256
#define  MX_LINE_BUFF   (MX_ONE_CHIP * 4)  /* split into 256,256,256,256 */
#define  MX_TOKEN_BUFF  1024  /* to preserve the token */

/* repeat, as in config.h, which is NOT included here */
typedef struct tagSPLITTING {
   char path[_MAX_DIR];
   char drive[_MAX_DRIVE];
   char dir[_MAX_DIR];
   char fname[_MAX_FNAME];
   char ext[_MAX_EXT];
}SPLITTING, * PSPLITTING;

static char Def_Bat_Header[] =
"@if EXIST grepsetup.bat goto DOSETUP"MEOR
"@if EXIST %TEMPGREP% goto DNSETUP"MEOR
"@goto ERR1"MEOR
":DOSETUP"MEOR
"@call grepsetup"MEOR
"@if EXIST %TEMPGREP% goto DNSETUP"MEOR
"@goto ERR1"MEOR
MEOR
":DNSETUP"MEOR
"@if \"%TEMPECH%.\" == \".\" goto ERR1"MEOR
"@if \"%TEMPFIL%.\" == \".\" goto ERR1"MEOR
MEOR
"@set TEMPERR=0"MEOR
"@set TEMPCNT=0"MEOR
"@set TEMPMEE=0"MEOR
#if ADD_GREP_TEXT
"@echo Start %TIME% >> " DEF_GREP_FILE MEOR
#endif
MEOR;

static char Def_Bat_Tail[] =
"@goto DONE"MEOR
":ERR1"MEOR
"@echo %0: test not done ..."MEOR
#if ADD_GREP_TEXT
"@echo %0: test not done ... >> " DEF_GREP_FILE MEOR
#endif
"@goto END"MEOR
MEOR
":DONE"MEOR
"@if \"%TEMPMEE%.\" == \"0.\" goto ALLOK"MEOR
"@echo %0: It appears %TEMPMEE% tests failed ..."MEOR
#if ADD_GREP_TEXT
"@echo %0: It appears %TEMPMEE% tests failed ... >> " DEF_GREP_FILE MEOR
#endif
"@goto END"MEOR
":ALLOK"MEOR
"@echo %0: It appears ALL tests succeeded ..."MEOR
#if ADD_GREP_TEXT
"@echo %0: It appears ALL tests succeeded ... >> " DEF_GREP_FILE MEOR
#endif
"@goto END"MEOR
MEOR
":END"MEOR
#if ADD_GREP_TEXT
"@echo End %TIME% >> " DEF_GREP_FILE MEOR
#endif
MEOR;

// *********************************************************
#if 0
// old, excluded code
static char Def_Bat_Header_OK[] =
"@if \"%TEMPGREP%.\" == \".\" goto ERR1"MEOR
"@if NOT EXIST %TEMPGREP% goto ERR1"MEOR
":FNDGREP"MEOR
"@if \"%TEMPECH%.\" == \".\" goto SETREM"MEOR
"@goto DNSET"MEOR
":SETREM"MEOR
"@set TEMPECH=" DEF_ECHO MEOR
":DNSET"MEOR
"@if \"%TEMPFIL%.\" == \".\" goto SETFILE"MEOR
"@goto DNFILE"MEOR
":SETFILE"MEOR
"@set TEMPFIL=temperr.txt"MEOR
":DNFILE"MEOR
"@if \"%TEMPFAIL%.\" == \".\" goto SETFAIL"MEOR
"@goto DNSETFAIL"MEOR
":SETFAIL"MEOR
"@set TEMPFAIL=0"MEOR
":DNSETFAIL"MEOR
MEOR
"@set TEMPERR=0"MEOR
"@set TEMPCNT=0"MEOR
"@set TEMPMEE=0"MEOR
#if ADD_GREP_TEXT
"@echo Start %TIME% >> " DEF_GREP_FILE MEOR
#endif
MEOR;

static char Def_Bat_Tail_OK[] =
"@goto DONE"MEOR
":ERR1"MEOR
"@echo TEMPGREP must be set in the environment ... fix, and run tests.bat?"MEOR
"@echo And it MUST point to the test grep application [%TEMPGREP%] ..."MEOR
"@if NOT EXIST setgrep.bat goto END"MEOR
"call setgrep"MEOR
"@if \"%TEMPGREP%.\" == \".\" goto ERR2"MEOR
"@if NOT EXIST %TEMPGREP% goto ERR2"MEOR
"@echo TEMPGREP now set to %TEMPGREP% ... continuing ..."MEOR
"@goto FNDGREP"MEOR
":ERR2"MEOR
"@goto END"MEOR
MEOR
":DONE"MEOR
"@if \"%TEMPMEE%.\" == \"0.\" goto ALLOK"MEOR
"@echo Spencer: It appears %TEMPMEE% tests failed ..."MEOR
"@goto END"MEOR
":ALLOK"MEOR
"@echo Spencer: It appears ALL tests succeeded ..."MEOR
"@goto END"MEOR
MEOR
":END"MEOR
#if ADD_GREP_TEXT
"@echo End %TIME% >> " DEF_GREP_FILE MEOR
#endif
MEOR;

#endif  /* 0 = old code */

static int done_header = 0;
static int test_num = 0;
static char * tmp_buf = NULL; // build in here
static char * tmp_buf2 = NULL; // build in here
static char * tmp_buf3 = NULL; // build in here
static FILE * out = NULL;
static int bRedirON = 0;
static char * prog_name = NULL;
static int iret = 0;

static char * in_file = NULL;
static char * out_file = NULL;
static int verbosity = Def_Verbosity;
static char * bat_header = Def_Bat_Header;
static char * bat_tail = Def_Bat_Tail;
static char * line_ldr = "@";
static int do_append = 0;
static int do_overwrite = 0;
static int remove_escape = DEF_REMOVE_ESC;
static char * pgrep_text = DEF_GREP_TEXT;
static char * pgrep_opts = DEF_GREP_OPTS;
static char * mode_write = "wb";

#define VERB1  ( verbosity > 0 )
#define VERB2  ( verbosity > 1 )
#define VERB3  ( verbosity > 2 )

void pgm_exit( int val )
{
   if( out )
      fclose(out);

   /* clean up memory allocated */
   if( tmp_buf )
      free(tmp_buf);
   if( tmp_buf2 )
      free( tmp_buf2 );
   if( tmp_buf3 )
      free( tmp_buf3 );
   if( bat_header != Def_Bat_Header )
      free( bat_header );
   if( bat_tail != Def_Bat_Tail )
      free( bat_tail );

   exit(val);
}

void usage( int val )
{
   printf( "%s - Generate a batch file of test, from an input file - Version %s"MEOR,
      prog_name, PROGRAM_VERSION );
   printf( "USAGE: %s [Options] input_file_name [output_file_name]"MEOR, prog_name );
   printf( "Options:"MEOR );
   printf( " -? or -h or --help = This brief help."MEOR );
   printf( " -bh:head.txt       = Provide new batch file header text."MEOR );
   printf( " -bt:tail.txt       = Provide new batch file tail text."MEOR );
   printf( " -e[+|-]            = Escape, '\', removal. +=On, -=Off, Def=%s"MEOR,
       ( remove_escape ? "On" : "Off" ) );
   printf( " -g:grep_opts       = Grep Options. Def=\"%s\""MEOR, pgrep_opts );
   printf( " -o[+|-]:Out_File   = Set the output file name. + to append, - to create or overwite."MEOR );
   printf( " -v[n]              = Set verbosity 0-3. (Def=%d)"MEOR, verbosity );
   printf( "If no output_file given then results to stdout ..."MEOR );
   pgm_exit(val);
}

char * get_title_only( char * fname )
{
   char * pname;
   PSPLITTING psp = (PSPLITTING)malloc(sizeof(SPLITTING));
   CHKMEM(psp);
   _splitpath(fname, psp->drive, psp->dir, psp->fname, psp->ext);
   pname = (char *)malloc( strlen(psp->fname) + 1 );
   strcpy(pname, psp->fname);
   free(psp);
   return pname;
}

int special_char( int c )
{
   // special characters <, >, |, &, ^
   if (( c == '<' )||
       ( c == '>' )||
       ( c == '|' )||
       ( c == '&' )||
       ( c == '^' ))
       return 1;

   return 0;
}


void gen_test( char * in_token, char * tk1, char * in_tk2, char * in_tk3, char * in_tk4 )
{
   char * tb = tmp_buf;    /* for building batch script */
   char * tb2 = tmp_buf2;  /* part 1 for copy of action - max len MX_ONE_CHIP */
   char * tk2 = &tb2[MX_ONE_CHIP];
   char * tk3 = &tk2[MX_ONE_CHIP];
   char * tk4 = &tk3[MX_ONE_CHIP];
   size_t i, len, wtn, off;
   int   c, gotsp;

   /* note: tk1 has been pre-checked to be length 1, and is a single NUMBER only */

   /* in_tk2 is the 'expression' and must be checked for 'special' batch chars
      ======================================================================== */
   len = strlen(in_tk2);
   off = 0;
   gotsp = 0;
   if( strchr(in_tk2, ' ') )
   {
      gotsp = 1;
      tk2[off++] = '"';
   }

   for( i = 0; i < len; i++ )
   {
      c = in_tk2[i];

      if( remove_escape && ( c == '\\' ) )
          continue;

      if( !gotsp && special_char(c) )
         tk2[off++] = '^';

      tk2[off++] = (char)c;
   }

   if( gotsp )
      tk2[off++] = '"';
   tk2[off] = 0;
   /* done in_tk2, the 'regular expression' ================================= */

   /* in_tk3 is the 'echoed' to a pipe, and must be checked for 'special' batch chars */
   len = strlen(in_tk3);
   off = 0;
   gotsp = 0;
   if( strchr(in_tk3, ' ' ) )
   {
      gotsp = 1;
      tk3[off++] = '"';
   }
   for( i = 0; i < len; i++ )
   {
      c = in_tk3[i];
      if( !gotsp && special_char(c) )
         tk3[off++] = '^';
      tk3[off++] = (char)c;
   }
   if( gotsp )
      tk3[off++] = '"';
   tk3[off] = 0;

   /* in_tk4 is only sometimes present, and is only checked for 'space' chars */
   strcpy(tk4,in_tk4);
   if( strchr( in_tk4, ' ' ) )
   {
      strcpy(tk4,"\"");
      strcat(tk4,in_tk4);
      strcat(tk4,"\"");
   }

   /* DRAT - Some EXCEPTIONS, which require SPECIAL treatment!!! */
   /* echo problem */
   if(( strlen(in_tk3) == 1 )&&
      ( in_tk3[0] == '|' ))
   {
      /* trouble echoing a pipe character,
         EVEN when 'escaped', like ^| !@#@$#% */
      strcpy(tk3, "\"|\"");   /* was test 53 in specer2.tests */
   }

   /* has the batch file HEADER been output? */
   if(!done_header )
   {
      done_header = 1;
      if( bat_header )
      {
         len = strlen(bat_header);
         if(VERB2)
            fwrite( bat_header, 1, len, stdout );
         if(out)
         {
            wtn = fwrite( bat_header, 1, len, out );
            if( wtn != len )
            {
               fprintf(stderr, "ERROR: FAILED to WRITE to %s ... aborting\n",
                  ( out_file ? out_file : "stdout" ) );
               pgm_exit(2);
            }
         }
      }
   }

   /* PREPARE THE BATCH FILE SCRIPT FOR THIS TEST
      =========================================== */
   test_num++; /* bump the test number */

   /* prepare the general test information */
   len = sprintf( tb,
      "\"echo %s to grep %s %s %s\"",
      tk3, pgrep_opts, tk2, tk4 );
   if( len >= MX_ONE_CHIP ) {
      fprintf(stderr, "ERROR: INSUFFICIENT BUFFER SPACE ... aborting\n"
         "RE-COMPILE AFTER INCREASING MX_CHIP_BUFF to more than %d!\n",
         MX_ONE_CHIP );
      pgm_exit(2);
   }
   /* transfer it to its buffer, adding to any inner '"' chars */
   off = 0;
   for( i = 0; i < len; i++ )
   {
      c = tb[i];
      if( c == '"' ) {
         if( i && ((i + 1) < len)) {   /* do NOT mess with FIRST or LAST '"' */
            tb2[off++] = '"';
         }
      }
      tb2[off++] = (char)c;
   }
   tb2[off] = 0;

   /* write the batch script */
   sprintf( tb, "@REM Test %d, from file token \"", test_num );
   strcat( tb, in_token );
   strcat( tb, "\" ..."MEOR );
#if ADD_GREP_TEXT
   strcat( tb, "@echo. >> " DEF_GREP_FILE MEOR );
   sprintf( EndBuf(tb), "@echo Test %d, from file token \"", test_num );
   strcat( tb, in_token );
   sprintf( EndBuf(tb), "\" >> %s"MEOR, DEF_GREP_FILE );
#endif /* ADD_GREP_TEXT */
   sprintf( EndBuf(tb), "@set /a TEMPCNT+=1"MEOR );
   /* most important line */
   sprintf( EndBuf(tb),
      "%secho %s|%%TEMPGREP%% %s %s %s %s 2>&1"MEOR,
      line_ldr, tk3, pgrep_opts, tk2, tk4, pgrep_text );
   sprintf( EndBuf(tb), "%sset TEMPERR=%%ERRORLEVEL%%"MEOR, line_ldr );
   sprintf( EndBuf(tb), "%sif %%TEMPERR%% EQU %s goto TEST%dOK"MEOR, line_ldr, tk1, test_num );
   sprintf( EndBuf(tb), "%sgoto TEST%dFAILED"MEOR, line_ldr, test_num );

   /* what to do, show if SUCCESS */
   strcat( tb, MEOR );
   sprintf( EndBuf(tb), ":TEST%dOK"MEOR, test_num );
   sprintf( EndBuf(tb), "%s%%TEMPECH%% Test %d SUCCESS %s"MEOR, line_ldr, test_num, tb2 );
#if ADD_GREP_TEXT
   sprintf( EndBuf(tb), "@echo Test %d SUCCESS %s >> %s "MEOR, test_num, tb2, DEF_GREP_FILE );
#endif /* ADD_GREP_TEXT */
   sprintf( EndBuf(tb), "%sgoto TEST%dDONE"MEOR, line_ldr, test_num );

   /* what to do, show if FAILED */
   strcat( tb, MEOR );
   sprintf( EndBuf(tb), ":TEST%dFAILED"MEOR, test_num );
   strcat( tb, "@set /a TEMPMEE+=1"MEOR );  /* bump the LOCAL error counter */
   strcat( tb, "@set /a TEMPFAIL+=1"MEOR ); /* bump the GLOBAL error counter */
   sprintf( EndBuf(tb), "%secho FAILED TEST %d, expected %s, got %%TEMPERR%%! %s"MEOR, line_ldr, test_num, tk1, tb2 );
   sprintf( EndBuf(tb), "%secho FAILED TEST %d, expected %s, got %%TEMPERR%%! %s >> %%TEMPFIL%%"MEOR,
      line_ldr, test_num, tk1, tb2 );
#if ADD_GREP_TEXT
   sprintf( EndBuf(tb), "@echo FAILED TEST %d, expected %s, got %%TEMPERR%%! \"%s\" >> %s"MEOR,
      test_num, tk1, tb2, DEF_GREP_FILE );
#endif /* ADD_GREP_TEXT */

   sprintf( EndBuf(tb), ":TEST%dDONE"MEOR, test_num );
   sprintf( EndBuf(tb), MEOR );

   /* since script will contain '%' characters, then can NOT
      use printf(tb), nor fprintf( stdout, tb ), so */
   len = strlen(tb);
   if( len > MX_BAT_BUFF - 8 ) {
      fprintf(stderr, "ERROR: INSUFFICIENT BUFFER SPACE ... aborting\n"
         "RE-COMPILE AFTER INCREASING MX_BAT_BUFF to more than %d!\n",
         MX_BAT_BUFF );
      pgm_exit(2);
   }

   if( VERB2 )
      fwrite( tb, 1, len, stdout );

   if(out) {
      wtn = fwrite( tb, 1, len, out );
      if( wtn != len ) {
         fprintf(stderr, "ERROR: FAILED to WRITE to %s ... aborting\n",
            ( out_file ? out_file : "stdout" ) );
         pgm_exit(2);
      }
   }
}

/* got a token line from the file - break it into pieces */
void process_token( char * in_token )
{
   size_t len = strlen(in_token);
   char * cp, * tk1, * tk2, * tk3, * tk4;
   char * token = in_token;
   char * tb = tmp_buf3;

   strcpy(tb,in_token); /* get FULL COPY before it is chopped */
   cp = strchr(token, '@');
   if ( cp )
   {
      tk1 = token;
      *cp = 0;
      cp++;
      token = cp;
      cp = strchr(token, '@');
      if ( cp )
      {
         tk2 = token;
         *cp = 0;
         cp++;
         token = cp;
         tk3 = token;
         cp = strchr(token, '@');
         tk4 = "\0";
         if ( cp )
         {
            // have seen some lines with an extra token
            *cp = 0;
            cp++;
            tk4 = cp;
         }
         // but we have at least 3 tokens
         // check only first is a NUMBER, of length 1
         if (( strlen(tk1) == 1 ) && ISNUM(tk1[0]) )
         {
            /* we appear to have all that is needed
               to generate batch file output */
            gen_test( tb, tk1, tk2, tk3, tk4 );
         } else {
            /* ignore line error, but mark it */
            iret = 1;
         }
      }
   } else {
      /* ignore if NO '@' in token */
      iret = 1;
   }
}


int process_file( char * in_file )
{
   int iret = 0;
   FILE * fp;
   struct stat sb;
   char * buf = 0;
   char * token;
   size_t sz, i;

   sb.st_size = 0;

   if( VERB1 )
      printf( "Processing file [%s] ...\n", in_file );

   if( stat( in_file, &sb ) )
   {
      char * tb = tmp_buf;
      fprintf( stderr, _strerror(NULL) );
      fprintf( stderr, "ERROR: Unable to stat [%s] file! ... aborting ...\n", in_file );
      if( tb ) {
         *tb = 0;
         _getcwd( tb, 256 );
         if( *tb )
            fprintf( stderr, "Current work directory: %s"MEOR, tb );

      }
      pgm_exit(2);
   }
   if ( sb.st_size == 0 )
   {
      fprintf(stderr, "ERROR: stat indicates [%s] file is EMPTY! ... aborting ...\n", in_file );
      pgm_exit(2);
   }
   fp = fopen(in_file, "rb");
   if( fp == NULL )
   {
      fprintf( stderr, _strerror(NULL) );
#ifdef _MSC_VER
      /* try to give MORE information why file NOT found
         by giving the current work directory, which may help */
      buf = (char *)malloc(264);
      if(buf)
      {
         buf[0] = 0;
         _getcwd( buf, 256 );
         if( buf[0] )
            fprintf( stderr, "Current work directory is [%s] ...\n", buf );
         free(buf);
         buf = NULL;
      }
#endif // #ifdef _MSC_VER

      fprintf(stderr, "ERROR: Unable to open [%s] file ... aborting ...\n", in_file );
      pgm_exit(2);
   }
   /* get buffer to read in file, completely, plus 1 */
   buf = malloc( sb.st_size + 1 );  /* file size plus a null */
   CHKMEM(buf);
   sz = fread( buf, 1, sb.st_size, fp );
   fclose(fp);
   if ( sz != (size_t)sb.st_size ) /* compare size_t with long */
   {
      fprintf(stderr, "ERROR: Read of [%s] file FAILED ... aborting ...\n", in_file );
      pgm_exit(2);
   }

   for( i = 0; i < sz; i++ ) {
      int c = buf[i];
      if ( c > ' ' )  {
         int c1 = c; /* keep this first */
         token = &buf[i];
         i++; /* bump, and goto end of line or file */
         for( ; i < sz; i++ ) {
            int c = buf[i];
            if (( c < ' ' )&&( c != '\t')) {
               break;
            }
         }
         buf[i] = 0;    /* zero terminate the token */
         if( c1 != '#' )    /* skip comments !!! none found to date */
             process_token( token );
      }
   }

   free(buf);   /* toss the file data buffer */
   if( out && test_num && done_header )
   {
      if( bat_tail ) {
         sz = strlen(bat_tail);
         if( VERB2 )
            fwrite( bat_tail, 1, sz, stdout );

         i = fwrite( bat_tail, 1, sz, out );
         if( i != sz ) {
            fprintf(stderr, "ERROR: FAILED to WRITE to %s ... aborting\n",
               ( out_file ? out_file : "stdout" ) );
            pgm_exit(2);
         }
      }
   }
   return iret;
}

void ask_user( void )
{
   int chr;
   if( do_append || do_overwrite ) {
      printf( "YES %s\n",
         ( do_append ? "Append (-o+)" : "Overwrite (-o-)" ) );
   } else { /* if( !do_append && !do_overwrite ) */
      chr = toupper(_getch());
      fflush(stdin);
      if( chr != 'Y' ) {
         printf( "NO! ... aborting\n" );
         pgm_exit(2);
      }
      printf( "YES\n" );
   }
}

void check_redirection( void )
{
#ifdef _MSC_VER
   HANDLE hStdOut = GetStdHandle( STD_OUTPUT_HANDLE );
   HANDLE hErrOut = GetStdHandle( STD_ERROR_HANDLE  );   // error out
   if( VH(hStdOut) )
   {
      DWORD dwm;
      if( !GetConsoleMode( hStdOut, &dwm ) )
         bRedirON = 1;
	}
#else  /* !_MSC_VER */
   /* do not yet know how to do this in unix */

#endif /* _MSC_VER */
}

static char * strip_quotes_and_dupe( char * cp )
{
   char * tb = tmp_buf;
   char * pret = NULL;
   size_t len;
   CHKMEM(tb);
   strcpy(tb, cp);
   if( *tb == '"' ) {
      strcpy(tb, &cp[1] );
      len = strlen(tb);
      if(len) {
         len--;
         if( tb[len] == '"' )
            tb[len] = 0;
      }
   }
   pret = _strdup(tb);
   CHKMEM(pret);
   return pret;
}

/* printf( " -g:grep_opts       = Grep Options. Def=\"%s\""MEOR, pgrep_opts ); */
int Get_G_Opt( char * arg, char * nxt )
{
   char * argp = arg;
   argp++;  /* past '-' or '/' */
   argp++;  /* past 'o' */
   if( *argp ) {
      int c = *argp;
      if( c == ':' ) {
         argp++;
         pgrep_opts = strip_quotes_and_dupe(argp);
      } else
         goto Got_G_Err;

   } else {
      if( nxt && *nxt ) {
         pgrep_opts = strip_quotes_and_dupe(nxt);
         return 1;
      } else {
Got_G_Err:
         fprintf(stderr, "ERROR: command error [%s]! (%s) Use -? for help ...\n",
            arg,
            (nxt ? nxt : "") );
         pgm_exit(2);
      }
   }
   return 0;
}

/* -
   printf( " -o[+|-]:Out_File   = Set the output file name.
   + to append, - to create or overwite."MEOR );
*/
int Get_O_Opt( char * arg, char * nxt )
{
   char * argp = arg;
   argp++;  /* past '-' or '/' */
   argp++;  /* past 'o' */
   if( *argp ) {
      int c = *argp;
      if( c == '+' ) {
         do_append = 1;
         argp++;
      } else if( c == '-' ) {
         do_overwrite = 1;
         argp++;
      }
      c = *argp;
      if( c == ':' )
         argp++;
      if( *argp ) {
         out_file = argp;
      } else {
         goto Try_Next;
      }
   } else {
      /* can only assume NEXT arg is out file name */
Try_Next:
      if( nxt && *nxt ) {
         out_file = nxt;
         return 1;
      } else {
         fprintf(stderr, "ERROR: Unknown command [%s]! Use -? for help ..."MEOR, arg );
         pgm_exit(2);
      }
   }
   return 0;
}

typedef int (*SETOPT)( char * );

int Set_B_Opt( char * file, char * * pdat )
{
   struct stat sb;
   FILE * fp;
   if ( stat( file, &sb ) == 0 ) {
      char * buf = (char *)malloc( sb.st_size + 1 );
      CHKMEM(buf);
      fp = fopen( file, "rb" );
      if(fp) {
         size_t sz = fread( buf, 1, sb.st_size, fp );
         fclose(fp);
         if( sz != (size_t)sb.st_size ) { /* compare size_t with long */
            free(buf);
            return 1;
         }
         buf[sz] = 0;
         *pdat = buf;   /* new header or tail */
      } else {
         free(buf);
         return 1;
      }
   } else {
      return 1;
   }
   return 0;
}
int Set_BH_Opt( char * file )
{
   return Set_B_Opt( file, &bat_header );
}
int Set_BT_Opt( char * file )
{
   return Set_B_Opt( file, &bat_tail );
}

/* ===========================================================
   printf( " -bh:head.txt       = Provide new batch file header text.\n" );
   printf( " -bt:tail.txt       = Provide new batch file tail text.\n" );
   =========================================================== */
int Get_B_Opt( char * arg, char * nxt )
{
   SETOPT so;
   int   ret = 0;
   char * argp = arg;
   int c;
   argp++;  /* past '-' or '/' */
   argp++;  /* past 'b' */
   c = toupper(*argp);
   if( c ) {
      argp++;
      c = toupper(*argp);
      if( c == 'H' ) {
         so = Set_BH_Opt;
      } else if( c == 'T' ) {
         so = Set_BT_Opt;
      } else {
         goto Got_B_Err;
      }
      argp++;
      if( *argp ) {
         if(*argp == ':') {
            argp++;
            if( *argp ) {
               if( so( argp ) )
                  goto Got_B_Err;
            } else {
               goto Got_B_Err;
            }
         } else {
            goto Got_B_Err;
         }
      } else {
         if( nxt && *nxt ) {
            if( so( nxt ) )
               goto Got_B_Err;
            ret = 1;
         } else {
            goto Got_B_Err;
         }
      }
   }
   return ret;
Got_B_Err:
   fprintf(stderr, "ERROR: Unknown command [%s]! Use -? for help ...\n", arg );
   pgm_exit(2);
   return 1;
}

int main( int argc, char **argv )
{
   int   c, i, cnt;
   char * argp;

   prog_name = get_title_only( argv[0] );

   check_redirection();

   /* get a temporary buffers */
   tmp_buf = (char *)malloc(MX_BAT_BUFF);
   CHKMEM(tmp_buf);

   /* Just check only for verbosity */
   for( i = 1; i < argc; i++ ) {
      argp = argv[i];
      if ( argp )
      {
         c = *argp;
         if (( c == '-' )||( c == '/' ))
         {
            if ( toupper(argp[1]) == 'V' )
            {
               verbosity = 1;
               if ( ISNUM( argp[2] ) )
                  verbosity = atoi(&argp[2]);
            }
         }
      }
   }

   if( VERB1 )
      printf("Running %s ...\n", prog_name);

   cnt = 0;
   for( i = 1; i < argc; i++ )
   {
      argp = argv[i];
      if ( argp )
      {
         c = *argp;
         if (( c == '-' )||( c == '/' ))
         {
            c = toupper(argp[1]);
            switch(c)
            {
            case '?':
            case 'H':
               usage(0);
               break;
            case 'B':
               if( Get_B_Opt( argp, argv[i+1] ) )
                  i++;
               break;
            case 'E':
                remove_escape = 1;
                c = argp[2];
                if( c ) {
                    if( c == '+' )
                        remove_escape = 1;
                    else if( c == '-' )
                        remove_escape = 0;
                    else
                        goto Err_Command;

                }
                break;
            case 'G':
                c = argp[2];
               if( Get_G_Opt( argp, argv[i+1] ) )
                  i++;
               break;

            case 'O':
               if( Get_O_Opt( argp, argv[i+1] ) )
                  i++;
               break;
            case 'V':
               verbosity = 1;
               c = argp[2];
               if (c) {
                   if ( ISNUM(c) )
                       verbosity = atoi(&argp[2]);
                   else
                       goto Err_Command;
               }
               break;

            default:
               goto Err_Command;
               break;
            }
         }
         else
         {
            if( cnt == 0 )
            {
               cnt++;
               in_file = argp;
            }
            else if ( cnt == 1 )
            {
               cnt++;
               out_file = argp;
            }
            else
            {
Err_Command:
               fprintf(stderr, "ERROR: Unknown command [%s]! Use -? for help ...\n", argv[i] );
               pgm_exit(2);
            }
         }
      }
   }
#ifndef NDEBUG
   /* ONLY FOR QUICK DEBUG TESTING */
   if( in_file == 0 )
   {
      in_file = DEF_IN_FILE;
   }
   if( out_file == 0 )
   {
      out_file = DEF_OUT_FILE;
      do_overwrite = 1;
   }
#endif /* #ifndef NDEBUG */

   if( in_file == 0 )
   {
      fprintf( stderr, "ERROR: Must give input file ...\n" );
      usage(2);
   }
   if ( out_file )
   {
      struct stat sb;
      if ( stat( out_file, &sb ) == 0 )
      {
         if( !bRedirON && !do_append && !do_overwrite )
         {
            printf( "Warning: Output file %s ALREADY EXISTS!\n", out_file );
            printf( "*** OVERWRITE THIS FILE? *** y/n : " );
            ask_user();
         } else if ( !bRedirON ) {
            if( VERB3 ) {
               printf( "Warning: Output file %s ALREADY EXISTS!\n", out_file );
               printf( "*** OVERWRITE THIS FILE? *** y/n : " );
               ask_user();
            }
         }
      }
      if( do_append )
         mode_write = "ab";
      out = fopen( out_file, mode_write );
      if ( out == NULL )
      {
         fprintf( stderr, "ERROR: Unable to create OUT file %s! aborting ...\n", out_file );
         pgm_exit(2);
      }
   }

   /* get some more temporary buffers */
   tmp_buf2 = (char *)malloc(MX_LINE_BUFF);
   CHKMEM(tmp_buf2);
   tmp_buf3 = (char *)malloc(MX_TOKEN_BUFF);
   CHKMEM(tmp_buf3);

   iret = process_file( in_file );

   pgm_exit( iret );

   return iret;
}

// eof -gentests.c
