@REM #! /bin/sh
@REM # test that the empty file means no pattern
@REM # and an empty pattern means match all.
@REM : ${srcdir=.}
@REM failures=0
@if "%TEMPGREP%." == "." goto ERR1
@if NOT EXIST %TEMPGREP% goto ERR1
:DNGREP
@if "%TEMPECH%." == "." goto SETREM
@goto DNSET
:SETREM
@REM set TEMPECH=echo
@set TEMPECH=REM
:DNSET
@if "%TEMPFIL%." == "." goto SETFILE
@goto DNFILE
:SETFILE
@set TEMPFIL=temperr.txt
:DNFILE
@if "%TEMPFAIL%." == "." goto SETFAIL
@goto DNSETFAIL
:SETFAIL
@set TEMPFAIL=0
:DNSETFAIL
@set TEMPERR=0

@set TEMPO=-E
@REM ==========================================================
:TEST1
@REM echo #1 should return 0 found a match
@echo "" | %TEMPGREP% %TEMPO% -e "" > nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST1F
@%TEMPECH% Empty: Success #1 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST2

:TEST1F
@echo Empty: Wrong status code, test #1 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0
@echo Empty: Wrong status code, test #1 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST2

@REM ==========================================================
:TEST2
@REM echo #2 should return 1 found no match
@echo "abcd" | %TEMPGREP% %TEMPO% -f nul  >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto SUCC2
@echo Status: Wrong status code, test #2 failed (%TEMPO%) - Exit code %TEMPERR%, expected 1
@echo Status: Wrong status code, test #2 failed (%TEMPO%) - Exit code %TEMPERR%, expected 1 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST3

:SUCC2
@%TEMPECH% Empty: Success #2 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST3

@REM ==========================================================
:TEST3
@REM echo #3 should return 0 found a match
@echo "abcd" | %TEMPGREP% %TEMPO% -f nul -e "abcd" >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST3F
@%TEMPECH% Empty: Success #3 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST4

:TEST3F
@echo Empty: Wrong status code, test #3 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0
@echo Empty: Wrong status code, test #3 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST4

:TEST4

@set TEMPO=-E -w
@REM ==========================================================
@REM echo #4 should return 0 found a match
@echo "" | %TEMPGREP% %TEMPO% -e "" > nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST4F
@%TEMPECH% Empty: Success #4 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST5

:TEST4F
@echo Empty: Wrong status code, test #4 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0
@echo Empty: Wrong status code, test #4 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST5

@REM ==========================================================
:TEST5
@REM echo #5 should return 1 found no match
@echo "abcd" | %TEMPGREP% %TEMPO% -f nul  >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST5S
@echo Status: Wrong status code, test #5 failed (%TEMPO%) - Exit code %TEMPERR%, expected 1
@echo Status: Wrong status code, test #5 failed (%TEMPO%) - Exit code %TEMPERR%, expected 1 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST6

:TEST5S
@%TEMPECH% Empty: Success #5 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST6

@REM ==========================================================
:TEST6
@REM echo #6 should return 0 found a match
@echo "abcd" | %TEMPGREP% %TEMPO% -f nul -e "abcd" >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST6F
@%TEMPECH% Empty: Success #6 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST7

:TEST6F
@echo Empty: Wrong status code, test #6 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0
@echo Empty: Wrong status code, test #6 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST7

:TEST7
@set TEMPO=-F -x
@REM ==========================================================
@REM echo #7 should return 0 found a match
@echo "" | %TEMPGREP% %TEMPO% -e "" > nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST7F
@%TEMPECH% Empty: Success #7 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST8

:TEST7F
@echo Empty: Wrong status code, test #7 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0
@echo Empty: Wrong status code, test #7 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST8

@REM ==========================================================
:TEST8
@REM echo #8 should return 1 found no match
@echo "abcd" | %TEMPGREP% %TEMPO% -f nul  >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST8S
@echo Status: Wrong status code, test #8 failed (%TEMPO%) - Exit code %TEMPERR%, expected 1
@echo Status: Wrong status code, test #8 failed (%TEMPO%) - Exit code %TEMPERR%, expected 1 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST9

:TEST8S
@%TEMPECH% Empty: Success #8 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST9

@REM ==========================================================
:TEST9
@REM echo #9 should return 0 found a match
@echo "abcd" | %TEMPGREP% %TEMPO% -f nul -e "abcd" >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST9F
@%TEMPECH% Empty: Success #9 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST10

:TEST9F
@echo Empty: Wrong status code, test #9 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0
@echo Empty: Wrong status code, test #9 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST10

:TEST10
@set TEMPO=-G -w -x
@REM ==========================================================
@REM echo #10 should return 0 found a match
@echo "" | %TEMPGREP% %TEMPO% -e "" > nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST10F
@%TEMPECH% Empty: Success #10 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST11

:TEST10F
@echo Empty: Wrong status code, test #10 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0
@echo Empty: Wrong status code, test #10 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST11

@REM ==========================================================
:TEST11
@REM echo #11 should return 1 found no match
@echo "abcd" | %TEMPGREP% %TEMPO% -f nul  >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST11S
@echo Status: Wrong status code, test #11 failed (%TEMPO%) - Exit code %TEMPERR%, expected 1
@echo Status: Wrong status code, test #11 failed (%TEMPO%) - Exit code %TEMPERR%, expected 1 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST12

:TEST11S
@%TEMPECH% Empty: Success #11 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST12

@REM ==========================================================
:TEST12
@REM echo #12 should return 0 found a match
@echo "abcd" | %TEMPGREP% %TEMPO% -f nul -e "abcd" >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST12F
@%TEMPECH% Empty: Success #12 (Option %TEMPO%) - Exit code %TEMPERR%
@goto TEST13

:TEST12F
@echo Empty: Wrong status code, test #12 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0
@echo Empty: Wrong status code, test #12 failed (%TEMPO%) - Exit code %TEMPERR%, expected 0 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@goto TEST13

:TEST13

@goto END

:ERR1
@echo TEMPGREP must be set in the environment ... use tests.bat ...
@echo And it MUST point to the test grep application [%TEMPGREP%] ...
@if NOT EXIST setgrep.bat goto ERR2
call setgrep
@if "%TEMPGREP%." == "." goto ERR2
@if NOT EXIST %TEMPGREP% goto ERR2
@goto DNGREP
:ERR2
@goto END

:END
