@REM #! /bin/sh
@REM # Test for status code for GNU grep.
@REM # status code
@REM #  0 match found
@REM #  1 no match
@REM #  2 file not found
@REM : ${srcdir=.}

@if "%TEMPGREP%." == "." goto ERR1
@if NOT EXIST %TEMPGREP% goto ERR1
:DNGREP
@if "%TEMPECH%." == "." goto SETREM
@goto DNSET
:SETREM
@REM set TEMPECH=echo
@set TEMPECH=REM
:DNSET
@if "%TEMPFIL%." == "." goto SETFILE
@goto DNFILE
:SETFILE
@set TEMPFIL=temperr.txt
:DNFILE
@if "%TEMPFAIL%." == "." goto SETFAIL
@goto DNSETFAIL
:SETFAIL
@set TEMPFAIL=0
:DNSETFAIL

@set TEMPERR=0
@set TEMPMEE=0

:TEST1
@REM # should return 0 found a match
@echo "abcd"| %TEMPGREP% -E -e "abc" > nul 2>&1
@REM echo "abcd" | %TEMPGREP% -E -e "abc"
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto FAILED1
@%TEMPECH% Status: Success 1 ... Exit code %TEMPERR% ...
@goto TEST2

:FAILED1
@echo Status: Wrong status code, test #1 failed - Exit code %TEMPERR%
@echo Status: Wrong status code, test #1 failed - Exit code %TEMPERR% >> %TEMPFIL%
@set /a TEMPFAIL+=1
@set /a TEMPMEE+=1
@goto TEST2

:TEST2
@rem # should return 1 found no match
@echo "abcd"| %TEMPGREP% -E -e "zbc" >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto SUCC2
@goto FAILED2

:SUCC2
@if ERRORLEVEL 2 goto FAILED2
@%TEMPECH% Status: Success 2 ... Exit code %TEMPERR% ...
@goto TEST3

:FAILED2
@echo Status: Wrong status code, test #2 failed - Exit code %TEMPERR%, expected 1
@echo Status: Wrong status code, test #2 failed - Exit code %TEMPERR%, expected 1 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@set /a TEMPMEE+=1
@goto TEST3

:TEST3
@REM # the filename MMMMMMMM.MMM should not exist hopefully
@set TEMPF=MMMMMMMM.MMM
@if EXIST %TEMPF% goto REMT3
@REM # should return 2 file not found
@%TEMPGREP% -E -e "abc" %TEMPF% >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 2 goto SUCC3
@echo Status: Wrong status code, test #3 failed - Exit code %TEMPERR%, expected 2
@echo Status: Wrong status code, test #3 failed - Exit code %TEMPERR%, expected 2 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@set /a TEMPMEE+=1
@goto TEST4

:SUCC3
@%TEMPECH% Status: Success 3 ... Exit code %TEMPERR% ...
@goto TEST4


:TEST4
@REM # should return 2 file not found
@%TEMPGREP% -E -s -e "abc" %TEMPF% >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 2 goto SUCC3
@echo"Status: Wrong status code, test #4 failed - Exit code %TEMPERR%
@echo"Status: Wrong status code, test #4 failed - Exit code %TEMPERR% >> %TEMPFIL%
@set /a TEMPFAIL+=1
@set /a TEMPMEE+=1
@goto TEST5

:SUCC3
@%TEMPECH% Status: Success 4 ... Exit code %TEMPERR% ...
@goto TEST5

:TEST5
@REM # should return 2 file not found
@echo "abcd" | %TEMPGREP% -E -s "abc" - %TEMPF% >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 2 goto SUCC5
@echo Status: Wrong status code, test #5 failed - Exit code %TEMPERR%, expected 2
@echo Status: Wrong status code, test #5 failed - Exit code %TEMPERR%, expected 2 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@set /a TEMPMEE+=1
@goto TEST6

:SUCC5
@%TEMPECH% Status: Success 5 ... Exit code %TEMPERR% ...
@goto TEST6


:TEST6
@REM # should return 0 found a match
@echo "abcd" | %TEMPGREP% -E -q -s "abc" %TEMPF% - >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto FAILED6
@%TEMPECH% Status: Success 6 ... Exit code %TEMPERR% ...
@goto TEST7

:FAILED6
@echo Status: Wrong status code, test #6 failed - Exit code %TEMPERR%, expected 0
@echo Status: Wrong status code, test #6 failed - Exit code %TEMPERR%, expected 0 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@set /a TEMPMEE+=1
@goto TEST7

:TEST7
@REM # should still return 0 found a match
@echo "abcd" | %TEMPGREP% -E -q "abc" %TEMPF% - >nul 2>&1
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto FAILED7
@%TEMPECH% Status: Success 7 ... Exit code %TEMPERR% ...
@goto TEST8

:FAILED7
@echo Status: Wrong status code, test #7 failed - Exit code %TEMPERR%, expected 0
@echo Status: Wrong status code, test #7 failed - Exit code %TEMPERR%, expected 0 >> %TEMPFIL%
@set /a TEMPFAIL+=1
@set /a TEMPMEE+=1
@goto TEST8

:TEST8
@REM add any more here ...
@if "%TEMPMEE%." == "0." goto ALLOK
@echo Status: It appears %TEMPMEE% tests failed ...
@goto END
:ALLOK
@echo Status: It appears ALL tests succeeded ...
@goto END


:REMT3
@echo Please remove %TEMPF% file to run check ...
@goto END


:ERR1
@echo TEMPGREP must be set in the environment ... fix, and run tests.bat
@echo And it MUST point to the test grep application [%TEMPGREP%] ...
@if NOT EXIST setgrep.bat goto ERR2
call setgrep
@if "%TEMPGREP%." == "." goto ERR2
@if NOT EXIST %TEMPGREP% goto ERR2
@goto DNGREP
:ERR2
@echo And can NOT find the setgrep.bat file to set it ...
@goto END

:END
