// winport.h
#ifndef _winport_h_
#define _winport_h_
#include <sys/types.h>
#include <sys/stat.h>

/*
 * [XSI] The following are symbolic names for the values of type mode_t.  They
 * are bitmap values.
 */
#ifndef S_IFMT
/* File type */
#define	S_IFMT		0170000		/* [XSI] type of file mask */
#define	S_IFIFO		0010000		/* [XSI] named pipe (fifo) */
#define	S_IFCHR		0020000		/* [XSI] character special */
#define	S_IFDIR		0040000		/* [XSI] directory */
#define	S_IFBLK		0060000		/* [XSI] block special */
#define	S_IFREG		0100000		/* [XSI] regular */
#define	S_IFLNK		0120000		/* [XSI] symbolic link */
#define	S_IFSOCK	0140000		/* [XSI] socket */
#ifndef _POSIX_C_SOURCE
#define	S_IFWHT		0160000		/* whiteout */
#define S_IFXATTR	0200000		/* extended attribute */
#endif

/* File mode */
/* Read, write, execute/search by owner */
#define	S_IRWXU		0000700		/* [XSI] RWX mask for owner */
#define	S_IRUSR		0000400		/* [XSI] R for owner */
#define	S_IWUSR		0000200		/* [XSI] W for owner */
#define	S_IXUSR		0000100		/* [XSI] X for owner */
/* Read, write, execute/search by group */
#define	S_IRWXG		0000070		/* [XSI] RWX mask for group */
#define	S_IRGRP		0000040		/* [XSI] R for group */
#define	S_IWGRP		0000020		/* [XSI] W for group */
#define	S_IXGRP		0000010		/* [XSI] X for group */
/* Read, write, execute/search by others */
#define	S_IRWXO		0000007		/* [XSI] RWX mask for other */
#define	S_IROTH		0000004		/* [XSI] R for other */
#define	S_IWOTH		0000002		/* [XSI] W for other */
#define	S_IXOTH		0000001		/* [XSI] X for other */

#define	S_ISUID		0004000		/* [XSI] set user id on execution */
#define	S_ISGID		0002000		/* [XSI] set group id on execution */
#define	S_ISVTX		0001000		/* [XSI] directory restrcted delete */

#ifndef _POSIX_C_SOURCE
#define	S_ISTXT		S_ISVTX		/* sticky bit: not supported */
#define	S_IREAD		S_IRUSR		/* backward compatability */
#define	S_IWRITE	S_IWUSR		/* backward compatability */
#define	S_IEXEC		S_IXUSR		/* backward compatability */
#endif
#endif	/* !S_IFMT */

/*
 * [XSI] The following macros shall be provided to test whether a file is
 * of the specified type.  The value m supplied to the macros is the value
 * of st_mode from a stat structure.  The macro shall evaluate to a non-zero
 * value if the test is true; 0 if the test is false.
 */
#define	S_ISBLK(m)	(((m) & 0170000) == 0060000)	/* block special */
#define	S_ISCHR(m)	(((m) & 0170000) == 0020000)	/* char special */
#define	S_ISDIR(m)	(((m) & 0170000) == 0040000)	/* directory */
#define	S_ISFIFO(m)	(((m) & 0170000) == 0010000)	/* fifo or socket */
#define	S_ISREG(m)	(((m) & 0170000) == 0100000)	/* regular file */
#define	S_ISLNK(m)	(((m) & 0170000) == 0120000)	/* symbolic link */
#define	S_ISSOCK(m)	(((m) & 0170000) == 0140000)	/* socket */
#ifndef _POSIX_C_SOURCE
#define	S_ISWHT(m)	(((m) & 0170000) == 0160000)	/* whiteout */
#define S_ISXATTR(m)	(((m) & 0200000) == 0200000)	/* extended attribute */
#endif

/*
 * File types
 */
#define	DT_UNKNOWN	 0
#define	DT_FIFO		 1
#define	DT_CHR		 2
#define	DT_DIR		 4
#define	DT_BLK		 6
#define	DT_REG		 8
#define	DT_LNK		10
#define	DT_SOCK		12
#define	DT_WHT		14

typedef struct tagdirent{
	char d_name[264];
	int  d_namlen;
	int  d_type;
}dirent, * PDE;

typedef struct tagDIR {
   void * sWin;
	char search[264];
	dirent de;
	int	is_first;
} DIR, * PDIR;


extern PDIR opendir(const char * dir );
extern PDE readdir(PDIR dp);
extern int closedir(PDIR dp);
/* extern int grep_stat( char * file, void * buf ); */
extern int has_wild( char * file );
// some closing stats
extern size_t  grep_filesfound, grep_filessearched, grep_dirsfound, grep_dirssearched;
extern size_t  grep_finds;
extern void show_results( void );
#ifdef EXTRA_DEBUG2
extern void show_buffer( char * buf, size_t buflen, char * pname );
#endif /* EXTRA_DEBUG2 */
extern void FileTimeToUnixTime( void * pft, time_t * pt);

extern char * get_title_only( char * fname );   /* get short title */
extern void initialize_win32( int * argcp, char *** argvp,
                             int * esp, int * statp); /* do any WIN32 init */
extern void set_exit_status( int ret );

#endif // _winport_h_
// eof - winport.h
