#!/bin/sh
# created geoff mclane Fri Jun 19 19:36:11 CEST 2009 report@geoffair.info
BN=`basename $0`

# personal SETUP
PREFIX="--prefix=$HOME"
OPTIONS="--with-plib=$HOME/fg6/install/plib"

################################################################
### action it ...
set -e
if [ -f "autogen.sh" ]; then
   if [ ! -x autogen.sh ]; then
      chmod +x autogen.sh
   fi
   if [ -f configure ]; then
      rm -f configure
   fi
   echo "$BN: running autogen.sh..."
   ./autogen.sh
   echo "$BN: done autogen.sh..."
   if [ ! -f configure ]; then
      echo "$BN: ERROR: configure not created..."
      exit 1
   fi
   if [ -f Makefile ]; then
      rm -f Makefile
   fi
   echo "$BN: Doing: ./configure $PREFIX $OPTIONS"
   ./configure $PREFIX $OPTIONS
   echo "$BN: done configure"
   if [ ! -f Makefile ]; then
      echo "$BN: ERROR: Makefile not created..."
      exit 1
   fi
   echo "$BN: Doing: make"
   make
   echo "$BN: done make"
   echo "$BN: ready for make install, if no errors..."
else
   echo "$BN: can not locate 'autogen.sh'..."
   exit 1
fi
exit 0
