// Font.hxx
// from : http://gpwiki.org/index.php/OpenGL:Tutorials:Font_System

#include "ogl02.hxx"
#include <string>
#include "TexFont.h"

class Font
{
public:
   Font() { };
   Font(const char* file);
   ~Font();
 
  // The line height is constant
  int Line_Height() const;
  // Knowing the width of a character or a string can be useful if you
  // want your UI to look good at all.
  int Char_Width(unsigned char c) const;
  int String_Width(const std::string& str) const;
  // Draw a string at a given position.
  void Draw_String(const std::string& str, float x, float y);
  bool is_valid(void) { return (_valid_font|_is_tex_font); }

private:
  // Information about a glyph. Tex_y2 can be calculated from tex_y1
  // and _tex_line_height (see below). Advance is the width of the
  // glyph in screen space.
  struct Glyph
  {
    float tex_x1, tex_y1, tex_x2;
    int advance;
  };
  // An array to store the glyphs.
  Glyph* _glyphs;
  // A table to quickly get the glyph belonging to a character.
  Glyph* _table[256];
  // The line height, in screen space and in texture space, and the
  // OpenGL id of the font texture.
  int _line_height;
  GLuint _texture;
  float _tex_line_height;
   bool _valid_font;
   bool _is_tex_font;
   TexFont * _txf;
};

// eof - Font.hxx
