// fps.cxx

#if (defined(_MSC_VER) && (_MSC_VER >= 1400))
#pragma warning(disable: 4996)
#endif

#include <GL/glut.h>
#include <time.h>
#include <stdio.h>   // for sprintf()
#ifndef _MSC_VER
#include <string.h>  // for strlen()
#endif

static time_t last_time = 0;
static int tick_counter = 0;
static int frames_per_sec = 0;

int get_fps(void) { return frames_per_sec; }

int set_fps(void)
{
   time_t now = time(NULL);
   tick_counter++;
   if( last_time != now ) {
      last_time = now;
      frames_per_sec = tick_counter;
      tick_counter = 0;
      return 1;
   }
   return 0;
}

void
output_font_stg(void *font, int x, int y, char *string)
{
  int len, i;
  glRasterPos2f((GLfloat)x, (GLfloat)y);
#ifdef __FREEGLUT_EXT_H__
     glutBitmapString( font, (const unsigned char *)string );
#else
     len = (int) strlen(string);
     for (i = 0; i < len; i++) {
        glutBitmapCharacter(font, string[i]);
     }
#endif
}


void put_fps(void)
{
   static char _s_fps_buf[32];
   GLint winHeight, winWidth;
   char * cp = _s_fps_buf;
   sprintf(cp, "fps %d", get_fps() );
	/* save the ModelView matrix */
	glPushMatrix(); 
   	/* clear any current modeling or viewing xforms */
	   glLoadIdentity(); 
	   /* save the Projection matrix */
	   glMatrixMode( GL_PROJECTION );
	   glPushMatrix();
		   /* make new world space to display status in */
		   glLoadIdentity();
		   winWidth = glutGet(GLUT_WINDOW_WIDTH); 
		   winHeight = glutGet(GLUT_WINDOW_HEIGHT);
		   //glColor3f( 1.0f, 1.0f, 1.0f ); // does nothing here - text not seen
		   //glOrtho( -0.5, winWidth-0.5, -0.5, winHeight-0.5, -1, 1.0 );
		   glOrtho( 0.0, winWidth, 0.0, winHeight, -1, 1.0 );
		   glColor3f( 1.0f, 1.0f, 1.0f );   // even here, text is BLACK
		   glPushAttrib( GL_DEPTH_BUFFER_BIT );
			   /* don't want text to be hidden */
			   glDisable( GL_DEPTH_TEST ); 
			   //glColor3f( 1.0f, 1.0f, 1.0f ); // or her, text is black...
            //output_stg( GLUT_BITMAP_TIMES_ROMAN_10, winWidth - 60, 15, cp );
            output_font_stg( GLUT_BITMAP_TIMES_ROMAN_10, winWidth / 2, winHeight / 2, cp );
		   glPopAttrib();
	   /* restore matrixes */
	   glPopMatrix();
	   glMatrixMode( GL_MODELVIEW );
	glPopMatrix();
} /* put_fps */

static time_t start = 0;
int check_timeout( int ms )
{
   time_t curr = clock();
   if( curr > (start + ms) ) {
      start = curr;  // update
      return 0;      // continue
   }
   return 1;   // wait some
}


// eof - fps.cxx

