// ogl-fonts.cxx

#include "ogl02.hxx"
#include "Font.hxx"
#include "fps.hxx"
#include "ogl-utils.hxx"

using namespace std;

#define ADD_3D_FONT
static bool use_double_buf = true;

// There are three approaches to rendering fonts in OpenGL: 
// bitmap, outline (polygonal), and texture mapped. 
// Each method has its own advantages and disadvantages.

// taken from ogl07.cxx
// ===================================================================
// Example 7-5 : Multiple Display Lists to Define a Stroked Font: stroke.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>
//#include <stdlib.h>
//#include <string.h>
// There are three approaches to rendering fonts in OpenGL: 
// bitmap, outline (polygonal), and texture mapped. 
// Each method has its own advantages and disadvantages.

#define PT 1
#define STROKE 2
#define END 3

typedef struct charpoint {
   GLfloat   x, y;
   int    type;
} CP;

CP Adata[] = {
   { 0, 0, PT}, {0, 9, PT}, {1, 10, PT}, {4, 10, PT}, 
   {5, 9, PT}, {5, 0, STROKE}, {0, 5, PT}, {5, 5, END}
};

CP Edata[] = {
   {5, 0, PT}, {0, 0, PT}, {0, 10, PT}, {5, 10, STROKE},
   {0, 5, PT}, {4, 5, END}
};

CP Pdata[] = {
   {0, 0, PT}, {0, 10, PT}, {4, 10, PT}, {5, 9, PT}, {5, 6, PT}, 
   {4, 5, PT}, {0, 5, END}
};

CP Rdata[] = {
   {0, 0, PT}, {0, 10, PT}, {4, 10, PT}, {5, 9, PT}, {5, 6, PT}, 
   {4, 5, PT}, {0, 5, STROKE}, {3, 5, PT}, {5, 0, END}
};

CP Sdata[] = {
   {0, 1, PT}, {1, 0, PT}, {4, 0, PT}, {5, 1, PT}, {5, 4, PT}, 
   {4, 5, PT}, {1, 5, PT}, {0, 6, PT}, {0, 9, PT}, {1, 10, PT}, 
   {4, 10, PT}, {5, 9, END}
};

/*  drawLetter() interprets the instructions from the array
 *  for that letter and renders the letter with line segments.
 */
static void drawLetter(CP *l)
{
   glBegin(GL_LINE_STRIP);
   while (1) {
      switch (l->type) {
         case PT:
            glVertex2fv(&l->x);
            break;
         case STROKE:
            glVertex2fv(&l->x);
            glEnd();
            glBegin(GL_LINE_STRIP);
            break;
         case END:
            glVertex2fv(&l->x);
            glEnd();
            glTranslatef(8.0, 0.0, 0.0);
            return;
      }
      l++;
   }
}

/*  Create a display list for each of 6 characters      */
static void init75 (void)
{
   GLuint base;

   glShadeModel (GL_FLAT);

   base = glGenLists (128);
   glListBase(base);
   glNewList(base+'A', GL_COMPILE); drawLetter(Adata);
   glEndList();
   glNewList(base+'E', GL_COMPILE); drawLetter(Edata);
   glEndList();
   glNewList(base+'P', GL_COMPILE); drawLetter(Pdata);
   glEndList();
   glNewList(base+'R', GL_COMPILE); drawLetter(Rdata);
   glEndList();
   glNewList(base+'S', GL_COMPILE); drawLetter(Sdata);
   glEndList();
   glNewList(base+' ', GL_COMPILE); 
   glTranslatef(8.0, 0.0, 0.0); glEndList();
}

const char *test1 = "A SPARE SERAPE APPEARS AS";
const char *test2 = "APES PREPARE RARE PEPPERS";

static void printStrokedString(const char *s)
{
   GLsizei len = (GLsizei)strlen(s);
   glCallLists(len, GL_BYTE, (GLbyte *)s);
}

void display75(void)
{
   glClear(GL_COLOR_BUFFER_BIT);
   glColor3f(1.0, 1.0, 1.0);
   glPushMatrix();
      glScalef(2.0, 2.0, 2.0);
      glTranslatef(10.0, 30.0, 0.0);
      printStrokedString(test1);
   glPopMatrix();
   glPushMatrix();
      glScalef(2.0, 2.0, 2.0);
      glTranslatef(10.0, 13.0, 0.0);
      printStrokedString(test2);
   glPopMatrix();
   glFlush();
}

void reshape75(int w, int h)
{
   g_width = w;
   g_height = h;

   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   gluOrtho2D (0.0, (GLdouble) w, 0.0, (GLdouble) h);
}

void keyboard75(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case ' ':
         glutPostRedisplay();
         break;
   }
}

int main75(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (440, 120);
   //glutInitWindowSize (600, 600);
   glutCreateWindow (argv[0]);
   init75 ();
   glutReshapeFunc(reshape75);
   glutKeyboardFunc(keyboard75);
   glutDisplayFunc(display75);
   glutMainLoop();
   return 0;
}

//Example 8-2 : Drawing a Complete Font: font.c
// taken from ogl08.cxx to here
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>
//#include <stdlib.h>
//#include <string.h>

static GLubyte space[] =   // space character
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static GLubyte letters[][13] = { // 27 letters
    {0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xc3, 0xff, 0xc3, 0xc3, 0xc3, 0x66, 0x3c, 0x18},
    {0x00, 0x00, 0xfe, 0xc7, 0xc3, 0xc3, 0xc7, 0xfe, 0xc7, 0xc3, 0xc3, 0xc7, 0xfe},
    {0x00, 0x00, 0x7e, 0xe7, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe7, 0x7e},
    {0x00, 0x00, 0xfc, 0xce, 0xc7, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc7, 0xce, 0xfc},
    {0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xfc, 0xc0, 0xc0, 0xc0, 0xc0, 0xff},
    {0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfc, 0xc0, 0xc0, 0xc0, 0xff},
    {0x00, 0x00, 0x7e, 0xe7, 0xc3, 0xc3, 0xcf, 0xc0, 0xc0, 0xc0, 0xc0, 0xe7, 0x7e},
    {0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xff, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3},
    {0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e},
    {0x00, 0x00, 0x7c, 0xee, 0xc6, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06},
    {0x00, 0x00, 0xc3, 0xc6, 0xcc, 0xd8, 0xf0, 0xe0, 0xf0, 0xd8, 0xcc, 0xc6, 0xc3},
    {0x00, 0x00, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0},
    {0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xdb, 0xff, 0xff, 0xe7, 0xc3},
    {0x00, 0x00, 0xc7, 0xc7, 0xcf, 0xcf, 0xdf, 0xdb, 0xfb, 0xf3, 0xf3, 0xe3, 0xe3},
    {0x00, 0x00, 0x7e, 0xe7, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xe7, 0x7e},
    {0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0xc7, 0xc3, 0xc3, 0xc7, 0xfe},
    {0x00, 0x00, 0x3f, 0x6e, 0xdf, 0xdb, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0x66, 0x3c},
    {0x00, 0x00, 0xc3, 0xc6, 0xcc, 0xd8, 0xf0, 0xfe, 0xc7, 0xc3, 0xc3, 0xc7, 0xfe},
    {0x00, 0x00, 0x7e, 0xe7, 0x03, 0x03, 0x07, 0x7e, 0xe0, 0xc0, 0xc0, 0xe7, 0x7e},
    {0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff},
    {0x00, 0x00, 0x7e, 0xe7, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3},
    {0x00, 0x00, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3},
    {0x00, 0x00, 0xc3, 0xe7, 0xff, 0xff, 0xdb, 0xdb, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3},
    {0x00, 0x00, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0xc3},
    {0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0xc3},
    {0x00, 0x00, 0xff, 0xc0, 0xc0, 0x60, 0x30, 0x7e, 0x0c, 0x06, 0x03, 0x03, 0xff}
};

static GLuint fontOffset;
static bool done_raster_init = false;

static void makeRasterFont(void)
{
   if(done_raster_init)
      return;

   GLuint i, j;
   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

   fontOffset = glGenLists (128);
   for (i = 0,j = 'A'; i < 26; i++,j++) {
      glNewList(fontOffset + j, GL_COMPILE);
      glBitmap(8, 13, 0.0, 2.0, 10.0, 0.0, letters[i]);
      glEndList();
   }
   glNewList(fontOffset + ' ', GL_COMPILE);
   glBitmap(8, 13, 0.0, 2.0, 10.0, 0.0, space);
   glEndList();
   done_raster_init = true;

}

void init82(void)
{
   glShadeModel (GL_FLAT);
   makeRasterFont();
}

void printString(const char *s)
{
   glPushAttrib (GL_LIST_BIT);
   glListBase(fontOffset);
   glCallLists((GLsizei)strlen(s), GL_UNSIGNED_BYTE, (GLubyte *) s);
   glPopAttrib ();
}

/* Everything above this line could be in a library 
 * that defines a font.  To make it work, you've got 
 * to call makeRasterFont() before you start making 
 * calls to printString().
 */
void display82(void)
{
   GLfloat white[3] = { 1.0, 1.0, 1.0 };
   glClear(GL_COLOR_BUFFER_BIT);
   glColor3fv(white);

   //glDisable(GL_TEXTURE_2D) ;

   glRasterPos2i(20, 60);
   printString("THE QUICK BROWN FOX JUMPS");
   glRasterPos2i(20, 40);
   printString("OVER A LAZY DOG");

   if( use_double_buf )
      glutSwapBuffers();
   else
      glFlush ();
}

void reshape82(int w, int h)
{
   g_width = w;
   g_height = h;
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho (0.0, w, 0.0, h, -1.0, 1.0);
   glMatrixMode(GL_MODELVIEW);
}

void keyboard82(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
}

//   case 21:
//    printf(" 21: main82(argc,argv);  // paint some bitmap (raster) fonts\n" );
int main82(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
   use_double_buf = false;
   glutInitWindowSize(300, 100);
   //glutInitWindowSize(600, 600);
   glutInitWindowPosition (100, 100);
   glutCreateWindow(argv[0]);
   init82();
   glutReshapeFunc(reshape82);
   glutKeyboardFunc(keyboard82);
   glutDisplayFunc(display82);
   glutMainLoop();
   return 0;
}


// ========================================================================
// PLIB TESTING FONTS
// ******************
extern void toggle_plib_fonts(void);
extern void test_plib_font(int fps);
extern void load_plib_font(void);

static bool do_raster_fonts = false;
static bool use_bitmap_string = true;

void init82b(void)
{
   glShadeModel (GL_FLAT);
   load_plib_font();
}


void display82b(void)
{
   GLfloat white[3] = { 1.0, 1.0, 1.0 };
   glClear(GL_COLOR_BUFFER_BIT);
   glColor3fv(white);
   test_plib_font(get_fps());
   if( use_double_buf )
      glutSwapBuffers();
   else
      glFlush ();
}

void reshape82b(int w, int h)
{
   g_width = w;
   g_height = h;
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho (0.0, w, 0.0, h, -1.0, 1.0);
   glMatrixMode(GL_MODELVIEW);
}

static void
key_help82b(void)
{
   printf( " h (?) - output this help.\n" );
   printf( " t     - show font 1, 2, 3\n" );
   printf( " T     - toggle toggle show raster font.\n" );
   printf( " ESC   - exit.\n" );
}

void keyboard82b(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 't':
         toggle_plib_fonts();
         break;
      case 'T':
         do_raster_fonts = !do_raster_fonts;
         if(do_raster_fonts) {
            init82();
            glDisable(GL_TEXTURE_2D) ;
            glutDisplayFunc(display82);
            glutIdleFunc(NULL);
         } else {
            glEnable(GL_TEXTURE_2D) ;
            glutDisplayFunc(display82b);
            glutIdleFunc(display82b);
         }
         glutPostRedisplay();
         break;
      case 'h':
      case '?':
         key_help82b();
         break;
   }
}

//  case 32: paint some PLIB fonts (txf)" );
int main82b(int argc, char** argv)
{
   glutInit(&argc, argv);
   if( use_double_buf )
      glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
   else
      glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
   //glutInitWindowSize(300, 100);
   glutInitWindowSize(600, 600);
   glutInitWindowPosition (100, 100);
   glutCreateWindow(argv[0]);
   init82b();
   glutReshapeFunc(reshape82b);
   glutKeyboardFunc(keyboard82b);
   glutDisplayFunc(display82b);
   glutIdleFunc(display82b);
   key_help82b();
   glutMainLoop();
   return 0;
}

// **********************************************************
// built-in GLUT bitmap fonts
// ==========================
static GLfloat red, green, blue;
#define  MX_FONTS 9 - 2
#define ADD_FRAME_RATE
#ifdef ADD_FRAME_RATE
#include "fps.hxx"
#endif

static void *font = GLUT_BITMAP_TIMES_ROMAN_24;
typedef struct tagFONT_NAME {
   void * font;
   const char * name;
}FONT_NAME, * PFONT_NAME;

static FONT_NAME font_names[MX_FONTS] = {
   { GLUT_BITMAP_9_BY_15, "GLUT_BITMAP_9_BY_15" },
   { GLUT_BITMAP_TIMES_ROMAN_10, "GLUT_BITMAP_TIMES_ROMAN_10" },
   { GLUT_BITMAP_TIMES_ROMAN_24, "GLUT_BITMAP_TIMES_ROMAN_24" },
   //{ GLUT_STROKE_ROMAN, "GLUT_STROKE_ROMAN" },
   //{ GLUT_STROKE_MONO_ROMAN, "GLUT_STROKE_MONO_ROMAN" },
   { GLUT_BITMAP_8_BY_13, "GLUT_BITMAP_8_BY_13" },
   { GLUT_BITMAP_HELVETICA_10, "GLUT_BITMAP_HELVETICA_10" },
   { GLUT_BITMAP_HELVETICA_12, "GLUT_BITMAP_HELVETICA_12" },
   { GLUT_BITMAP_HELVETICA_18, "GLUT_BITMAP_HELVETICA_18" }
};

static const char * get_font_name( void * font )
{
   int i;
   PFONT_NAME pfn = &font_names[0];
   for(i = 0; i < MX_FONTS; i++) {
      if( pfn[i].font == font )
         return pfn[i].name;
   }
   return "Unknown";
}

static void
output(int x, int y, char *string)
{
  int len, i;
  glRasterPos2f(x, y);

  if( use_bitmap_string ) {
     // THIS IS AN EXTENDED freeglut functions
     // ===================
     // Noted using it GAINS about 700 frames per second
     // 1150 to 1850, a 60% increase, so it is MUCH faster
     // --------------------------------------------------
     // Draw a string of bitmapped characters. 
     // Parameters:
     //  font  A bitmapped font identifier.  
     //  string  A NUL-terminated ASCII string. 
     glutBitmapString( font, (const unsigned char *)string );
     // -----------------------------------------------------
  } else {
     len = (int) strlen(string);
     for (i = 0; i < len; i++) {
        // Draw a bitmapped character. 
        // Parameters:
        //  font  A bitmapped font identifier.  
        //  character  A character code. 
        // Draw a character at the current OpenGL raster position using 
        // a bitmapped font. The raster position is advanced by the 
        // width of the character.
        // Nothing is drawn, and the raster position is unaffected when either:
        //  character is out of range
        //  font is not a valid OpenGLUT bitmap font
        //  The current OpenGL raster position is invalid
        glutBitmapCharacter(font, string[i]);
     }
  }
}

#ifdef ADD_3D_FONT

void setOrthographicProjection()
{
   int w = g_width;
   int h = g_height;

	// switch to projection mode
	glMatrixMode(GL_PROJECTION);
	// save previous matrix which contains the 
	//settings for the perspective projection
	glPushMatrix();
	// reset matrix
	glLoadIdentity();
	// set a 2D orthographic projection
	gluOrtho2D(0, w, 0, h);
	// invert the y axis, down is positive
	glScalef(1, -1, 1);
	// mover the origin from the bottom left corner
	// to the upper left corner
	glTranslatef(0, -h, 0);
	glMatrixMode(GL_MODELVIEW);
}

static void resetPerspectiveProjection(void)
{
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
}

static void renderBitmapString(float x, 
                               float y, 
                               float z, 
                               void *font, 
                               char *string)
{
   char * cp;
   glRasterPos3f(x,y,z);
   for ( cp = string; *cp != '\0'; cp++ ) {
      glutBitmapCharacter(font, *cp);
   }
}

#endif // #ifdef ADD_3D_FONT

static void
display_m14(void)
{
   int i, wrap, x, y;
   char * cp = get_tmp_buf();
   unsigned char * ucp = (unsigned char *)cp;
   glClear(GL_COLOR_BUFFER_BIT);
   glColor3f(red, green, blue);
   x = 5;
   y = 24;
   sprintf(cp, "Font: %s", get_font_name(font) );
   output(x, y, cp);
   y += 24;
   sprintf(cp, "Color: r=%f, g=%f, b=%f", red, green, blue );
   output(x, y, cp);

   y += 24*2;
   *cp = 0;
   wrap = 0;
   //for(i = 32; i < 256; i++) { above 128 NOT painted???
   for(i = 32; i < 128; i++) {
      //sprintf(EndBuf(cp),"%c",i);
      ucp[wrap++] = (unsigned char)i;
      if(wrap >= 32) {
         cp[wrap] = 0;
         output(x, y, cp);
         wrap = 0;
         cp[wrap] = 0;
         y += 24;
      }
   }
   if(wrap) {
         cp[wrap] = 0;
         output(x, y, cp);
         wrap = 0;
         cp[wrap] = 0;
         y += 24;
   }

#ifdef ADD_3D_FONT
   // test output of '3D Tech'
   setOrthographicProjection();
	glPushMatrix();
	glLoadIdentity();
   //renderBitmapString(50,300,GLUT_HELVETICA_18,"3D Tech");
   renderBitmapString(50,300,1.0,GLUT_BITMAP_HELVETICA_18,"3D Tech");
	glPopMatrix();
   resetPerspectiveProjection();
#endif
#ifdef ADD_FRAME_RATE
   set_fps();
   {
     static char _s_tb[16];
     char * str = _s_tb;
     void *prev_font = font;
     font = GLUT_BITMAP_TIMES_ROMAN_10;
     //glPushMatrix();
     //glEnable(GL_TEXTURE_2D);
     glColor3f(1.0, 1.0, 1.0);
     sprintf(str,"fps=%d", get_fps() );
     output( g_width - 60, g_height - 10, str );
     //glPopMatrix();
     font = prev_font;
  }
#endif
   glutSwapBuffers();
}

static void
reshape_m14(int w, int h)
{
  g_width  = w;
  g_height = h;
  glViewport(0, 0, w, h);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(0, w, h, 0);
  glMatrixMode(GL_MODELVIEW);
}

void init_m14(void)
{
   red = 1.0;
   green = 1.0;
   blue = 1.0;
   glClearColor(0.0, 0.0, 0.0, 1.0);
}

#define MX_COLOR_SET 18
static int current_color = MX_COLOR_SET - 1;

static GLfloat colors[MX_COLOR_SET][3] = {
  { 255.0/255.0,   0.0/255.0,   0.0/255.0},
  { 238.0/255.0,   0.0/255.0,   0.0/255.0},
  { 205.0/255.0,   0.0/255.0,   0.0/255.0},
  {   0.0/255.0, 255.0/255.0,   0.0/255.0},
  {   0.0/255.0, 238.0/255.0,   0.0/255.0},
  {   0.0/255.0, 205.0/255.0,   0.0/255.0},
  {   0.0/255.0,   0.0/255.0, 255.0/255.0},
  {   0.0/255.0,   0.0/255.0, 238.0/255.0},
  {   0.0/255.0,   0.0/255.0, 205.0/255.0},
  { 255.0/255.0, 255.0/255.0,   0.0/255.0},
  { 238.0/255.0, 238.0/255.0,   0.0/255.0},
  { 205.0/255.0, 205.0/255.0,   0.0/255.0},
  {   0.0/255.0, 255.0/255.0, 255.0/255.0},
  {   0.0/255.0, 238.0/255.0, 238.0/255.0},
  {   0.0/255.0, 205.0/255.0, 205.0/255.0},
  { 255.0/255.0,   0.0/255.0, 255.0/255.0},
  { 238.0/255.0,   0.0/255.0, 238.0/255.0},
  { 205.0/255.0,   0.0/255.0, 205.0/255.0}
};

void set_next_color(void)
{
   current_color++;
   if( current_color >= MX_COLOR_SET )
      current_color = 0;
   red = colors[current_color][0];
   green = colors[current_color][1];
   blue = colors[current_color][2];
   printf("Color: r,g,b=%1.2f,%1.2f,%1.2f\n", red, green, blue );
}

static void
key_help_m14(void)
{
   printf( " h (?)  - this help.\n" );
   printf( " t      - change font (cycle=%s)\n",  get_font_name(font) );
   printf( " s      - toggle use bitmap string (%s)\n",
      (use_bitmap_string ? "on" : "off") );
   printf( " ESC    - exit.\n" );
}

void keyboard_m14( unsigned char key, int x, int y )
{
   int i;
   PFONT_NAME pfn = &font_names[0];
   keyboard_pgm_exit(key,x,y);
   switch(key)
   {
   case 't':
      for(i = 0; i < MX_FONTS; i++) {
         if( pfn[i].font == font ) {
            i++;  // bump to NEXT font
            if( !(i < MX_FONTS) )
               i = 0;   // deal with WRAP
            font = pfn[i].font;  // and use this FONT
            break;
         }
      }
      set_next_color(); // shift to next color
      printf( "Font: %s\n", get_font_name(font) );
      glutPostRedisplay(); // probably NOT needed, since using 'Idle' function
      break;
   case 's':
      use_bitmap_string = !use_bitmap_string;
      if(use_bitmap_string)
         printf("Switch to using gluBitmapString extension.\n");
      else
         printf("Switch to using gluBitmapCharacter normal.\n");
      glutPostRedisplay(); // probably NOT needed, since using 'Idle' function
      break;
   case 'h':
   case '?':
      key_help_m14();
      break;
   }
}

// 33: int glut_main14(int argc, char **argv)
int glut_main33(int argc, char **argv)
{
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
  //glutInitWindowSize(500, 150);
  glutInitWindowSize(600, 400);
  glutCreateWindow("GLUT bitmap font example");
  init_m14();
  glutDisplayFunc(display_m14);
  glutReshapeFunc(reshape_m14);
  glutKeyboardFunc(keyboard_m14);
#ifdef ADD_FRAME_RATE
  glutIdleFunc(display_m14);
#endif
  key_help_m14();
  glutMainLoop();
  return 0;
}

// ****************************************************************
// from : http://gpwiki.org/index.php/OpenGL:Tutorials:Font_System

static bool try_glx_reshape = false; // if true then mess get painted at center

#define  DEF_TEXT_FONT1 "rockfont.txf"    // get MEMORY EXCEPTION!!!
#define  DEF_TEXT_FONT2 "arialfont.txf"
#define  DEF_TEXT_FONT3 "Times-Roman.txf"

static Font * pfont = NULL;
static const char * pfile = DEF_TEXT_FONT2;
static char _s_ff_buf[264];

static void init_f37(void)
{
   char * pf = get_tmp_buf();
   // check for file, in two places
   strcpy(pf, pfile);
   if( !file_exists(pf) ) {   // local
      strcpy(pf,"data/");  // and in data/ folder
      strcat(pf,pfile);
      if( !file_exists(pf) ) {
         printf("ERROR: can not locate file [%s], nor [data/%s]! aborting...\n", pfile, pfile );
         fflush(stdout);
         exit(1);
      }
   }

   printf("Loading font file [%s]\n", pf );
   try{
      pfont = new Font(pf);
      if( !pfont->is_valid() ) {
         printf("ERROR: load of [%s] font file failed!\n", pf );
         pgm_exit(1);
      }
   }
   catch(const char * error){
     printf("ERROR: FAILED! [%s]!\n", error );
     pgm_exit(1);
   }
   
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel (GL_FLAT);   
}

static void display_f37(void)
{
   string str = "Hello World";
   //glClear(GL_COLOR_BUFFER_BIT);
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glColor3f(1.0, 1.0, 0.0);
   glEnable(GL_TEXTURE_2D);
   pfont->Draw_String(str, 20.0, 20.0);
   glDisable(GL_TEXTURE_2D);

   glutSwapBuffers();
}

void glx_reshape(int w, int h)
{
   GLdouble size;
   GLdouble aspect;

   /* Use the whole window. */
   glViewport(0, 0, w, h);

   /* We are going to do some 2-D orthographic drawing. */
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   size = (GLdouble)((w >= h) ? w : h) / 2.0;
   if (w <= h) {
      aspect = (GLdouble)h/(GLdouble)w;
      glOrtho(-size, size, -size*aspect, size*aspect, -100000.0, 100000.0);
   }
   else {
      aspect = (GLdouble)w/(GLdouble)h;
      glOrtho(-size*aspect, size*aspect, -size, size, -100000.0, 100000.0);
   }

   /* Make the world and window coordinates coincide so that 1.0 in */
   /* model space equals one pixel in window space.                 */
   glScaled(aspect, aspect, 1.0);

   /* Now determine where to draw things. */
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();

}

static void reshape_f37(int w, int h)
{
   g_width = w;
   g_height = h;
   if( try_glx_reshape ) {
      glx_reshape(w, h);
      return;
   }

   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   gluOrtho2D (0.0, (GLdouble) w, 0.0, (GLdouble) h);
}

static void keyboard_f37( unsigned char key, int x, int y )
{
   if( is_exit_key(key) )
      delete pfont;

   keyboard_pgm_exit(key,x,y);
}

// And then render Quads (okay a Triangle strip is better) with 
// appropriate texture coordinates. You'll probably also want to
// turn off perspective distortion (ie call glOrtho), and disable 
// depth-testing too. You can control the color of the text by 
// using the GL_MODULATE texture mode. I also map alpha's of 0 
// to all the black in the texture so that I can draw over 
// whatever happens to be in the background. (Either by 
// using alpha testing, or blending - you can actually get a nice 
// antialiased effect by using blending) 

int glut_main37(int argc, char **argv)
{
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
  //glutInitWindowSize(500, 150);
  glutInitWindowSize(600, 400);
  glutCreateWindow("font example - FAILS?");
  init_f37();
  glutDisplayFunc(display_f37);
  glutReshapeFunc(reshape_f37);
  glutKeyboardFunc(keyboard_f37);
  //key_help_f37();
  glutMainLoop();
  return 0;
}

// ogl-fonts.cxx
