
// ogl-sprtf.cxx
#include "ogl02.hxx"
#include <stdio.h>
#include <string.h>  // for strcpy, ...
#include <stdarg.h>  // for va_start, va_end
#include "ogl-sprtf.hxx"

#ifndef VFP
#define VFP(a) ( a && ( a != (FILE *) -1 ) )
#endif

#ifndef MXIO
#define  MXIO     512
#endif
#ifndef _MSC_VER
#define strcmpi strcasecmp
#endif

static char def_log[] = "tempogl.txt";
static char logfile[256] = "\0";
static FILE * outfile = NULL;
static int also_stdout = 1;

int   open_log_file( void )
{
   if (logfile[0] == 0)
      strcpy(logfile,def_log);
   outfile = fopen(logfile, "wb");
   if( outfile == 0 ) {
      outfile = (FILE *)-1;
      printf("WARNING: Failed to open log file [%s] ...\n", logfile);
      return 0;   /* failed */
   }
   return 1; /* success */
}

int set_also_stdout( int i )
{
   int prev = also_stdout;
   also_stdout = i;
   return prev;
}

void close_log_file( void )
{
   if( VFP(outfile) ) {
      fclose(outfile);
   }
   outfile = NULL;
}

void   set_log_file( char * nf )
{
   if (logfile[0] == 0)
      strcpy(logfile,def_log);
   if ( nf && *nf && strcmpi(nf,logfile) ) {
      close_log_file(); // remove any previous
      strcpy(logfile,nf); // set new name
      open_log_file();  // and open it ... anything previous written is 'lost'
   }
}

static void oi( char * ps )
{
   int len = (int)strlen(ps);
   if(len) {
      if( outfile == 0 ) {
         open_log_file();
      }
      if( VFP(outfile) ) {
         int w = (int)fwrite( ps, 1, len, outfile );
         if( w != len ) {
            fclose(outfile);
            outfile = (FILE *)-1;
            printf("WARNING: Failed write to log file [%s] ...\n", logfile);
         }
         fflush( outfile );
      }
      if( also_stdout )
         fwrite( ps, 1, len, stdout );
   }
}

static void	prt( char * ps )
{
   static char buf[MXIO + 4];
	char * pb = buf;
	size_t i, j, k;
	char   c, d;
   i = strlen(ps);
	if(i) {
		k = 0;
		d = 0;
		for( j = 0; j < i; j++ )
		{
			c = ps[j];
			if( c == 0x0d ) {
				if( (j+1) < i ) {
					if( ps[j+1] != 0x0a ) {
						pb[k++] = c;
						c = 0x0a;
					}
            } else {
					pb[k++] = c;
					c = 0x0a;
				}
			} else if( c == 0x0a ) {
				if( d != 0x0d ) {
					pb[k++] = 0x0d;
				}
			}
			pb[k++] = c;
			d = c;
			if( k >= MXIO ) {
				pb[k] = 0;
				oi( pb );
				k = 0;
			}
		}	// for length of string
		if( k ) {
			//if( ( gbCheckCrLf ) &&
			//	( d != 0x0a ) ) {
				// add Cr/Lf pair
				//pb[k++] = 0x0d;
				//pb[k++] = 0x0a;
				//pb[k] = 0;
			//}
			pb[k] = 0;
			oi( pb );
		}
	}
}

void out_to_log( char * ps )
{
   prt(ps);
}

int M_CDECL sprtf( char * pf, ... )
{
   static char _s_sprtfbuf[4096];
   char * pb = _s_sprtfbuf;
   int   i;
   va_list arglist;
   va_start(arglist, pf);
   i = vsprintf( pb, pf, arglist );
   va_end(arglist);
   prt(pb);
   return i;
}

// eof - ogl-sprtf.cxx
