// ogl-texfont.cxx
// from : http://web.mit.edu/course/6/6.837/src-backup/glut-3.7/progs/texfont/showtxf.c

/* Copyright (c) Mark J. Kilgard, 1997. */

/* This program is freely distributable without licensing fees  and is
   provided without guarantee or warrantee expressed or  implied. This
   program is -not- in the public domain. */

/* X compile line: cc -o showtxf showtxf.c texfont.c -lglut -lGLU -lGL -lXmu -lXext -lX11 -lm */
#if (defined(_MSC_VER) && (_MSC_VER >= 1400))
#pragma warning(disable: 4244 4305)
#endif
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <GL/glut.h>
#include "ogl02.hxx"
#include "ogl-utils.hxx"

#include "TexFont.h"

extern void pgm_exit(int ret);
extern void keyboard_pgm_exit(unsigned char key, int x, int y);

#define  DEF_FONT_FILE1 "default.txf"
#define  DEF_FONT_FILE2 "Times-Roman.txf"

static unsigned char *raster;
static int imgwidth, imgheight;
static int max_ascent, max_descent;
static int len;
static int ax = 20, ay = 20;
static int doubleBuffer = 1, verbose = 0;
static const char *filename = DEF_FONT_FILE2;
static TexFont *txf;
static int winWidth, winHeight;

/* If resize is called, enable drawing into the full screen area
   (glViewport). Then setup the modelview and projection matrices to map 2D
   x,y coodinates directly onto pixels in the window (lower left origin).
   Then set the raster position (where the image would be drawn) to be offset
   from the upper left corner, and then offset by the current offset (using a
   null glBitmap). */
static void
reshape(int w, int h)
{
  winWidth  = w;
  winHeight = h;

  // center the textfont IMAGE
  ax = (winWidth - imgwidth  ) / 2;
  ay = (winHeight - imgheight) / 2;

  glViewport(0, 0, w, h);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(0, w, 0, h);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glTranslatef(0, h - imgheight, 0);
  glRasterPos2i(0, 0);
  glBitmap(0, 0, 0, 0, ax, -ay, NULL);
}

static void
display_font01(void)
{
  /* Clear the color buffer. */
  glClear(GL_COLOR_BUFFER_BIT);

  /* Re-blit the image. */
  glDrawPixels(imgwidth, imgheight,
    GL_LUMINANCE, GL_UNSIGNED_BYTE,
    txf->teximage);

  /* Swap the buffers if necessary. */
  if (doubleBuffer) {
    glutSwapBuffers();
  }
}

static int moving = 0, ox, oy;

static void
mouse(int button, int state, int x, int y)
{
  if (button == GLUT_LEFT_BUTTON) {
    if (state == GLUT_DOWN) {

      /* Left mouse button press.  Update last seen mouse position. And set
         "moving" true since button is pressed. */
      ox = x;
      oy = y;
      moving = 1;

    } else {

      /* Left mouse button released; unset "moving" since button no longer
         pressed. */
      moving = 0;

    }
  }
}

static void
motion(int x, int y)
{
  /* If there is mouse motion with the left button held down... */
  if (moving) {

    /* Figure out the offset from the last mouse position seen. */
    ax += (x - ox);
    ay += (y - oy);

    /* Offset the raster position based on the just calculated mouse position
       delta.  Use a null glBitmap call to offset the raster position in
       window coordinates. */
    glBitmap(0, 0, 0, 0, x - ox, oy - y, NULL);

    /* Request a window redraw. */
    glutPostRedisplay();

    /* Update last seen mouse position. */
    ox = x;
    oy = y;
  }
}

//   case 38:
//      printf(" 38: main_textfont01(argc,argv); // original Mark J. Kilgard, 1997 texfont sample.\n" );
int
main_textfont01(int argc, char **argv)
{
  int i;
  char * cp = get_tmp_buf();
  
  glutInit(&argc, argv);
  for (i = 1; i < argc; i++) {
    if (!strcmp(argv[i], "-sb")) {
      doubleBuffer = 0;
    } else if (!strcmp(argv[i], "-v")) {
      verbose = 1;
    } else {
      filename = argv[i];
    }
  }
  if (filename == NULL) {
    fprintf(stderr, "usage: showtxf [GLUT-options] [-sb] [-v] txf-file\n");
    pgm_exit(1);
  }

   strcpy(cp,filename);
   if( !file_exists(cp) ) {
      strcpy(cp,"data/");
      strcat(cp,filename);
      if( !file_exists(cp) ) {
         printf( "ERROR: can not locate [%s] nor [%s] file... aborting...\n", filename, cp );
         exit(1);
      }
  }
  
  printf( "Loading font file [%s]\n", cp );
  txf = txfLoadFont(cp);
  if (txf == NULL) {
    fprintf(stderr, "Problem loading %s\n", cp);
    pgm_exit(1);
  }

  imgwidth  = txf->tex_width;
  imgheight = txf->tex_height;
  winWidth  = imgwidth + 40;
  winHeight = imgheight + 40;
  printf( "Got text width %d, height %d\n", imgwidth, imgheight );

  if (doubleBuffer) {
    glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE);
  } else {
    glutInitDisplayMode(GLUT_RGB | GLUT_SINGLE);
  }

  glutInitWindowSize(winWidth, winHeight);
  glutCreateWindow(filename);
  glutReshapeFunc(reshape);
  glutDisplayFunc(display_font01);
  glutMouseFunc(mouse);
  glutMotionFunc(motion);
  glutKeyboardFunc(keyboard_pgm_exit);
  /* Use a gray background so teximage with black backgrounds will show
     against showtxf's background. */
  glClearColor(0.2, 0.2, 0.2, 1.0);
  glutMainLoop();
  return 0;             /* ANSI C requires main to return int. */
}

// ===============================================================
// from : http://web.mit.edu/course/6/6.837/src-backup/glut-3.7/progs/texfont/txfdemo.c

/* Copyright (c) Mark J. Kilgard, 1997. */

/* This program is freely distributable without licensing fees  and is
   provided without guarantee or warrantee expressed or  implied. This
   program is -not- in the public domain. */

/* X compile line: cc -o txfdemo txfdemo.c -lglut -lGLU -lGL -lXmu -lXext -lX11 -lm */

//#include <math.h>
//#include <stdlib.h>
//#include <string.h>
//#include <stdio.h>
//#include <GL/glut.h>

//#include "TexFont.h"

/* Uncomment to debug various scenarios. */
#if 0
#undef GL_VERSION_1_1
#undef GL_EXT_polygon_offset
#endif

#ifndef GL_VERSION_1_1
#ifdef GL_EXT_polygon_offset
#define GL_POLYGON_OFFSET_FILL GL_POLYGON_OFFSET_EXT
#define glPolygonOffset(s,b) glPolygonOffsetEXT(s,b*0.001);
#else
/* Gag.  No polygon offset?  Artifacts will exist. */
#define glPolygonOffset(s,b) /* nothing */
#endif
#endif

#ifndef M_PI
#define M_PI            3.14159265358979323846
#endif

#if 0
static int doubleBuffer = 1;
static char *filename = "rockfont.txf";
static TexFont *txf;
#endif // 0
static int alphaMode;
static int savex;
static int minifyMenu;
static GLfloat angle = 20;
static int animation = 1;
static int usePolygonOffset = 1;
static int fullscreen = 0;

extern int check_timeout( int ms );

static void
idle_tex02(void)
{
   if( check_timeout( 100 ) )
      return;

  angle += 4;
  glutPostRedisplay();
}

static void 
visible_tex02(int vis)
{
  if (vis == GLUT_VISIBLE) {
    if (animation) {
      glutIdleFunc(idle_tex02);
    }
  } else {
    glutIdleFunc(NULL);
  }
}

static void reshape_tex02(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(60.0, (GLfloat) w/(GLfloat) h, 1.0, 20.0);
   glMatrixMode(GL_MODELVIEW);
}

static void
cubeSide_tex02(void)
{
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_BLEND);
  glDisable(GL_ALPHA_TEST);
  glColor3f(0.3, 0.7, 0.3);
  glRectf(-1.0, -1.0, 1.0, 1.0);
}


static void
alphaModeSet_tex02(void)
{
  switch (alphaMode) {
  case GL_ALPHA_TEST:
    glDisable(GL_BLEND);
    glEnable(GL_ALPHA_TEST);
    glAlphaFunc(GL_GEQUAL, 0.5);
    break;
  case GL_BLEND:
    glDisable(GL_ALPHA_TEST);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    break;
  case GL_ALPHA_TEST + GL_BLEND:
    glEnable(GL_ALPHA_TEST);
    glAlphaFunc(GL_GEQUAL, 0.0625);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    break;
  case GL_NONE:
    glDisable(GL_ALPHA_TEST);
    glDisable(GL_BLEND);
    break;
  }
}

static void
cubeSideWithOpenGLcircle_tex02(void)
{
  int w, ow, a, d;
  const char *text;
  int len;
  int i;
  GLfloat flen;

  cubeSide_tex02();

  glPushMatrix();
    alphaModeSet_tex02();
    glEnable(GL_TEXTURE_2D);
    if (usePolygonOffset) {
#if defined(GL_EXT_polygon_offset) || defined(GL_VERSION_1_1)
      glEnable(GL_POLYGON_OFFSET_FILL);
      glPolygonOffset(0.0, -3);
#endif
    }
    glColor3f(0.2, 0.2, 0.9);

    txfGetStringMetrics(txf, "OpenGL", 6, &w, &a, &d);
    text = "OpenGL OpenGL ";
    len = (int) strlen(text);
    txfGetStringMetrics(txf, text, len, &w, &a, &d);
    txfGetStringMetrics(txf, "O", 1, &ow, &a, &d);

    glScalef(5.6/w, 5.6/w, 5.6/w);
    flen = len;
    glTranslatef(-ow/2.0, -w/(M_PI*2.0), 0.0);

    for (i=0; i<len; i++) {
      if (text[i] == 'L' && usePolygonOffset) {
	/* Hack.  The "L" in OpenGL slightly overlaps the "G". Slightly
	   raise the "L" so that it will overlap the "G" in the depth
	   buffer to avoid a double blend.. */
        glPolygonOffset(0.0, -4);
        txfRenderGlyph(txf, text[i]);
        glPolygonOffset(0.0, -3);
      } else {
        txfRenderGlyph(txf, text[i]);
      }
      glRotatef(360.0/flen, 0, 0, 1);  // angle,x,y,z
    }
    if (usePolygonOffset) {
#if defined(GL_EXT_polygon_offset) || defined(GL_VERSION_1_1)
      glDisable(GL_POLYGON_OFFSET_FILL);
#endif
    }
  glPopMatrix();
}

static void
cubeSideWithText_tex02(char *text, int len)
{
  int w, a, d;

  cubeSide_tex02();

  glPushMatrix();
    glEnable(GL_TEXTURE_2D);
    alphaModeSet_tex02();
    if (usePolygonOffset) {
#if defined(GL_EXT_polygon_offset) || defined(GL_VERSION_1_1)
      glEnable(GL_POLYGON_OFFSET_FILL);
      glPolygonOffset(0.0, -3);
#endif
    }
    glColor3f(0.2, 0.2, 0.9);

    txfGetStringMetrics(txf, text, len, &w, &a, &d);

    glScalef(1.8/w, 1.8/w, 1.8/w);
    glTranslatef(-w/2.0, d-(a+d)/2.0, 0.0);

    txfRenderFancyString(txf, text, len);
    if (usePolygonOffset) {
#if defined(GL_EXT_polygon_offset) || defined(GL_VERSION_1_1)
      glDisable(GL_POLYGON_OFFSET_FILL);
#endif
    }
  glPopMatrix();
}

static void
display_tex02(void)
{
  char *str;

  /* Clear the color buffer. */
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glPushMatrix();

  glRotatef(-angle, 0, 1, 0);  // angle,x,y,z

  glPushMatrix();
    glTranslatef(0.0, 0.0, 1.0);
    cubeSideWithOpenGLcircle_tex02();
  glPopMatrix();
  glPushMatrix();
    glRotatef(90.0, 0, 1, 0);  // angle,x,y,z
    glTranslatef(0.0, 0.0, 1.0);
    str = "MAkes";
    cubeSideWithText_tex02(str, (int) strlen(str));
  glPopMatrix();
  glPushMatrix();
    glRotatef(180.0, 0, 1, 0);  // angle,x,y,z
    glTranslatef(0.0, 0.0, 1.0);
    str = "Text";
    cubeSideWithText_tex02(str, (int) strlen(str));
  glPopMatrix();
  glPushMatrix();
    glRotatef(270.0, 0, 1, 0);  // angle,x,y,z
    glTranslatef(0.0, 0.0, 1.0);
    str = "\033T\377\000\000\000\000\3773D";
    cubeSideWithText_tex02(str, 10);
  glPopMatrix();

  glPopMatrix();

  /* Swap the buffers if necessary. */
  if (doubleBuffer) {
    glutSwapBuffers();
  }
}


/* ARGSUSED23 */
static void
mouse_tex02(int button, int state, int x, int y)
{
  if (button == GLUT_LEFT_BUTTON) {
    if (state == GLUT_DOWN) {
      glutIdleFunc(NULL);
      savex = x;
    } else {
      if (animation)
        glutIdleFunc(idle_tex02);
    }
  }
}

/* ARGSUSED1 */
static void
motion_tex02(int x, int y)
{
  angle += (savex - x);
  savex = x;
  glutPostRedisplay();
}


static void
minifySelect_tex02(int value)
{
  glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, value);
  glutPostRedisplay();
}

static int alphaMenu;

static void
alphaSelect_tex02(int value)
{
  alphaMode = value;
  glutPostRedisplay();
}

int polygonOffsetMenu;

static void
polygonOffsetSelect_tex02(int value)
{
  usePolygonOffset = value;
  glutPostRedisplay();
}

int animationMenu;

static void
animationSelect_tex02(int value)
{
  animation = value;
  if (animation) {
    glutIdleFunc(idle_tex02);
  } else {
    glutIdleFunc(NULL);
  }
}

/* ARGSUSED1 */
static void
keyboard_tex02(unsigned char c, int x, int y)
{
   keyboard_pgm_exit(c,x,y);
  switch(c) {
  case 27:
    pgm_exit(0);
    break;
  case ' ':
    animation = 1 - animation;
    if (animation) {
      glutIdleFunc(idle_tex02);
    } else  {
      glutIdleFunc(NULL);
    }
    break;
  }
}

static void
mainSelect_tex02(int value)
{
  if (value == 666) {
    pgm_exit(0);
  }
}

static void init_tex02(void)
{
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(60.0, 1.0, 0.1, 20.0);
  glMatrixMode(GL_MODELVIEW);
  gluLookAt(0.0, 0.0, 4.0,
    0.0, 0.0, 0.0,
    0.0, 1.0, 0.0);

  /* Use a gray background so the teximage with black backgrounds will show
     against showtxf's background. */
  glClearColor(0.0, 0.0, 0.0, 0.0);

  glEnable(GL_DEPTH_TEST);
  glEnable(GL_CULL_FACE);
  alphaSelect_tex02(GL_ALPHA_TEST);
  minifySelect_tex02(GL_NEAREST);

  txfEstablishTexture(txf, 1, GL_TRUE);
}

int
main_tex02(int argc, char **argv)
{
  int i;
  char * cp = get_tmp_buf();
  
  glutInit(&argc, argv);
  for (i = 1; i < argc; i++) {
    if (!strcmp(argv[i], "-sb")) {
      doubleBuffer = 0;
    } else if (!strcmp(argv[i], "-fullscreen")) {
      fullscreen = 1;
    } else {
      filename = argv[i];
    }
  }
  if (filename == NULL) {
    fprintf(stderr, "usage: txfdemo [GLUT-options] [-sb] txf-file\n");
    pgm_exit(1);
  }

  strcpy(cp,filename);
  if( !file_exists(cp) ) {
     strcpy(cp,"data/");
     strcat(cp,filename);
     if( !file_exists(cp) ) {
        printf( "ERROR: can not locate [%s] nor [%s] file... aborting...\n", filename, cp );
        exit(1);
     }
  }
  txf = txfLoadFont(cp);
  if (txf == NULL) {
    fprintf(stderr, "Problem loading %s, %s\n", cp, txfErrorString());
    pgm_exit(1);
  }

  if (doubleBuffer) {
    glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH | GLUT_MULTISAMPLE);
  } else {
    glutInitDisplayMode(GLUT_RGB | GLUT_SINGLE | GLUT_DEPTH | GLUT_MULTISAMPLE);
  }
  glutInitWindowSize(300, 300);
  if (fullscreen) {
    glutGameModeString("640x480:16@60");
    glutEnterGameMode();
  } else {
    glutCreateWindow("txfdemo");
  }
  glutDisplayFunc(display_tex02);
  glutMouseFunc(mouse_tex02);
  glutMotionFunc(motion_tex02);
  glutKeyboardFunc(keyboard_tex02);
  glutVisibilityFunc(visible_tex02);
  glutReshapeFunc(reshape_tex02);

  init_tex02();

  if (!fullscreen) {
    minifyMenu = glutCreateMenu(minifySelect_tex02);
    glutAddMenuEntry("Nearest", GL_NEAREST);
    glutAddMenuEntry("Linear", GL_LINEAR);
    glutAddMenuEntry("Nearest mipmap nearest", GL_NEAREST_MIPMAP_NEAREST);
    glutAddMenuEntry("Linear mipmap nearest", GL_LINEAR_MIPMAP_NEAREST);
    glutAddMenuEntry("Nearest mipmap linear", GL_NEAREST_MIPMAP_LINEAR);
    glutAddMenuEntry("Linear mipmap linear", GL_LINEAR_MIPMAP_LINEAR);

    alphaMenu = glutCreateMenu(alphaSelect_tex02);
    glutAddMenuEntry("Alpha testing", GL_ALPHA_TEST);
    glutAddMenuEntry("Alpha blending", GL_BLEND);
    glutAddMenuEntry("Both", GL_ALPHA_TEST + GL_BLEND);
    glutAddMenuEntry("Nothing", GL_NONE);

    polygonOffsetMenu = glutCreateMenu(polygonOffsetSelect_tex02);
    glutAddMenuEntry("Enable", 1);
    glutAddMenuEntry("Disable", 0);

    animationMenu = glutCreateMenu(animationSelect_tex02);
    glutAddMenuEntry("Start", 1);
    glutAddMenuEntry("Stop", 0);

    glutCreateMenu(mainSelect_tex02);
    glutAddSubMenu("Filtering", minifyMenu);
    glutAddSubMenu("Alpha", alphaMenu);
    glutAddSubMenu("Polygon Offset", polygonOffsetMenu);
    glutAddSubMenu("Animation", animationMenu);
    glutAddMenuEntry("Quit", 666);
    glutAttachMenu(GLUT_RIGHT_BUTTON);
  }

#if !defined(GL_EXT_polygon_offset) && !defined(GL_VERSION_1_1)
  fprintf(stderr, "Warning: polygon offset not available; artifacts will results.\n");
#endif

  glutMainLoop();
  return 0;             /* ANSI C requires main to return int. */
}

// #if 0 // moved to simpletxf.cxx
// ====================================================================
// from : http://web.mit.edu/course/6/6.837/src-backup/glut-3.7/progs/texfont/simpletxf.c
// #endif // 0 #if 0 // moved to simpletxf.cxx

// ogl-texfont.cxx
