
// ogl01.cxx
//#include "ogl02.hxx"
#include <stdlib.h>  // for exit()
#ifndef _MSC_VER
#include <string.h>  // for strlen()
#endif
#include <GL/glut.h> // for the standard implementation

static void
out_string_at(void *font, int x, int y, const char *string)
{
#ifdef __FREEGLUT_EXT_H__
   // this is ONLY if GLUT has this extended mode
   glRasterPos2f((GLfloat)x, (GLfloat)y);
   glutBitmapString( font, (const unsigned char *)string );
#else
   int len, i;
   glRasterPos2f((GLfloat)x, (GLfloat)y); // set position
   len = (int) strlen(string);
   for (i = 0; i < len; i++) { // output character by character
      glutBitmapCharacter(font, string[i]);
   }
#endif
}

// set some INITIAL values
static void init01(void) 
{
   glClearColor (1.0, 1.0, 1.0, 0.0);  // clear to color
   glShadeModel (GL_FLAT); // The default value is GL_SMOOTH
}

// called to DISPLAY what ever desired
static void display01(void)
{
   glClear(GL_COLOR_BUFFER_BIT); // clear screen, to glClearColor()
   glColor3f(1.0,0.0,0.0); // output the string, in red
   out_string_at( GLUT_BITMAP_TIMES_ROMAN_24, 14, 5, "Hello World" );
   glFlush (); // use glutSwapBuffers(); if GLUT_DOUBLE
}

// called initially, and when SIZE is changed
static void reshape01(int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h); // set view port to ALL
   glMatrixMode (GL_PROJECTION); // use PROJECTION matrix
   glLoadIdentity (); // and load it...
   gluOrtho2D (0.0, (GLdouble) w, 0.0, (GLdouble) h); // set to whole screen
}

// called on each KEYBOARD character
static void keyboard01(unsigned char key, int x, int y)
{
   if((key == 0x1b)||(key == 'q')||(key == 'Q'))
      exit(0); // exit on any of the above keyboard inputs
}

// simple Hello World application
int main_case01(int argc, char** argv)
{
   glutInit(&argc, argv); // initialize GLUT - must be first
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB); // set MODE
   glutInitWindowSize (150, 30); // set size (or default size used)
   glutCreateWindow ("Hello"); // create window, and set TITLE
   init01(); // some local init...
   glutDisplayFunc(display01);   // set DISPLAY function
   glutReshapeFunc(reshape01);   // set SIZE function
   glutKeyboardFunc(keyboard01); // set KEYBOARD function
   glutMainLoop(); // run application, never to return
   return 0; /* ANSI C requires main to return int. */
}

// eof - ogl01.cxx
