// ogl02.cxx
// from : http://www.glprogramming.com/red/chapter02.html
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ogl02.hxx"
#include "ogl03.hxx"
#include "ogl04.hxx"
#include "ogl05.hxx"
#include "ogl06.hxx"
#include "ogl07.hxx"
#include "ogl08.hxx"
#include "ogl09.hxx"
#include "ogl10.hxx"
#include "ogl11.hxx"
#include "ogl-fonts.hxx"
#include "ogl-utils.hxx"
#include "fps.hxx"
#include <string.h> // for strdup() function

extern int main_Koch (int argc, char **argv); // "Rotatable Koch snowflake. <Click mouse to form Tri>"
extern int main_polar( int argc, char *argv[] ); // world view n/s poles - mouse rotatable
extern int glut_main16(int argc, char **argv); // torus, put in motion by mouse click and move
extern int test_main_ftgl(int args, char** argv); // check out font conversion TTF to TXF???
extern int glut_main37(int argc, char **argv);
extern int main_textfont01(int argc, char **argv);
extern int main_tex02(int argc, char **argv);
extern int main_tex03(int argc, char **argv);
extern int main_case01(int argc, char** argv);

char * g_progname;

static GLfloat spin = 0.0;
static int current_color = 7;
static GLint circle_points = 100; 
static bool add_line_display = true;  // how to combine the two???
static bool draw_the_flies = true;
int g_width, g_height;
static bool draw_polygon = false;
static bool draw_circle = true;
static char _s_tmpbuf[1024];

char * get_tmp_buf(void) { return _s_tmpbuf; }

// Example 2-13 : Drawing an Icosahedron
#define X 0.525731112119133606 
#define Z 0.850650808352039932

static GLfloat vdata[12][3] = {    
   {-X, 0.0, Z}, {X, 0.0, Z}, {-X, 0.0, -Z}, {X, 0.0, -Z},    
   {0.0, Z, X}, {0.0, Z, -X}, {0.0, -Z, X}, {0.0, -Z, -X},    
   {Z, X, 0.0}, {-Z, X, 0.0}, {Z, -X, 0.0}, {-Z, -X, 0.0} 
};
static GLuint tindices[20][3] = { 
   {0,4,1}, {0,9,4}, {9,5,4}, {4,5,8}, {4,8,1},    
   {8,10,1}, {8,3,10}, {5,3,8}, {5,2,3}, {2,7,3},    
   {7,10,3}, {7,6,10}, {7,11,6}, {11,0,6}, {0,1,6}, 
   {6,1,10}, {9,0,11}, {9,11,2}, {9,2,5}, {7,2,11} };

void Drawing_an_Icosahedron(void)
{
   int i;
   glBegin(GL_TRIANGLES);
   for (i = 0; i < 20; i++) {
      /* color information here */ 
      glVertex3fv(&vdata[tindices[i][0]][0]); 
      glVertex3fv(&vdata[tindices[i][1]][0]); 
      glVertex3fv(&vdata[tindices[i][2]][0]);
   }
   glEnd();
}



static void set_black(void) { glColor3f(0.0, 0.0, 0.0); } // black 
static void set_red(void)   { glColor3f(1.0, 0.0, 0.0); } // red 
static void set_green(void) { glColor3f(0.0, 1.0, 0.0); } // green 
static void set_yellow(void) { glColor3f(1.0, 1.0, 0.0); } // yellow 
static void set_blue(void) { glColor3f(0.0, 0.0, 1.0);  } // blue 
static void set_magenta(void) { glColor3f(1.0, 0.0, 1.0); } // magenta 
static void set_cyan(void) { glColor3f(0.0, 1.0, 1.0);  } //  cyan 
static void set_white(void) { glColor3f(1.0, 1.0, 1.0); } //  white

static void set_color_num( int n )
{
   switch(n)
   {
   case 0:
      set_black();
      break;
   case 1:
      set_red();
      break;
   case 2:
      set_green();
      break;
   case 3:
      set_yellow();
      break;
   case 4:
      set_blue();
      break;
   case 5:
      set_magenta();
      break;
   case 6:
      set_cyan();
      break;
   case 7:
      set_white();
      break;
   }
}

void set_new_color(void)
{
  set_color_num( current_color );
  current_color++;
  if(current_color > 7)
     current_color = 1;
}

// ==============================================
// Vertices and Normals
static GLint vertices[] = {25, 25,
                          100, 325,
                          175, 25,
                          175, 325,
                          250, 25,
                          325, 325};
static GLfloat colors[] = {1.0, 0.2, 0.2,
                          0.2, 0.2, 1.0,
                          0.8, 1.0, 0.2,
                          0.75, 0.75, 0.75,
                          0.35, 0.35, 0.35,
                          0.5, 0.5, 0.5};

void enable_arrays(void)
{
   glEnableClientState (GL_COLOR_ARRAY);
   glEnableClientState (GL_VERTEX_ARRAY);
}
void init_arrays(void)
{
   enable_arrays();
   glColorPointer (3, GL_FLOAT, 0, colors);
   glVertexPointer (2, GL_INT, 0, vertices);
}

static GLfloat intertwined[] =
      {1.0, 0.2, 1.0, 100.0, 100.0, 0.0,
       1.0, 0.2, 0.2, 0.0, 200.0, 0.0,
       1.0, 1.0, 0.2, 100.0, 300.0, 0.0,
       0.2, 1.0, 0.2, 200.0, 300.0, 0.0,
       0.2, 1.0, 1.0, 300.0, 200.0, 0.0,
       0.2, 0.2, 1.0, 200.0, 100.0, 0.0};

void init_itertwined(void)
{
   enable_arrays();
   glColorPointer (3, GL_FLOAT, 6 * sizeof(GLfloat), intertwined);
   // For the vertex coordinate pointer, you need to start from further 
   // in the array, at the fourth element of intertwined 
   // (remember that C programmers start counting at zero).
   glVertexPointer(3, GL_FLOAT,6*sizeof(GLfloat), &intertwined[3]);

}

void display_arrays(void)
{

   glBegin(GL_TRIANGLES);
      glArrayElement (2);
      glArrayElement (3);
      glArrayElement (5);
   glEnd();
   // When executed, the latter five lines of code has the same effect as
#if 0
   glBegin(GL_TRIANGLES);
      glColor3fv(colors+(2*3*sizeof(GLfloat));
      glVertex3fv(vertices+(2*2*sizeof(GLint));
      glColor3fv(colors+(3*3*sizeof(GLfloat));
      glVertex3fv(vertices+(3*2*sizeof(GLint));
      glColor3fv(colors+(5*3*sizeof(GLfloat));
      glVertex3fv(vertices+(5*2*sizeof(GLint));
   glEnd();
#endif // 0

}

// Example 2-11 : Two Ways to Use glDrawElements()
static GLubyte frontIndices[] = {4, 5, 6, 7};
static GLubyte rightIndices[] = {1, 2, 6, 5};
static GLubyte bottomIndices[] = {0, 1, 5, 4};
static GLubyte backIndices[] = {0, 3, 2, 1};
static GLubyte leftIndices[] = {0, 4, 7, 3};
static GLubyte topIndices[] = {2, 3, 7, 6};
void draw_element1(void)
{
   glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, frontIndices);
   glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, rightIndices);
   glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, bottomIndices);
   glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, backIndices);
   glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, leftIndices);
   glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, topIndices);
}
// Or better still, crunch all the indices together:

static GLubyte allIndices[] = {4, 5, 6, 7, 1, 2, 6, 5, 
 0, 1, 5, 4, 0, 3, 2, 1, 
 0, 4, 7, 3, 2, 3, 7, 6};
void draw_element2(void)
{
   glDrawElements(GL_QUADS, 24, GL_UNSIGNED_BYTE, allIndices);
}

void outline_a_tri(float * V0, float * V1, float * V2)
{
   //      / v2
   //     /
   //    /
   // v0 ------------ v1
   glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glBegin(GL_POLYGON);
       glEdgeFlag(GL_TRUE);
       glVertex3fv(V0);
       glEdgeFlag(GL_FALSE);
       glVertex3fv(V1);
       glEdgeFlag(GL_TRUE);
       glVertex3fv(V2);
   glEnd();
}

void outline_a_poly(float * n0, float * v0,
                    float * n1, float * v1,
                    float * n2, float * v2,
                    float * n3, float * v3)
{
   glBegin (GL_POLYGON);
      glNormal3fv(n0);
      glVertex3fv(v0);
      glNormal3fv(n1);
      glVertex3fv(v1);
      glNormal3fv(n2);
      glVertex3fv(v2);
      glNormal3fv(n3);
      glVertex3fv(v3);
   glEnd();
}

// ========================================


void init(void) 
{
   glClearColor (0.0, 0.0, 0.0, 0.0);  // clear to BLACK
   glShadeModel (GL_FLAT);
}


void draw_fly(void)
{
   GLubyte fly[] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x03, 0x80, 0x01, 0xC0, 0x06, 0xC0, 0x03, 0x60, 
      0x04, 0x60, 0x06, 0x20, 0x04, 0x30, 0x0C, 0x20, 
      0x04, 0x18, 0x18, 0x20, 0x04, 0x0C, 0x30, 0x20,
      0x04, 0x06, 0x60, 0x20, 0x44, 0x03, 0xC0, 0x22, 
      0x44, 0x01, 0x80, 0x22, 0x44, 0x01, 0x80, 0x22, 
      0x44, 0x01, 0x80, 0x22, 0x44, 0x01, 0x80, 0x22,
      0x44, 0x01, 0x80, 0x22, 0x44, 0x01, 0x80, 0x22, 
      0x66, 0x01, 0x80, 0x66, 0x33, 0x01, 0x80, 0xCC, 
      0x19, 0x81, 0x81, 0x98, 0x0C, 0xC1, 0x83, 0x30,
      0x07, 0xe1, 0x87, 0xe0, 0x03, 0x3f, 0xfc, 0xc0, 
      0x03, 0x31, 0x8c, 0xc0, 0x03, 0x33, 0xcc, 0xc0, 
      0x06, 0x64, 0x26, 0x60, 0x0c, 0xcc, 0x33, 0x30,
      0x18, 0xcc, 0x33, 0x18, 0x10, 0xc4, 0x23, 0x08, 
      0x10, 0x63, 0xC6, 0x08, 0x10, 0x30, 0x0c, 0x08, 
      0x10, 0x18, 0x18, 0x08, 0x10, 0x00, 0x00, 0x08};
   GLubyte halftone[] = {
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55,
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55,
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55,
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55,
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55,
      0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55};

/*  draw one solid, unstippled rectangle,       */      
/*  then two stippled rectangles                */
   glRectf (25.0, 25.0, 125.0, 125.0);
   glEnable (GL_POLYGON_STIPPLE);
   glPolygonStipple (fly);
   glRectf (125.0, 25.0, 225.0, 125.0);
   glPolygonStipple (halftone);
   glRectf (225.0, 25.0, 325.0, 125.0);
   glDisable (GL_POLYGON_STIPPLE);

}

void draw_a_polygon( void )
{
   // the square is
   // glRectf(-25.0, -25.0, 25.0, 25.0);
   float factor = 8.0;
   glBegin(GL_POLYGON);
      glVertex2f(0.0*factor, 0.0*factor);
      glVertex2f(0.0*factor, 3.0*factor);
      glVertex2f(4.0*factor, 3.0*factor);
      glVertex2f(6.0*factor, 1.5*factor);
      glVertex2f(4.0*factor, 0.0*factor);
   glEnd();
}

#define drawOneLine(x1,y1,x2,y2)  glBegin(GL_LINES);  \
   glVertex2f ((x1),(y1)); glVertex2f ((x2),(y2)); glEnd();

void draw_lines(void)
{
   int i;
/* in 1st row, 3 lines, each with a different stipple  */
   glEnable (GL_LINE_STIPPLE);
   
   glLineStipple (1, 0x0101);  /*  dotted  */
   drawOneLine (50.0, 125.0, 150.0, 125.0);
   glLineStipple (1, 0x00FF);  /*  dashed  */
   drawOneLine (150.0, 125.0, 250.0, 125.0);
   glLineStipple (1, 0x1C47);  /*  dash/dot/dash  */
   drawOneLine (250.0, 125.0, 350.0, 125.0);
/* in 2nd row, 3 wide lines, each with different stipple */
   glLineWidth (5.0);
   glLineStipple (1, 0x0101);  /*  dotted  */
   drawOneLine (50.0, 100.0, 150.0, 100.0);
   glLineStipple (1, 0x00FF);  /*  dashed  */
   drawOneLine (150.0, 100.0, 250.0, 100.0);
   glLineStipple (1, 0x1C47);  /*  dash/dot/dash  */
   drawOneLine (250.0, 100.0, 350.0, 100.0);
   glLineWidth (1.0);

/* in 3rd row, 6 lines, with dash/dot/dash stipple  */
/* as part of a single connected line strip         */
   glLineStipple (1, 0x1C47);  /*  dash/dot/dash  */
   glBegin (GL_LINE_STRIP);
   for (i = 0; i < 7; i++)
      glVertex2f ((GLfloat)(50.0 + ((GLfloat) i * 50.0)), 75.0);
   glEnd ();

/* in 4th row, 6 independent lines with same stipple  */
   for (i = 0; i < 6; i++) {
      drawOneLine ((GLfloat)(50.0 + ((GLfloat) i * 50.0)), 50.0,
         (GLfloat)(50.0 + ((GLfloat)(i+1) * 50.0)), 50.0);
   }

/* in 5th row, 1 line, with dash/dot/dash stipple    */
/* and a stipple repeat factor of 5                  */
   glLineStipple (5, 0x1C47);  /*  dash/dot/dash  */
   drawOneLine (50.0, 25.0, 350.0, 25.0);

   glDisable (GL_LINE_STIPPLE);
}

void display_lines(void)
{

   glClear (GL_COLOR_BUFFER_BIT);
/* select white for all lines  */
   glColor3f (1.0, 1.0, 1.0);

   if( draw_the_flies )
      draw_fly();
   else
      draw_lines();

   glFlush ();
   glutSwapBuffers();
}


void draw_a_circle(void)
{
   int i;
   float angle;
   float radius = 25.0;
   glBegin(GL_LINE_LOOP);
   for (i = 0; i < circle_points; i++) {
      angle = (float)(2*PI*i/circle_points); 
      glVertex2f(cos(angle)*radius, sin(angle)*radius); 
   }
   glEnd();
}

void display_a_polygon(void)
{
   glClear(GL_COLOR_BUFFER_BIT);
   glPushMatrix();
   glRotatef(spin, 0.0, 0.0, 1.0);  // angle,x,y,z
   set_new_color();
   if(draw_circle)
      draw_a_circle();
   else
      draw_a_polygon();
   glPopMatrix();
   glutSwapBuffers();

}

void display_a_square(void)
{
   glClear(GL_COLOR_BUFFER_BIT);
   glPushMatrix();
   glRotatef(spin, 0.0, 0.0, 1.0);  // angle,x,y,z
   set_new_color();
   glRectf(-25.0, -25.0, 25.0, 25.0);
   glPopMatrix();
   glutSwapBuffers();
}

void spinDisplay(void)
{
   spin = (float)(spin + 2.0);
   if (spin > 360.0)
      spin = (float)(spin - 360.0);
   glutPostRedisplay();
}

void reshape(int w, int h)
{
   g_width = w;
   g_height = h;
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   if(add_line_display) {
      glMatrixMode (GL_PROJECTION);
      glLoadIdentity ();
      gluOrtho2D (0.0, (GLdouble) w, 0.0, (GLdouble) h);
   } else {
      glMatrixMode(GL_PROJECTION);
      glLoadIdentity();
      glOrtho(-50.0, 50.0, -50.0, 50.0, -1.0, 1.0);
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity();
   }
}

void mouse(int button, int state, int x, int y) 
{
   if( !add_line_display ) {
      switch (button) {
         case GLUT_LEFT_BUTTON:
            if (state == GLUT_DOWN)
               glutIdleFunc(spinDisplay);
            break;
         case GLUT_RIGHT_BUTTON:
            if (state == GLUT_DOWN)
               glutIdleFunc(NULL);
            break;
         default:
            break;
      }
   }
}

bool is_exit_key(unsigned char key)
{
   if((key == 0x1b)||(key == 'q')||(key == 'Q'))
      return true;

   return false;
}

void keyboard_pgm_exit(unsigned char key, int x, int y)
{
   switch (key)
   {
   case 0x1b:
   case 'q':
   case 'Q':
      pgm_exit(0);
      break;
   }
}

static void key_help(void)
{
   printf( " h or ? - this help\n" );
   printf( " t      - toggle draw flies (%s)\n", (draw_the_flies ? "On" : "Off") );
   printf( " T      - toggle line display (%s)\n", (add_line_display ? "On" : "Off") );
   printf( " p      - toogle polygon draw (%s)\n", (draw_polygon ? "On" : "Off" ) );
   printf( " c      - toogle draw circle (%s)\n", (draw_circle ? "On" : "Off" ) );
   printf( " ESC/q  - exit.\n" );
}

void keyPressed( unsigned char key, int x, int y )
{
   keyboard_pgm_exit(key,x,y);
   switch (key)
   {
   case 'h':
   case '?':
      key_help();
      break;
   case 't':
      draw_the_flies = !draw_the_flies;
      printf( " t - toggle draw flies (%s)\n", (draw_the_flies ? "On" : "Off") );
      glutPostRedisplay();
      break;
   case 'T':
      {
         int width = 250;
         int height = 250;
         add_line_display = !add_line_display;
         printf( " T - toggle line display (%s)\n", (add_line_display ? "On" : "Off") );
         // change the width/height back to original
         if( add_line_display ) {
            width = 450;
            height = 150;
         }
         glutReshapeWindow(width,height);

         // and select the appropriate 'display' function
         if( add_line_display )
            glutDisplayFunc(display_lines);
         else {
            if(draw_polygon)
               glutDisplayFunc(display_a_polygon);
            else
               glutDisplayFunc(display_a_square);
         }
         glutPostRedisplay(); // and set for re-display
      }
      break;
   case 'p':
      draw_polygon = !draw_polygon;
      printf( " p - toogle polygon draw (%s)\n", (draw_polygon ? "On" : "Off" ) );
      if( !add_line_display ) {

         if(draw_polygon)
            glutDisplayFunc(display_a_polygon);
         else
            glutDisplayFunc(display_a_square);

         glutPostRedisplay(); // and set for re-display
      }
      break;
   case 'c':
      draw_circle = !draw_circle;
      printf( " c - toogle draw circle (%s)\n", (draw_circle ? "On" : "Off" ) );
      glutPostRedisplay(); // and set for re-display
      break;
   }
}

/* 
 *  Request double buffer display mode.
 *  Register mouse input callback functions
 */
//   case 1:
//    printf("  1: main2(argc,argv);   // lines and line styles\n" );
int main2(int argc, char** argv)
{
   int width = 250;
   int height = 250;

   if( add_line_display ) {
      width = 450;
      height = 150;
   }
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB);
   glutInitWindowSize (width, height); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   if( add_line_display )
      glutDisplayFunc(display_lines);
   else {
      if(draw_polygon)
         glutDisplayFunc(display_a_polygon);
      else
         glutDisplayFunc(display_a_square);
   }
   glutReshapeFunc(reshape); 
   glutMouseFunc(mouse);
   glutKeyboardFunc( keyPressed  );
   key_help();
   glutMainLoop();
   return 0;
}

// establish 'Example' list
enum Example {
   ex_none,
   ex_01, ex_02, ex_03, ex_04, ex_05, ex_06, ex_07, ex_08, ex_09, ex_10,
   ex_11, ex_12, ex_13, ex_14, ex_15, ex_16, ex_17, ex_18, ex_19, ex_20,
   ex_21, ex_22, ex_23, ex_24, ex_25, ex_26, ex_27, ex_28, ex_29, ex_30,
   ex_31, ex_32, ex_33, ex_34, ex_35, ex_36, ex_37, ex_38, ex_39, ex_40,
   ex_max
};

int print_help_item( int item )
{
   printf("%3d", item);
   switch(item)
   {
   case ex_01:
      printf(": main2(argc,argv);   // lines and line styles" );
      break;
   case ex_02:
      printf(": main3(argc,argv);   // simple projected cube" );
      break;
   case ex_03:
      printf(": main35(argc,argv);  // 1/4 of wire sphere shown (glClipPlane)" );
      break;
   case ex_04:
      printf(": main36(argc,argv);  // planet around sun... slowed" );
      break;
   case ex_05:
      printf(": main_dbl_tris(argc, argv); // rotating triangle - slowed to 55ms" );
      break;
   case ex_06:
      printf(": main37(argc,argv);  // animated (very simple) arm" );
      break;
   case ex_07:
      printf(": main38(argc,argv);  // just show MOUSE position on left click" );
   //- right click exit - uses glUnproject to show world coord
      break;
   case ex_08:
      printf(": main41(argc,argv);  // smooth shaded color triangle" );
      break;
   case ex_09:
      printf(": main51(argc,argv);  // lit sphere, animated light source" );
      break;
   case ex_10:
      printf(": main56(argc,argv);  // torus, with moving light source - left click" );
   // c key to make it continuous, with light moving around the torus...
      break;
   case ex_11:
      printf(": main59(argc, argv); // lit sphere, color change on mouse clicks" );
      break;
   case ex_12:
      printf(": main61(argc, argv); // simple colored triangles, with an overlap" );
   // t toggle which is drawn first, changing the 'blended' overlap area color
      break;
   case ex_13:
      printf(": main62(argc, argv); // sphere in front of cube" );
   // solidZ of shpere, and increase tranparency of cube, or vv ;=))
      break;
   case ex_14:
      printf(": main63(argc, argv); // antialiasing - trying to smooth out lines" );
      break;
   case ex_15:
      printf(": main64(argc, argv); // antialiasing - but NO DISPLAY???" );
      break;
   case ex_16:
      printf(": main65(argc, argv); // colorful little cube - on/off smoothing" );
   // but shows no difference in WIN32
      break;
   case ex_17:
      printf(": main66(argc,argv);  // f to toggle FOG mode/type on 5 spheres" );
      break;
   case ex_18:
      printf(": main71(argc,argv);  // torus, rotated using x and y keys" );
      break;
   case ex_19:
      printf(": main72(argc,argv);  // 10 red triangles, using display list" );
      break;
   case ex_20:
      printf(": main75(argc,argv);  // paint some stroked fonts" );
      break;
   case ex_21:
      printf(": main82(argc,argv);  // paint some bitmap (raster) fonts" );
      break;
   case ex_22:
      printf(": main84(argc,argv);  // checker board pattern, copied to mouse click pos" );
      // and can z/Z alter zoom size, and r for reset
      break;
   case ex_23:
      printf(": main91(argc,argv);  // checked image again..." );
      break;
   case ex_24:
      printf(": main93(argc,argv);  // checked image again, with s sub-image added" );
      break;
   case ex_25:
      printf(": main94(argc,argv);  // colored triangles, using mipmapImage..." );
      break;
   case ex_26:
      printf(": main95(argc,argv);  // FAILS!!! using mipmapImage..." );
      break;
   case ex_27:
      printf(": main96(argc,argv);  // adding stripes - e o s x - to teapot" );
      break;
   case ex_28:
      printf(": main101(argc,argv); // sphere, overlaying a torus" );
      break;
   case ex_29:
      printf(": main103(argc,argv); // torus, sphere, cube, ...jitter.h" );
      break;
   case ex_30:
      printf(": main105(argc,argv); // 5 teapots in a row, overlapping" );
      break;
   case ex_31:
      printf(": main114(argc,argv); // four figures - sphere, cylinder, disk, partial disk." );
      break;
   case ex_32:
      printf(": main82b(argc,argv); //  paint some PLIB fonts (txf)" );
      break;
   case ex_33:
      printf(": glut_main33(argc,argv); // paint some bitmap fonts." );
      break;
   case ex_34:
      printf(": main_Koch (argc,argv); // Rotatable Koch snowflake. <Click mouse to form Tri>" );
      break;
   case ex_35:
      printf(": main_polar(argc,argv); // world view n/s poles - mouse rotatable" );
      break;
   case ex_36:
      printf(": glut_main16(argc,argv); // torus, put in motion by mouse click and move" );
      break;
   case ex_37:
      printf(": glut_main37(argc,argv); // loading and using TXF files." );
      break;
   case ex_38:
      printf(": main_textfont01(argc,argv); // original Mark J. Kilgard, 1997 texfont sample." );
      break;
   case ex_39:
      printf(": main_tex02(argc,argv); // another rotating cube, with text on sides" );
      break;
   case ex_40:
      printf(": main_tex03(argc, argv); // load default.txf, out 'OpenGL is best', rotating" );
      break;
   default:
      printf("ERROR: Item %d OUT OF RANGE!\n", item );
      return 0;
      break;
   }
   printf("\n");
   return 1;
}



void give_help(char * name)
{
   int i;
   printf("%s: compiled on %s, at %s\n", g_progname, __DATE__, __TIME__ );
   printf("Version: %s\n", VERSION);
   printf("Contains many different sample OpenGL code. Enter number of example to try...\n" );
   for(i = 1; i < ex_max; i++ )
      print_help_item(i);
   printf("Most sample code taken from\n http://www.glprogramming.com/red/index.html, or from\n" );
   printf(" http://web.mit.edu/course/6/6.837/src-backup/glut-3.7/progs\n" );
   printf("Each 'sample' will exit with ESC, or 'q' keyin...\n" );
   printf("                                      Have fun ;=))\n" );
}

void check_for_help(int argc, char** argv)
{
   int i;
   for( i = 1; i < argc; i++ ) {
      char * arg = argv[i];
      if( strcmp(arg, "?") == 0 ) {
         give_help(argv[0]);
         pgm_exit(0);
      } else if( strcmp(arg, "-h") == 0 ) {
         give_help(argv[0]);
         pgm_exit(0);
      } else if( strcmp(arg, "/h") == 0 ) {
         give_help(argv[0]);
         pgm_exit(0);
      } else if( strcmp(arg, "-?") == 0 ) {
         give_help(argv[0]);
         pgm_exit(0);
      } else if( strcmp(arg, "/?") == 0 ) {
         give_help(argv[0]);
         pgm_exit(0);
      } else if( strcmp(arg, "--help") == 0 ) {
         give_help(argv[0]);
         pgm_exit(0);
      }
   }
}

#ifdef __cplusplus
extern "C" {
#endif
extern int test_TT_2_TXF(void);
#ifdef __cplusplus
}
#endif

int main(int argc_in, char** argv_in)
{
   int i;
   char **argv;
   int argc;
#ifdef NDEBUG
   int select = 0;
#else
   int select = ex_27; // 36;  //40;  // 35;
#endif
   g_progname = strdup(get_file_name_ptr(argv_in[0]));
   CHKMEM(g_progname);

   if( argc_in > 1 ) {
      check_for_help(argc_in,argv_in);
      select = atoi(argv_in[1]);
   }

   // reset the arguments - removing argv[1] - if any
   argv = (char **)malloc( (argc_in+1) * sizeof(void *) );
   CHKMEM(argv);
   argc = 0;
   argv[argc++] = g_progname; // set first argument
   for(i = 2; i < argc_in; i++) {
      argv[argc++] = argv_in[i]; // add from argument 2 onwards
   }
   argv[argc] = 0;   // zero terminate the array
   //test_main_ftgl(argc, argv); // reads TTF turetype font, and write 'F0' txf file
   //test_TT_2_TXF();
   //main_case01(argc, argv);

   print_help_item(select);
   switch(select)
   {
   case ex_01:
      return main2(argc,argv);  // lines and line styles
   case ex_02:
      return main3(argc,argv);   // simple projected cube
   case ex_03:
      return main35(argc,argv);     // 1/4 of wire sphere shown glClipPlane
   case ex_04:
      return main36(argc,argv);  // planet around sun... slowed
   case ex_05:
      return main_dbl_tris(argc, argv);   // rotating triangle - slowed to 55ms
   case ex_06:
      return main37(argc,argv);  // animated arm
   case ex_07:
      return main38(argc,argv);  // just show MOUSE position on left click
      //- right click exit - uses glUnproject to show world coord
   case ex_08:
      return main41(argc,argv);  // smooth shaded color triangle
   case ex_09:
      return main51(argc,argv);  // lit (grey) sphere, animate light source
   case ex_10:
      return main56(argc,argv); // torus, with moving light source - left click
      // c key to make it continuous, with light moving around the torus...
   case ex_11:
      return main59(argc, argv); // lit sphere, color change on mouse clicks
   case ex_12:
      return main61(argc, argv); // simple colored triangles, with an overlap -
      // t toggle which is drawn first, changing the 'blended' overlap area color
   case ex_13:
      return main62(argc, argv); // sphere in front of cube - a will decrease
      // solidZ of shpere, and increase tranparency of cube, or vv ;=))
   case ex_14:
      return main63(argc, argv); // antialiasing - trying to smooth out lines
   case ex_15:
      return main64(argc, argv); // antialiasing - trying to smooth out lines
      // but NO DISPLAY???
   case ex_16:
      return main65(argc, argv); // colorful little cube - on/off smoothing,
      // but shows no difference in WIN32
   case ex_17:
      return main66(argc,argv);  // f to toggle FOG mode/type on 5 spheres
   case ex_18:
      return main71(argc,argv);  // torus, rotated using x and y keys
   case ex_19:
      return main72(argc,argv); // 10 red triangles, using display list
   case ex_20:
      return main75(argc,argv);  // paint some stroked fonts
   case ex_21:
      return main82(argc,argv);  // paint some bitmap (raster) fonts
   case ex_22:
      return main84(argc,argv);  // checker board pattern, copied to mouse click pos,
      // and can z/Z alter zoom size, and r for reset
   case ex_23:
      return main91(argc,argv);  // checked image again...
   case ex_24:
      return main93(argc,argv);  // checked image again, with s sub-image added
   case ex_25:
      return main94(argc,argv);  // colored triangles, using mipmapImage...
   case ex_26:
      return main95(argc,argv);  // FAILS!!! using mipmapImage...
   case ex_27:
      return main96(argc,argv);  // adding stripes - e o s x - to teapot
   case ex_28:
      return main101(argc,argv);  // sphere, overlaying a torus
   case ex_29:
      return main103(argc,argv);    // torus, sphere, cube, ... jitter.h
   case ex_30:
      return main105(argc,argv); // 5 teapots in a row, overlapping
   case ex_31:
      return main114(argc,argv); // four figures - sphere, cylinder, disk, partial disk.\n" );
   case ex_32:
      return main82b(argc,argv); //  paint some PLIB fonts (txf)" );
   case ex_33:
      return glut_main33(argc,argv); // paint some bitmap fonts
   case ex_34:
      return main_Koch (argc,argv); // "Rotatable Koch snowflake. <Click mouse to form Tri>"
   case ex_35:
      return main_polar(argc, argv ); // world view n/s poles - mouse rotatable\n" );
   case ex_36:
      return glut_main16(argc,argv); // torus, put in motion by mouse click and move
   case ex_37:
      return glut_main37(argc,argv); // loading and using TXF files = FAILS
   case ex_38:
      return main_textfont01(argc,argv); // original Mark J. Kilgard, 1997 texfont sample.
   case ex_39:
      return main_tex02(argc,argv); // another rotating cube, with text on sides
   case ex_40:
      return main_tex03(argc, argv); // load default.txf, out 'OpenGL is best', rotating
   default:
      printf("ERROR: Unknown argument [%s]\n",
         (argv[1] ? argv[1] : "NONE GIVEN") );
      give_help(argv[0]);
      pgm_exit(1);
   }
   return 0;
}  

void pgm_exit(int val)
{
   exit(val);
}


// eif -ogl02.cxx
